#ifndef _TestComponent_h
#define _TestComponent_h

#include <cisstMultiTask.h>
#include <cisstParameterTypes.h>
#include <cisstVector.h>
#include <iostream>

using namespace std;

const unsigned int N = 5;

class QueueEmptyException
{
public:
	QueueEmptyException()
	{
	cout<<"Queue Empty"<<endl;
	}
};

class MarkerPosQueue
{
private:
	double data[100],Position[3],Rotation[3];
	int front;
	int rear;
	//declare vector for queue as data[dynamic size]
public:
	MarkerPosQueue()
	{
		front = -1;
		rear = -1;
	}

	void Enqueue(double element)
	{
		data[rear] = element;
		rear = ++rear;
	}

	double Dequeue()
	{
		if (isEmpty())
			throw new QueueEmptyException();
		double ret = data[front];
		front = ++front;
		return ret;
	}

	double Front()
	{
		if (isEmpty())
			throw new QueueEmptyException();
		return data[front];
	}

	bool isEmpty()
	{
		return(front==rear) ? true : false;
	}
};


class Goal_Pos
{
private:
	vctDouble3 marker1,marker2;
	//int data;
	Goal_Pos* nextMarker1;
	Goal_Pos* nextMarker2;
	bool reachedMarker1,reachedMarker2;
	
public:
	Goal_Pos(){	reachedMarker1 = false; reachedMarker2 = false; nextMarker1 = NULL; nextMarker2 = NULL;};
	vctDouble3 Marker1(){	return marker1; };
	vctDouble3 Marker2(){	return marker2; };
	void setMarker1(vctDouble3 marker){ marker1 = marker; };
	void setMarker2(vctDouble3 marker){ marker2 = marker; };
	
	bool IsReachedMarker1(){ return reachedMarker1; };
	bool IsReachedMarker2(){ return reachedMarker2; };

	void setReachedMarker1(bool reach){ reachedMarker1 = reach; };
	void setReachedMarker2(bool reach){ reachedMarker2 = reach; };
	
	Goal_Pos* NextMarker1(){ return nextMarker1;};
	Goal_Pos* NextMarker2(){ return nextMarker2;};
	
	void setNextMarker1(Goal_Pos* next){ nextMarker1 = next;};
	void setNextMarker2(Goal_Pos* next){ nextMarker2 = next;};
};




class TestComponent: public mtsTaskPeriodic
{
protected:
    mtsInterfaceRequired * Robot;

    // Functions to access Robot
    mtsFunctionRead  GetPositionJoint;
    mtsFunctionRead  GetPositionCartesian;
    mtsFunctionWrite SetPositionJoint;
    mtsFunctionWrite SetPositionCartesian;
    mtsFunctionRead  GetForceSensor;
    mtsFunctionRead  GetForceWorld;
    mtsFunctionRead  IsMoving;
    mtsFunctionWrite SetSpeed;
    mtsFunctionWrite SetAccel;
    mtsFunctionWrite SetDecel;
    mtsFunctionVoid  StartUp;
    mtsFunctionVoid  Shutdown;
    mtsFunctionRead  GetPowerStatus;
    mtsFunctionVoid  Home;
    mtsFunctionVoid  StopMove;
    mtsFunctionVoid  BiasForces;
    mtsFunctionRead  GetToolDH;
    mtsFunctionWrite SetToolDH;

    // Payloads
    prmPositionJointGet      PositionJoint;
    prmPositionCartesianGet  PositionCartesian;
    prmPositionJointSet      PositionJointSet;
    prmPositionCartesianSet  PositionCartesianSet;

    prmForceCartesianGet     ForceSensor;   // Force in force sensor coordinate frame
    prmForceCartesianGet     ForceWorld;    // Force in world coordinate frame

    double                   Speed, Accel, Decel;
    vctDynamicVector<double> q1, q2,WorkSpaceViewPos;
    vctDouble3               p2,Position_RobotProbeTip,Pose,Position_FreeProbeTip,TetTrans,tr;
    bool                     PowerStatus;
    vct4                     DHGet, DHSet;
	vctDouble3 Position,Rotation,DistET,PhantomDia,DistEndEffRobProbeTip;
	vctDouble3 x,TeginverseTrans,Dist;
	vctFrm3 GoalRobot1,GoalRobot,EndEffPos,goal;
	vctMatRot3 matrixRot1,matrixRotET;
	vctFrm3 Tfix,fd;
	double d[3];
	double roll,pitch,yaw;
	mtsFrm3 frame,frameCurr;

	//vctDouble3 Position_RobotProbeTip;
	
public:
    TestComponent(const std::string &taskName);
    ~TestComponent();
    void Configure(const std::string &filename = "") {}
    void Startup(void);
    void Run(void);
    void Cleanup(void) {};

	bool CheckIfReached();
	void FreeHandMove();
	
	//void Algorithm(void);

};

#endif // _TestComponent_h
