#include <iostream>
#include <conio.h>
#include <cisstVector.h>
#include <cisstMultiTask.h>
#include <cisstParameterTypes.h>
using namespace std;
#include <cisstOSAbstraction/osaSleep.h>
#include "TestComponent.h"
double i = 0.0;
long int j=1,k=0;
int k1 = 0,karma=0,ll=0;
int flagMarker=0,flagReachedLimit = 0,FlagGoal=0;
int divid = 2;

// helper macro to add function easily
#define ADD_FUNCTION( _name ) Robot->AddFunction(#_name, _name)
//////////////////////////////////////////////////////////

#include "../MTC.h" //MTC.h need to be in the local directory or include path


//Macro to check for and report MTC usage errors.
#define MTC(func) {int r = func; if (r!=mtOK) printf("MTC error: %s\n",MTLastErrorString()); };

#ifdef WIN32
int getMTHome (  char *sMTHome, int size ); //Forward declaration
#endif

int freeHandState = 0;

double	p1[3], Angle[3];
mtHandle PoseXf = Xform3D_New();
mtHandle CurrCamera, IdentifyingCamera;
mtHandle IdentifiedMarkers = Collection_New();

//////////////////////////////////////////////////////////

TestComponent::TestComponent(const std::string & taskName):
mtsTaskPeriodic(taskName, 0.1)
//mtsTaskPeriodic(taskName, 0.01)
{
	Robot = AddInterfaceRequired("Robot", MTS_REQUIRED);
	CMN_ASSERT(Robot);

	// Standardized commands
	ADD_FUNCTION(GetPositionJoint);
	ADD_FUNCTION(GetPositionCartesian);
	ADD_FUNCTION(SetPositionJoint);
	ADD_FUNCTION(SetPositionCartesian);

	// Standardized payloads
	ADD_FUNCTION(GetForceSensor);
	ADD_FUNCTION(GetForceWorld);

	// Misc.
	ADD_FUNCTION(IsMoving);
	ADD_FUNCTION(SetSpeed);
	ADD_FUNCTION(SetAccel);
	ADD_FUNCTION(SetDecel);
	Robot->AddFunction("Startup", StartUp);
	ADD_FUNCTION(Shutdown);
	ADD_FUNCTION(GetPowerStatus);
	ADD_FUNCTION(Home);
	ADD_FUNCTION(StopMove);
	ADD_FUNCTION(BiasForces);
	ADD_FUNCTION(GetToolDH);
	ADD_FUNCTION(SetToolDH);
}

TestComponent::~TestComponent()
{
	if (Robot)
		delete Robot;
}

bool TestComponent::CheckIfReached()
{
	mtsFrm3 frame;
	PositionCartesian.GetPosition(frame);
	GetPositionJoint(PositionJoint);
		if(j%2000 == 0)
	{
		cout<<"C: "<<frame.Translation()<<endl;
		cout<< "G: " << GoalRobot.Translation() << endl;
		cout << ">>>>>>>>> set goal pos: " << GoalRobot.Translation() << std::endl;
		PositionCartesianSet.SetGoal(GoalRobot.Translation());
		SetPositionCartesian(PositionCartesianSet);

		cout<< "\nDifference between current and goal position\n" << abs(frame.Translation()[0] - GoalRobot.Translation()[0])<<"\t"<<abs(frame.Translation()[1] - GoalRobot.Translation()[1])<<"\t"<<abs(frame.Translation()[2] - GoalRobot.Translation()[2])<<endl;  
	}
	if(abs(frame.Translation()[0] - GoalRobot.Translation()[0]) < 1.0 && abs(frame.Translation()[1] - GoalRobot.Translation()[1]) < 1.0 && abs(frame.Translation()[2] - GoalRobot.Translation()[2]) < 1.0)
	{
		//if(abs(frame.Rotation()[0][0] -  GoalRobot.Rotation()[0][0]) < 0.05 && abs(frame.Rotation()[1][0] -  GoalRobot.Rotation()[2][0]) < 0.05 && abs(frame.Rotation()[0][2] -  GoalRobot.Rotation()[0][2]) < 0.05 && abs(frame.Rotation()[1][0] -  GoalRobot.Rotation()[1][0]) < 0.05 && abs(frame.Rotation()[1][1] -  GoalRobot.Rotation()[1][1]) < 0.05 && abs(frame.Rotation()[1][2] -  GoalRobot.Rotation()[1][2]) < 0.05  && abs(frame.Rotation()[2][0] -  GoalRobot.Rotation()[2][0]) < 0.05 && abs(frame.Rotation()[2][1] -  GoalRobot.Rotation()[2][1]) < 0.05 && abs(frame.Rotation()[2][2] -  GoalRobot.Rotation()[2][2]) < 0.05)
		{
			cout<<"\n TRUE \n"<<endl;
			return true;
			
		}
	}
	return false;

}

void TestComponent::Startup(void) 
{

		///////////////////////////////////////////////////////////

	{	printf("\n Simple MicronTracker app");
	printf("\n==========================\n");

	//Connect to the available cameras, and report on what was found
	//The first camera is designated as the "current" camera - we will use its coordinate
	//space in reporting pose measurements.
	char MTHome[512];
	char calibrationDir[512];
	char markerDir[512];


#ifdef WIN32
	if ( getMTHome (MTHome, sizeof(MTHome)) < 0 ) {
		// No Environment
		printf("MTHome environment variable is not set!\n");
		//		return 0;
	} else {
		sprintf(calibrationDir,"%s\\CalibrationFiles",MTHome);
		sprintf(markerDir,"%s\\Markers",MTHome);
	}
#else  //Linux & Mac OSX
	sprintf(calibrationDir,"../CalibrationFiles");
	sprintf(markerDir,"../Markers");
#endif

	MTC( Cameras_AttachAvailableCameras(calibrationDir) ); //Path to directory where the calibration files are
	if (Cameras_Count() < 1) {
		printf("No camera found!\n");
		//		return 0;
	}
	/*mtHandle CurrCamera, IdentifyingCamera;*/
	int		CurrCameraSerialNum;
	MTC( Cameras_ItemGet(0, &CurrCamera) ); //Obtain a handle to the first/only camera in the array
	MTC( Camera_SerialNumberGet(CurrCamera, &CurrCameraSerialNum) ); //obtain its serial number
	printf("Attached %d camera(s). Curr camera is %d\n", Cameras_Count(), CurrCameraSerialNum);

	//Load the marker templates (with no validation).
	MTC( Markers_LoadTemplates(markerDir) ); //Path to directory where the marker templates are
	printf("Loaded %d marker templates\n",Markers_TemplatesCount());
	//Create objects to receive the measurement results
	//mtHandle IdentifiedMarkers = Collection_New();
	//mtHandle PoseXf = Xform3D_New();
	}

	osaSleep(2.0);  // Wait for startup messages to be displayed


	d[0] = 0.1139;
	d[1] = -5.9878;
	d[2] = 27.1232;

	DistEndEffRobProbeTip[0] = 0.0;
	DistEndEffRobProbeTip[1] = -15.5;
	DistEndEffRobProbeTip[2] = -350.5;

	PhantomDia[0] = 0.0;
	PhantomDia[1] = 190.5;//155.0;
	PhantomDia[2] = 0.0;

	WorkSpaceViewPos.SetSize(N);

	WorkSpaceViewPos[0] = 40;
	WorkSpaceViewPos[1] = 40;
	WorkSpaceViewPos[2] = -150;
	WorkSpaceViewPos[3] = -50;
	WorkSpaceViewPos[4] = 0;

	/*WorkSpaceViewPos[0] = 70;
	WorkSpaceViewPos[1] = 30;
	WorkSpaceViewPos[2] = -100;
	WorkSpaceViewPos[3] = -10;
	WorkSpaceViewPos[4] = 0;
	*/

	DistET[0] = 30.0;
	DistET[1] = 0.0;
	DistET[2] = 155.1;

	Position_FreeProbeTip[0] = -9.3214;
	Position_FreeProbeTip[1] = 175.9804;
	Position_FreeProbeTip[2] = -52.2376;

	Speed = 0.05 * 2;
	Accel = 0.05 * 2;
	Decel = 0.05 * 2;

	DHGet.SetAll(0.0);
	DHSet.SetAll(0.1);

	Pose[0] = -7.2923 ;
	Pose[1] = 190.1900 ;
	Pose[2] = -51.0521 ;
}

void TestComponent::FreeHandMove(void)
{
	cout << ".";
	GetPowerStatus(PowerStatus);
	
	if(kbhit())
	{
		StopMove();
		// ENTER COMMAND TO STOP THE MICRON TRACKER FROM WORKING
		cout<<"\n\a\a EXITING AS YOU PRESSED A KEY TO QUIT CASE 3 EXECUTION \a\a"<<endl;
		freeHandState = 0;
		return;
	}

	/*	if(current position - previous position are same)
	{
	GoalRobot = Tbe;
	PositionCartesianSet.SetGoal(GoalRobot);
	SetPositionCartesian(PositionCartesianSet);
	}*/

	GetPositionCartesian(PositionCartesian);
	mtsFrm3 curPos1;
	PositionCartesian.GetPosition(curPos1);
	//cout<<"\n curPos1 \n"<<curPos1;
	mtsFrm3 PrevPos;
	{
		//cout<<" j"<<j<<endl;
		GetPositionCartesian(PositionCartesian);

		PositionCartesian.GetPosition(PrevPos);
		//cout<<"\n PrevPos \n"<<PrevPos;
	}
	
	if(CheckIfReached() || j == 1 || flagMarker == 1)
	{
		std::cout << "#";
		flagReachedLimit = 0;

		i=2.5;
	
		//*********************************************************************************************
		MTC( Cameras_GrabFrame(NULL) ); //Grab a frame (all cameras together)
		MTC( Markers_ProcessFrame(NULL) ); //Proces the frame(s) to obtain measurements
		//if(j==1)
		//	if (r<20) continue; //the first 20 frames are auto-adjustment frames, and would be ignored here
		////Here, MTC internally maintains the measurement results.
		//Those results can be accessed until the next call to Markers_ProcessFrame, when they
		//are updated to reflect the next frame's content.
		//First, we will obtain the collection of the markers that were identified.
		MTC( Markers_IdentifiedMarkersGet(NULL, IdentifiedMarkers) );
		//printf("%d: identified %d marker(s)\n", r, Collection_Count(IdentifiedMarkers));
		//Now we iterate on the identified markers (if any), and report their name and their pose
		for (int s=1; s<=Collection_Count(IdentifiedMarkers); s++) {
			//Obtain the marker's handle, and use it to obtain the pose in the current camera's space
			//  using our Xform3D object, PoseXf.
			mtHandle Marker = Collection_Int(IdentifiedMarkers, s);
			MTC( Marker_Marker2CameraXfGet (Marker, CurrCamera, PoseXf, &IdentifyingCamera) );
			//We check the IdentifyingCamera output to find out if the pose is, indeed,
			//available in the current camera space. If IdentifyingCamera==0, the current camera's
			//coordinate space is not registered with any of the cameras which actually identified
			//the marker.
			if (IdentifyingCamera != 0) { 
				char MarkerName[MT_MAX_STRING_LENGTH];

				//We will also check and report any measurement hazard
				mtMeasurementHazardCode Hazard; 
				MTC( Marker_NameGet(Marker, MarkerName, MT_MAX_STRING_LENGTH, 0) );
				MTC( Xform3D_ShiftGet(PoseXf, p1) );
				//Here we obtain the rotation as a sequence of 3 angles. Often, it is more convenient
				//(and slightly more accurage) access the rotation as a 3x3 rotation matrix.
				MTC( Xform3D_RotAnglesDegsGet(PoseXf, &Angle[0], &Angle[1], &Angle[2]) );
				MTC( Xform3D_HazardCodeGet(PoseXf, &Hazard) );
				//Print the report
				/*		printf(">> %s at (%0.2f, %0.2f, %0.2f), rotation (degs): (%0.1f, %0.1f, %0.1f) %s\n", 
				MarkerName, 
				p1[0], p1[1], p1[2], 
				Angle[0], Angle[1], Angle[2],
				MTHazardCodeString(Hazard));*/
			}

		}
		Position[0] = p1[0];
		Position[1] = p1[1];
		Position[2] = p1[2];
		Rotation[0] = Angle[0]*3.14/180;
		Rotation[1] = Angle[1]*3.14/180;
		Rotation[2] = Angle[2]*3.14/180;



		cout<<"\n \n Position of Marker \n \n"<<Position;
		cout<<"Difference "<<abs(Position[0] - 0.0)<<abs(Position[1] - 0.0)<<abs(Position[2] - 0.0);

		cout<<"\n \n Position of Marker \n \n"<<Position;
		cout<<"Difference "<<abs(Position[0] - 0.0)<<abs(Position[1] - 0.0)<<abs(Position[2] - 0.0);

		if(abs(Position[0] - 0.0) < 1.0 && abs(Position[1] - 0.0) < 1.0 && abs(Position[2] - 0.0) < 1.0)
		{
			cout<<endl<<"Please Place Free Hand Probe in the View of Micron Tracker"<<endl;
			flagMarker = 1;
			StopMove();
		}
		else
			flagMarker = 0;
		
		if(flagMarker == 0 )
		{

			//**********************************************
			//GET TRANSFORMATION BETWEEN END EFFECTOR AND OPTICAL TRACKER THROUGH GEOMETRY

			vctMatRot3 aRot(-0.1019,0.2707,-0.9838,
				1.0241,0.0198,-0.1156,
				0.0254,-0.9902,-0.2682,VCT_NORMALIZE);
			vctDouble3 aTrans(-318.2332,-17.1154,280.6833);
			vctFrm3 Tet(aRot,aTrans);


			//cout<<"\n\n Tet \n\n"<<Tet;
			//**********************************************

			// THIS LOOP HELPS IN ASSIGNING THE VALUES TO THE GOAL POSITION OF PROBE

			//TRANSFORMATION BETWEEN FREE HAND MARKER AND OPTICAL TRACKER

			//Getting rotation part of the matrix initialize an axis-angle rotation object by specifying the axis as a vector and the angle in radians
			vctAxAnRot3 axAnRot_x( vct3(1.0, 0.0, 0.0), Rotation[0] );
			// create a matrix rotation initialized with the axis-angle rotation.
			vctMatRot3 matrixRot_x( axAnRot_x );
			vctAxAnRot3 axAnRot_y( vct3(0.0, 1.0, 0.0), Rotation[1] );
			vctMatRot3 matrixRot_y( axAnRot_y );
			vctAxAnRot3 axAnRot_z( vct3(0.0, 0.0, 1.0), Rotation[2] );
			vctMatRot3 matrixRot_z( axAnRot_z );
		/*	vctMatRot3 matrixRot(0.9899,0.0315,-0.1365,
				-0.0460,0.9894,-0.1106,
				0.1316,0.1255,0.9867,VCT_NORMALIZE);*/
			vctMatRot3 matrixRot;
			matrixRot = matrixRot_z*matrixRot_y*matrixRot_x;
			vctFrm3 Transformation_Camera_FreeProbe(matrixRot, Position);
			//cout<<"\n\n Transformation_Camera_FreeProbe \n\n"<<Transformation_Camera_FreeProbe;
			//POSITION OF FREE HAND PROBE TIP WRT OPTICAL TRACKER
			vctMatRot3 matrixRotFreeProbeTip(0.0676,-0.1905,0.9794,								
				-0.9742,0.1992,0.1060,
				-0.2153,-0.9613,-0.1722,VCT_NORMALIZE); 
			//matrixRotFreeProbeTip = matrixRot*matrixRot_xM;

			vctFrm3 Transformation_Marker_Free_Probe_Tip(matrixRotFreeProbeTip,Position_FreeProbeTip);
			//cout<<"\n\n Transformation_Marker_Free_Probe_Tip \n\n"<<Transformation_Marker_Free_Probe_Tip;

			//POSITION OF ROBOT PROBE TIP wrt OPTICAL TRACKER NO wrt FREE HAND PROBE TIP

			
			vctAxAnRot3 axAnRot_xRPT( vct3(0.0, 0.0, 1.0), 3.14 );
			vctMatRot3 matrixRot_xRPT( axAnRot_xRPT );
			vctMatRot3 matrixRotRobotProbeTip ;
			matrixRotRobotProbeTip = matrixRot_xRPT;
			//matrixRotRobotProbeTip = matrixRotFreeProbeTip * matrixRot_xRPT;
			vctFrm3 Transformation_Robot_Probe_Tip(matrixRotRobotProbeTip,PhantomDia);
			//cout<<"\n\n Transformation_Robot_Probe_Tip\n\n"<<Transformation_Robot_Probe_Tip;

			
			//TRANFORMATION BETWEEN MICRON TRACKER AND ROBOT PROBE TIP
			
			vctMatRot3 MicronRobotProbeTip_rot(0.0656,0.0511,-0.9964,
				-0.9432,-0.3122,-0.0789,
				-0.3258,0.9486,0.0277,VCT_NORMALIZE);
			vctDouble3 MicronRobotProbeTip_trans(-9.7814,231.5941,316.2877);
			vctFrm3 MicronRobotProbeTip(MicronRobotProbeTip_rot,MicronRobotProbeTip_trans);

			//cout<<"\n\n MicronRobotProbeTip \n"<<MicronRobotProbeTip<<endl;
				vctAxAnRot3 axAnRot_yREG( vct3(0.0, 1.0, 0.0), 3.14 );
			vctMatRot3 matrixRot_yREG( axAnRot_yREG);
			vctMatRot3 TTRot ;
			TTRot= matrixRot_yREG;
			vctDouble3 zero(0.0,0.0,0.0);
			//matrixRotRobotProbeTip = matrixRotFreeProbeTip * matrixRot_xRPT;
			vctFrm3 TT(TTRot,zero);

			vctFrm3 TEG;
			TEG = Tet * MicronRobotProbeTip * TT; 
			//cout<<"TEG"<<TEG<<endl;

			vctFrm3 TEGinverse;
			TEGinverse = TEG.Inverse();
			//cout<<"TEGinverse"<<TEGinverse<<endl;

			//cout<<"Robot Endeffector in optcoords \n\n"<<Transformation_Robot_Probe_Tip*TEGinverse;
			//**********************************************
			//osaSleep(2.0);
			//GET CURRENT POSITION OF THE ROBOT ENDEFFECTOR

			//mtsDoubleFrm3 Tbe;

			GetPositionCartesian(PositionCartesian);
			//cout<<"Pos"<<PositionCartesian;
			//cout<<"\n\n Tbe \n\n"<<Tbe;

			mtsFrm3 Tbe;
			PositionCartesian.GetPosition(Tbe);
			cout<<"\n Tbe \n"<<Tbe;
			if(j==1)
				Tfix= Tbe;
			//**************************************
			// CALCULATION OF POSITION OF END EFFECTOR IN ROBOT COORDINATES

			karma++;
			//cout<<"karma"<<karma<<endl;
			GoalRobot1 = Tbe * Tet * Transformation_Camera_FreeProbe * Transformation_Marker_Free_Probe_Tip * Transformation_Robot_Probe_Tip * TEGinverse;
			//cout<<"\n\n ########### GoalRobot1 \n\n"<<GoalRobot1;
			roll = atan2(GoalRobot1.Rotation()[2][1],GoalRobot1.Rotation()[2][2]); //angle with x

			pitch = asin(-GoalRobot.Rotation()[2][0]);            //theta angle with y
			
			yaw   = atan2(GoalRobot1.Rotation()[1][0], GoalRobot1.Rotation()[0][0]);      //angle wiht z

			GoalRobot.Translation() =GoalRobot1.Translation();
			
			//double LK = GoalRobot.Translation()[2] - Tbe.Translation()[2]; 
			//GoalRobot.Translation()[2] = Tbe.Translation()[2] - LK;


			vctAxAnRot3 axAnRot_zg( vct3(0.0, 0.0, 1.0), yaw);
			// create a matrix rotation initialized with the axis-angle rotation.
			vctMatRot3 matrixRot_zg( axAnRot_zg );
			vctAxAnRot3 axAnRot_yg( vct3(0.0, 1.0, 0.0), pitch);
			vctMatRot3 matrixRot_yg( axAnRot_yg );
			vctMatRot3 matrix;
			matrix = matrixRot_zg * matrixRot_yg;
			GoalRobot.Rotation() = matrix;

			//cout<<"\n\n GoalRobot \n\n"<<GoalRobot;


			double x = GoalRobot.Translation()[0];
			double y = GoalRobot.Translation()[1];
			double z = GoalRobot.Translation()[2];

			//bool goalOutOfWorkspace = (x<55.0 || x>555.0 || y>740.0 || z<-240.0 || z>-10.0);
			/*
			bool goalOutOfWorkspace = ((x<-100.0 || x> 555.0) ||
			(y<300.0 || y> 740.0) ||
			(z<-570.0 || z>-340.0));
			*/
			/*
			bool goalOutOfWorkspace = (x>-100.0 ||
			(y <150.0 || y> 740.0) ||
			(z<-570.0 || z>-340.0));
			*/
			bool goalOutOfWorkspace = false;
			if(j>2 && FlagGoal == 0 && flagMarker == 0 && goalOutOfWorkspace )
			{
				cout<<"GoalRobot.Translation"<<GoalRobot.Translation()<<endl;
				flagReachedLimit = 1;
				StopMove();
				osaSleep(1);
				PositionJointSet.SetSize(5);
				WorkSpaceViewPos[1] = 40;
				WorkSpaceViewPos[0] = 40;
				PositionJointSet.SetGoal(WorkSpaceViewPos);
				PositionJointSet.SetValid(true);
				SetPositionJoint(PositionJointSet);
				cout<<"\n\n Goal Out of Bounds, Please Try again \n\n"<<endl;
				//cout<<j;
				//while(j%2000 != 0){j++;}
				//break;
				freeHandState = 0;
				return;
			}


			PositionCartesianSet.SetGoal(GoalRobot.Translation());

			//cout << "######### set goal pos: " << PositionCartesianSet << std::endl;
			cout << "######### set goal pos: \n" << GoalRobot << std::endl;
			SetPositionCartesian(PositionCartesianSet);

		
			vctFrm3 FreeProMicron;
			FreeProMicron = Transformation_Camera_FreeProbe * Transformation_Marker_Free_Probe_Tip ;

			//cout<< " ######## FreeProPositionMicron: \n " << FreeProMicron << endl;

			vctFrm3 RobProMicron;
			RobProMicron = Transformation_Camera_FreeProbe * Transformation_Marker_Free_Probe_Tip * Transformation_Robot_Probe_Tip ;

			//cout<< " ######## RobProPositionMicron: \n " << RobProMicron << endl;

		}

		}

	GetPositionCartesian(PositionCartesian);
	j++;
}

void TestComponent::Run(void)
{
	int option;

	try {
		ProcessQueuedCommands();
		ProcessQueuedEvents();

		if (freeHandState == 1) {
			FreeHandMove();
			return;
		}

		osaSleep(0.5);  // Wait for startup messages to be displayed
		cout << endl << endl;
		cout << "Select option:" << endl;
		cout << "  0) Quit" << endl;
		cout << "  1) Homing the robot" << endl;
		cout << "  2) Move robot to Workspace View" << endl;
		cout << "  3) Commence Free hand Probe Following" << endl;
		cout << "  4) StartUp" << endl;
		cout << "  5) Shutdown" << endl;
		cout << "  6) StopMove" << endl;
		cout << "  7) Get  Current Position" << endl;
		cout << "  8) Move robot to another pose" << endl;
		cout << "  9) Test Accuracy of hand eye Calibration" << endl;
		cout << "? ";
		cin >> option;
		if (cin.good()) {
			switch (option) {
			case 0: Cameras_Detach(); exit(0);
				break;
			case 1: cout << "Homing" << endl;
				Home();
				osaSleep(1.0);
				break;
			case 2: PositionJointSet.SetSize(5);
				//WorkSpaceViewPos[1] = 40;
				//WorkSpaceViewPos[0] = 40;
				PositionJointSet.SetGoal(WorkSpaceViewPos);
				PositionJointSet.SetValid(true);
				SetPositionJoint(PositionJointSet);
				cout << "Moving robot to Workspace View = " << WorkSpaceViewPos<< endl;
				break;
			case 3: 
				j=1;karma=0;
				//cout<<j;
				freeHandState = 1;
				break;

			case 4: StartUp();
				cout << "Start up" << endl;
				osaSleep(1.0);
				GetPowerStatus(PowerStatus);
				cout << "Power status = " << (PowerStatus ? "ON" : "OFF") << endl;
				break;
			case 5: Shutdown();
				cout << "Shutdown" << endl;
				break;
			case 6: StopMove();
				cout << "Stopped robot motion" << endl;
				break;
			case 7: GetPositionCartesian(PositionCartesian);
				/*mtsFrm3 curPo;
				PositionCartesian.GetPosition(curPo);*/
				cout<<"\n curPo \n"<<PositionCartesian;
				break;
			case 8: PositionJointSet.SetSize(5);
				WorkSpaceViewPos[0] = 90;
				WorkSpaceViewPos[1] = 0;
				WorkSpaceViewPos[2] = -250;
				WorkSpaceViewPos[3] = 0;
				WorkSpaceViewPos[4] = -50;
				PositionJointSet.SetGoal(WorkSpaceViewPos);
				PositionJointSet.SetValid(true);
				SetPositionJoint(PositionJointSet);
				cout << "Moving robot to Workspace View = " << WorkSpaceViewPos<< endl;
				break;
			case 9: //Read the marker placed in front, read locTrans, locRot
				while(k1<1000)
				{
					if(k1==1)
					{

							//*********************************************************************************************
		MTC( Cameras_GrabFrame(NULL) ); //Grab a frame (all cameras together)
		MTC( Markers_ProcessFrame(NULL) ); //Proces the frame(s) to obtain measurements
		//if(j==1)
		//	if (r<20) continue; //the first 20 frames are auto-adjustment frames, and would be ignored here
		////Here, MTC internally maintains the measurement results.
		//Those results can be accessed until the next call to Markers_ProcessFrame, when they
		//are updated to reflect the next frame's content.
		//First, we will obtain the collection of the markers that were identified.
		MTC( Markers_IdentifiedMarkersGet(NULL, IdentifiedMarkers) );
		//printf("%d: identified %d marker(s)\n", r, Collection_Count(IdentifiedMarkers));
		//Now we iterate on the identified markers (if any), and report their name and their pose
		for (int s=1; s<=Collection_Count(IdentifiedMarkers); s++) {
			//Obtain the marker's handle, and use it to obtain the pose in the current camera's space
			//  using our Xform3D object, PoseXf.
			mtHandle Marker = Collection_Int(IdentifiedMarkers, s);
			MTC( Marker_Marker2CameraXfGet (Marker, CurrCamera, PoseXf, &IdentifyingCamera) );
			//We check the IdentifyingCamera output to find out if the pose is, indeed,
			//available in the current camera space. If IdentifyingCamera==0, the current camera's
			//coordinate space is not registered with any of the cameras which actually identified
			//the marker.
			if (IdentifyingCamera != 0) { 
				char MarkerName[MT_MAX_STRING_LENGTH];

				//We will also check and report any measurement hazard
				mtMeasurementHazardCode Hazard; 
				MTC( Marker_NameGet(Marker, MarkerName, MT_MAX_STRING_LENGTH, 0) );
				MTC( Xform3D_ShiftGet(PoseXf, p1) );
				//Here we obtain the rotation as a sequence of 3 angles. Often, it is more convenient
				//(and slightly more accurage) access the rotation as a 3x3 rotation matrix.
				MTC( Xform3D_RotAnglesDegsGet(PoseXf, &Angle[0], &Angle[1], &Angle[2]) );
				MTC( Xform3D_HazardCodeGet(PoseXf, &Hazard) );
				//Print the report
				/*		printf(">> %s at (%0.2f, %0.2f, %0.2f), rotation (degs): (%0.1f, %0.1f, %0.1f) %s\n", 
				MarkerName, 
				p1[0], p1[1], p1[2], 
				Angle[0], Angle[1], Angle[2],
				MTHazardCodeString(Hazard));*/
			}

		}
		Position[0] = p1[0];
		Position[1] = p1[1];
		Position[2] = p1[2];
		Rotation[0] = Angle[0]*3.14/180;
		Rotation[1] = Angle[1]*3.14/180;
		Rotation[2] = Angle[2]*3.14/180;



		cout<<"\n \n Position of Marker \n \n"<<Position;
		cout<<"Difference "<<abs(Position[0] - 0.0)<<abs(Position[1] - 0.0)<<abs(Position[2] - 0.0);


		vctAxAnRot3 axAnRot_x( vct3(1.0, 0.0, 0.0), Rotation[0] );
		// create a matrix rotation initialized with the axis-angle rotation.
		vctMatRot3 matrixRot_x( axAnRot_x );
		vctAxAnRot3 axAnRot_y( vct3(0.0, 1.0, 0.0), Rotation[1] );
		vctMatRot3 matrixRot_y( axAnRot_y );
		vctAxAnRot3 axAnRot_z( vct3(0.0, 0.0, 1.0), Rotation[2] );
		vctMatRot3 matrixRot_z( axAnRot_z );
		/*	vctMatRot3 matrixRot(0.9899,0.0315,-0.1365,
		-0.0460,0.9894,-0.1106,
		0.1316,0.1255,0.9867,VCT_NORMALIZE);*/
		vctMatRot3 matrixRot;
		matrixRot = matrixRot_z*matrixRot_y*matrixRot_x;
		vctFrm3 Transformation_Camera_FreeProbe(matrixRot, Position);
	cout<<"Transformation_Camera_FreeProbe \n"<<Transformation_Camera_FreeProbe<<endl;
	
			vctMatRot3 aRot(-0.1019,0.2707,-0.9838,
				1.0241,0.0198,-0.1156,
				0.0254,-0.9902,-0.2682,VCT_NORMALIZE);
			vctDouble3 aTrans(-318.2332,-17.1154,280.6833);
			vctFrm3 Tet(aRot,aTrans);
						cout<<"\n Tet \n"<<Tet<<endl;

						GetPositionCartesian(PositionCartesian);
						//cout<<"Pos"<<PositionCartesian;
						//cout<<"\n\n Tbe \n\n"<<Tbe;

						mtsFrm3 Tbe;
						PositionCartesian.GetPosition(Tbe);
						cout<<"\n Tbe \n"<<Tbe<<endl;


									vctMatRot3 MicronRobotProbeTip_rot(0.0656,0.0511,-0.9964,
				-0.9432,-0.3122,-0.0789,
				-0.3258,0.9486,0.0277,VCT_NORMALIZE);
			vctDouble3 MicronRobotProbeTip_trans(-9.7814,231.5941,316.2877);
			vctFrm3 MicronRobotProbeTip(MicronRobotProbeTip_rot,MicronRobotProbeTip_trans);

			vctAxAnRot3 axAnRot_yREG( vct3(0.0, 1.0, 0.0), 3.14 );
			vctMatRot3 matrixRot_yREG( axAnRot_yREG);
			vctMatRot3 TTRot ;
			TTRot= matrixRot_yREG;
			vctDouble3 zero(0.0,0.0,0.0);
			//matrixRotRobotProbeTip = matrixRotFreeProbeTip * matrixRot_xRPT;
			vctFrm3 TT(TTRot,zero);

			vctFrm3 TEG;
			TEG = Tet * MicronRobotProbeTip; 
			//cout<<"TEG"<<TEG<<endl;

			vctFrm3 TEGinverse;
			TEGinverse = TEG.Inverse();


						vctFrm3 Tgoal;
						Tgoal = Tbe * Tet * Transformation_Camera_FreeProbe * TEGinverse;
						cout<<"\n Tgoal \n"<<Tgoal<<endl;
						
						PositionCartesianSet.SetGoal(Tgoal);
						SetPositionCartesian(PositionCartesianSet);
						cout << "---------- send: " << PositionCartesianSet.Goal() << std::endl;
						//cout<<"PositionCartesianSet"<<PositionCartesianSet<<endl;
					}
					k1++;
					//cout<<k1;
				}
				k1 = 0;
				break;
				default:
				cout << "Invalid option" << endl;
			}
		}
		else {
			cin.clear();
			cin.ignore(256, '\n');  // ignore rest of line
		}
	}
	catch (int &e) {
		CMN_LOG_INIT_WARNING << "Caught exception " << e << std::endl;
	}
}

/////////////////////////////////////////////////////////////////
#ifdef WIN32
/********************************************************************/
int getMTHome (  char *sMTHome, int size )
/********************************************************************/
{
	LONG err;
	HKEY key;
	char *mfile = "MTHome";
	DWORD value_type;
	DWORD value_size = size;

	/* Check registry key to determine log file name: */
	if ( (err = RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", 0,
		KEY_QUERY_VALUE, &key)) != ERROR_SUCCESS ) {
			return(-1);
	}

	if ( RegQueryValueEx( key,
		mfile,
		0,	/* reserved */
		&value_type,
		(unsigned char*)sMTHome,
		&value_size ) != ERROR_SUCCESS || value_size <= 1 ){
			/* size always >1 if exists ('\0' terminator) ? */
			return(-1);
	}
	return(0);
}
#endif
///////////////////////////////////////////////////////////////////////////////////
