% Calibration vectors of the model
% defined by a point, o, and a direction, dir, for each line
% Unconverted calibration vector origin, use with registerPointsV2
% load calibVectors
% Converted calibration vector origin, use with registerPoitnsV3
% Pose recovery portion written by Alexis
% Analysis written by David

close all
clear all
addpath(genpath('../'));
datadir='../Data/';
set(0,'DefaultFigureVisible','on');

flip=0; %Convert correspondence?
planefit=1; %Fit plane?
ori=1; %Show orientation?

%Polygon
picks_poly = { [20 18 16 12 14 3 9 7]; [1 5 16 20 18 3 11 6];  [18 12 10 2 3 4 14 6]; [20 18 14 6 5 3 9 11]; [10 11 19 17 15 6 2 3];[11 19 17 15 6 4 2 10]};
%Number of lines
picks_N={[1 5 16 20];[1 3 5 16 20];[1 18 5 16 20];[1 5 16 20 10 15]; [1 5 16 20 3 18];[1 5 16 20 10 15 3]; [1 5 16 20 10 15 18]; [1 5 16 20 10 15 3 18];[1 5 16 20 12 8 9 13]; [0:20]}; %N
%Triangle
picks_tri={[0 1 2 10]; [0 1 3 10]; [0 1 4 10]; [0 1 5 10]; [0 1 5 10]; [0 1 5 11]; [0 1 5 20]; [0 1 5 18]; [0 1 5 16]}; %Tringle
%Rectangle
picks_rect={[1,2,9,10];[1,2,11,12]; [1 3 11 13]; [1 4 11 14];[1 3 18 20];[1 4 17 20];[1 5 16 20]};%Rectangle
pickss = {picks_poly, picks_N, picks_tri, picks_rect};

for sss = 1:length(pickss)
    
    picks = pickss{sss};
    numpick = size(picks,1);
    
    dates = {'0504','0505'}; %Dates of data to examine
    trajs = {[1,2],[0,12]}; %Trajectory information
    
    for dd = 1:2
        
        date=dates{dd};
        ntrajs = trajs{dd};
        for nn = 1:length(ntrajs)
            numtraj = ntrajs(nn);
            clear vrb marker robot
            
            traj = ['Traj_' date '_' num2str(numtraj) '/'];
            info.traj = traj;
            timestr = datestr(now,30);
            printdir = ['../Output/',traj(1:end-1),'_',timestr,'/'];
            
            if ~isdir(printdir)
                mkdir(printdir);
            end
            outfile = [printdir, traj(1:end-1), '.txt'];
            fid_outfile = fopen(outfile,'w');
            
            xpointfile = 'calib_data_trunc.mat';
            markerfile = 'marker_pose.mat';
            robotfile = 'robotpose.mat';
            
            calibfile = [datadir,'Traj_0430_calib/convCalibVectors.mat'];
            load(calibfile);
            
            load([datadir, traj,xpointfile]);
            load([datadir, traj, markerfile]);
            load([datadir, traj, robotfile]);
            
            points = convDataSet( ( sorted_dataset ));
            
            % Flip zig-zag correspondence?
            if flip
                points = convDataSet( flip_correspondence( sorted_dataset ));
                
            end
            
            % Fitting a plane!
            if planefit
                found = 0;
                dotted=0;
                while ~found || dotted < 0.95
                    try
                        [points, B,dotted] = plane_fit(points);
                        found = 1;
                        pause(5);
                        close;
                    catch
                        display('Couldn''t find a plane. Attempting again. ');
                    end
                end
            end
            for pickedind = 1:numpick
                
                
                pick = picks{pickedind,:}+1;
                printfile = [printdir, traj];
                printfile = printfile(1:end-1);
                printfile = [printfile,'__',num2str(pickedind),'__', sprintf([repmat('%d_', 1,length(pick)-1),'%d'], pick-1)];
                
                info.picks{pickedind,:} = pick;
                info.pick = pick;
                
                
                % COUNT BUSINESS
                npose = size(points,3); % NUMBER OF POSES
                nray = length(pick); % NUMBER OF rays
                nmotion = nchoosek(npose,2);
                picked_points = points(:,pick,:);
                
                
                diff_from_centroid = picked_points - repmat(mean(picked_points,2),[1,nray]);
                mean_distance_from_centroid = squeeze(mynorm(picked_points - repmat(mean(picked_points,2), 1, nray),1));
                rms_distance_from_centroid = rms(rms(mean_distance_from_centroid));
                
                diff_from_each_other = squeeze(mynorm(picked_points - circshift(picked_points,[0,1,0]),1));
                rms_distance_from_each_other = rms(rms(diff_from_each_other));
                
                
                try
                    [ vrb.pose, s, vrb.res, error ] = registerPointsV3( o(:,pick), dir(:,pick), points(:,pick,:) );
                catch
                    display('Something wrong with pose estimation.');
                    continue;
                end
                vrb.points = points;
                marker.pose = markerpose;
                robot.pose = robotpose;
                [vrb.theta, ~, vrb.d, ~, vrb.t] = get_invariants(vrb.pose);
                [marker.theta, ~, marker.d, ~, marker.t] = get_invariants(markerpose);
                [robot.theta, ~, robot.d, ~, robot.t] = get_invariants(robotpose);
                
                vrb.err(1,:,pickedind) = abs(vrb.d-robot.d);
                vrb.err(2,:,pickedind)= abs(vrb.theta-robot.theta);
                vrb.err(3,:,pickedind) = abs(vrb.t-robot.t);
                
                marker.err(1,:,pickedind) = abs(marker.d-robot.d);
                marker.err(2,:,pickedind)= abs(marker.theta-robot.theta);
                marker.err(3,:,pickedind) = abs(marker.t-robot.t);
                
                fprintf(1,'---------------------\n');
                fprintf(1,'%d: Traj: %s, Pick: %s\n', pickedind, traj, num2str(pick-1));
                
                fprintf(1,'Marker - d err : %.3f, theta err : %.3f, t err : %.3f', rms(marker.err(:,:,pickedind),2)); fprintf(1,'\n');
                fprintf(1,'VRB - d err : %.3f, theta err : %.3f, t err : %.3f', rms(vrb.err(:,:,pickedind),2)); fprintf(1,'\n');
                fprintf(1,'---------------------\n');
                
                fprintf(fid_outfile, '%2d,%2d,%2d,%2d,\t%10.3f,%10.3f,%10.3f,\t%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f\n',...
                    pick-1, rms_distance_from_centroid, rms_distance_from_each_other,max(vrb.res),rms(vrb.err(:,:,pickedind),2),rms(marker.err(:,:,pickedind),2));
                
                fig=plot2D(robot,marker, vrb,info,pickedind,ori);
                saveas(fig, printfile,'fig');
                print(fig,'-depsc', printfile);
            end
            
            if size(picks,1) == 1
                return
            end
            fs=20;
            pick_range = 1:numpick;
            motion_range = 1:nmotion;
            
            %Plot surfplot of error motion x VRB configuration x error
            fig3D=figure('position',[0,0,1440,720],'color',[1,1,1],'renderer','openGL');
            nsub3D = 120;
            
            zlabels={'d','rotational','translational'};
            units = {'mm','rad','mm'};
            for i = 2:3
                subplot(nsub3D+i-1);
                surf(pick_range, motion_range, squeeze(vrb.err(i,:,:)));
                hold on;
                line(repmat(pick_range',[1,nmotion]),repmat(motion_range,[numpick,1]),squeeze(marker.err(i,:,:))','color','k','linewidth',2);
                xl=xlabel('VRB configurations','fontsize',fs); ylabel('Motions','fontsize',fs);zlabel(units{i},'fontsize',fs);
                title([zlabels{i}, ' error'],'fontsize',fs);
                set(gca,'XTick',pick_range); set(gca,'YTick',motion_range);
                set(gca,'ydir','reverse');
                colormap('jet');
                colorbar('location','eastoutside');
                axis tight;
                lhandle=legend({'VRB err', 'marker err'},'fontsize',fs,'location','northwestoutside');
                alpha(0.8);
            end
            
            X = 60;
            Y = 40;
            xMargin= 0;
            yMargin= 0;
            xSize= X-2*xMargin;
            ySize= Y-2*yMargin;
            set(fig3D, 'PaperUnits','centimeters')
            set(fig3D, 'PaperSize',[X Y])
            set(fig3D, 'PaperPosition',[xMargin yMargin xSize ySize])
            set(fig3D, 'PaperOrientation','portrait')
            
            printfile3D = [printdir, traj];
            printfile3D = printfile3D(1:end-1);
            printfile3D = [printfile3D];
            
            print(fig3D,'-dpng', printfile3D);
            set(fig3D,'visible','on');
            saveas(fig3D, printfile3D,'fig');
            
            
            
            %Plot rms error
            figrms=figure('position',[0,0,1440,720],'color',[1,1,1]);
            nsub3D = 120;
            
            
            for i = 2:3
                subplot(nsub3D+i-1);
                plot(pick_range, squeeze(rms(vrb.err(i,:,:),2))' ,'o-');
                hold on;
                line(pick_range,rms(squeeze(marker.err(i,:,:))),'color','r','linewidth',1);
                xl=xlabel('VRB configurations','fontsize',fs); ylabel(units{i},'fontsize',fs);%zlabel(zlabels{i},'fontsize',fs);
                title([zlabels{i}, ' error'],'fontsize',fs);
                set(gca,'XTick',pick_range);% set(gca,'YTick',motion_range);
                set(gca,'ydir','normal');
                axis tight;
                lhandle=legend({'VRB err', 'marker err'},'fontsize',fs,'location','northeastoutside');
                
            end
            
            X = 60;
            Y = 40;
            xMargin= 0;
            yMargin= 0;
            xSize= X-2*xMargin;
            ySize= Y-2*yMargin;
            set(figrms, 'PaperUnits','centimeters')
            set(figrms, 'PaperSize',[X Y])
            set(figrms, 'PaperPosition',[xMargin yMargin xSize ySize])
            set(figrms, 'PaperOrientation','portrait')
            
            printfile3D = [printdir, traj];
            printfile3D = printfile3D(1:end-1);
            printfile3D = [printfile3D,'_rms'];
            
            print(figrms,'-depsc', printfile3D);
            saveas(figrms, printfile3D,'fig');
            
            fclose(fid_outfile);
            save([printdir,'results.mat'],'vrb','marker','robot');
            
            close all;
            
            
        end
        
        
    end
end
