% Batch processes VRB Xpoints
files = dir([datadir, 'xpoints*.txt']);
files = {files.name};

numfile = length(files);

np = zeros(size(files));

for i = 1:numfile
    temp = strsplit(files{i},'e');
    temp = strsplit(temp{2},'.');
    np(i) = str2double(temp{1});
end
    
[sortednp, sortedind] = sort(np);

files_sorted = files(sortedind);



close all;
fig=figure;
set(fig,'color', [1,1,1]);

for i = 1:numfile
    files_sorted{i}
    %Frame collation
    g = gather_points([datadir, files_sorted{i}]);

    %Correspondence
    sorted_dataset{i,1}  = find_correspondence(g);

    figure(fig);
    display_correspondence(sorted_dataset{i,1});
    leg{i} =[num2str(i) ': ' num2str(length(sorted_dataset{i,1}))];
    legend(leg);
    hold all;

end

% return
saveas(fig,[datadir,'correspondence_trunc.fig']);
save([datadir,'calib_data_trunc.mat'], 'sorted_dataset');