% Converts [x,y,z,Rx,Ry,Rz] into F=[R t;0,1] transformation matrix
function [poses] = convRobotData(vecs)

n = size(vecs,1);
poses = zeros(4,4,n);

for i=1:n
    poses(:,:,i) = eye(4);
    poses(1:3,4,i) = vecs(i,1:3);

    d = vecs(i,4:6);
    t = norm(d);
    u = d(1)/t;
    v = d(2)/t;
    w = d(3)/t;
    
    poses(1:3,1:3,i) = [u^2+(v^2+w^2)*cos(t) u*v*(1-cos(t))-w*sin(t) u*w*(1-cos(t))+v*sin(t);
        u*v*(1-cos(t))+w*sin(t) v^2+(u^2+w^2)*cos(t) v*w*(1-cos(t))-u*sin(t);
        u*w*(1-cos(t))-v*sin(t)  v*w*(1-cos(t))+u*sin(t) w^2+(u^2+v^2)*cos(t)];
    
end

end