%Assigns correspondence
function sorted_points = find_correspondence(g)

%gp [numPoints x 5]
c = size(g,1);

x2D = g(:,4);
y2D = g(:,5);

distmat = sqrt( (repmat(x2D, 1, c) - repmat(x2D', c, 1)).^2 + ((repmat(y2D, 1, c) - repmat(y2D', c, 1) )).^2 );
distmat(distmat==0) = Inf;

[mindist, ind] = min(distmat,[], 2);

[~,reference] = max(mindist);

dist_from_reference = distmat(:,reference);
% dist_from_reference(reference) = -1;
% [minss,indd] = sort(dist_from_reference);

sorted_index= -ones(length(g),1);
sorted_index(1)=reference;

%Distance map
for i = 1:length(dist_from_reference)-1
    [min_dist_from_prev, nextindices] = sort(distmat(sorted_index(i),:));
    k = 1;
    while ( sum(nextindices(k) == sorted_index) )
       k = k+1; 
    end
    sorted_index(i+1) = nextindices(k);
    
end


sorted_points = g(sorted_index,:);

end


