%Collates frames and processes the VRB XPoints data. 

function [gathered_truncate_avg, count] = gather_points(file)


data = parse(file);
gathered(:,:,1) = data{2};
count = size(gathered,1);


% FRAME COLLATION
for i = 2:length(data)

    curr_frame_data = data{i,1};
    x2D_curr_frame_data = curr_frame_data(:,4);
    y2D_curr_frame_data = curr_frame_data(:,5);
    
    temp_gathered = sum(gathered,3) ./ sum(gathered~=0,3);
    
    x2D_gathered = temp_gathered(:,4);
    y2D_gathered = temp_gathered(:,5);
    

    x2D_curr_frame_data_expanded = repmat(x2D_curr_frame_data,1,length(x2D_gathered));
    y2D_curr_frame_data_expanded = repmat(y2D_curr_frame_data,1,length(y2D_gathered));
    
    x2D_gathered_expanded = repmat(x2D_gathered',length(x2D_curr_frame_data),1); 
    y2D_gathered_expanded = repmat(y2D_gathered',length(x2D_curr_frame_data),1);
    
    distance_matrix = sqrt( (x2D_curr_frame_data_expanded-x2D_gathered_expanded).^2 ...
        + (y2D_curr_frame_data_expanded-y2D_gathered_expanded).^2);
    
    
    for j = 1:size(distance_matrix,1)
        ind = find(distance_matrix(j,:) < 1,1);
        if isempty(ind)
            count = count + 1;
            gathered(count,:,i) = curr_frame_data(j,:);
        else
            gathered(ind,:,i) = curr_frame_data(j,:);
        end
        %sum(sum(gathered(j,1,:)~=0))
    end
    
% count
end

% If there a given point is detected in less than number_of_frames/50 frames, it's
% an outlier.
gathered(sum(squeeze(gathered(:,1,:)) ~=0 , 2) < size(data,1)/50,:,:)=[];


% Z-SCORE THRESHOLDING
gathered_avg = sum(gathered,3) ./ sum(gathered~=0,3);

gathered_avg_expanded = repmat(gathered_avg,[1,1, size(gathered,3)]);

gathered_avg_expanded(gathered==0) = 0;

gathered_var = zeros(size(gathered_avg));
gathered_var = sum((gathered_avg_expanded - gathered).^2, 3)./sum(gathered~=0,3);

gathered_std = sqrt(gathered_var);
gathered_std_expanded = repmat(gathered_std,[1,1,size(gathered,3)]);
gathered_zscore = (gathered - gathered_avg_expanded )./gathered_std_expanded;

gathered_truncate = gathered;
%%%%%%%%%% Z SCORE! 
z=0.7;
gathered_truncate(abs(gathered_zscore)>=z) = 0;

gathered_truncate_avg = sum(gathered_truncate,3) ./ sum(gathered_truncate~=0,3);


figav = figure('color',[1,1,1]);
subplot(1,3,3);
scatter3(gathered_avg(:,1), gathered_avg(:,2), gathered_avg(:,3),20, 'markerfacecolor',[1,0,0],'markeredgecolor',[1,0,0]);
hold on;
scatter3(gathered_truncate_avg(:,1), gathered_truncate_avg(:,2), gathered_truncate_avg(:,3),40,'markerfacecolor',[0,0,1]);
legend({'before truncation',['after truncation with z score of ' num2str(z), ', num: ' num2str(size(gathered_truncate_avg,1))]}, 'fontsize',15, 'location', 'southoutside');


% fig3D = figure('color',[1,1,1]);
subplot(1,3,1);
for i = 1:size(gathered,3)
    for j = 1:size(gathered,1)
        if all(gathered(j,:,i))
            scatter3(gathered(j,1,i), gathered(j,2,i), gathered(j,3,i));
            hold all;
    
        end
    end
end
title('before truncation', 'fontsize', 15);

subplot(1,3,2);
for i = 1:size(gathered_truncate,3)
    for j = 1:size(gathered_truncate,1)
        if all(gathered_truncate(j,:,i))
            scatter3(gathered_truncate(j,1,i), gathered_truncate(j,2,i), gathered_truncate(j,3,i));
            hold all;
    
        end
    end
end

title([file ' after truncation with z score of ' num2str(z)], 'fontsize', 15);
% end