%Data parsing!
function [data, numframe] = parse(fname, varargin)
if nargin > 1
    maxnumframe = varargin{1};
else
    maxnumframe = Inf;
end



if nargin < 1
    fname='file.txt';
end
fid = fopen(fname);

data = {};
numframe = 1;
while ~feof(fid)% && numframe <= maxnumframe
    count = str2double(fgetl(fid));
    for i = 1:count
        parsed = str2double(regexp(fgetl(fid), ',', 'split'));
        data{numframe,1}(i,:) = parsed;
    end
    numframe = numframe+1;
end
numframe = numframe-1;
fclose(fid);


if nargin > 1

    data = data(randperm(length(data),maxnumframe));
end

end