% Batch processes marker data
files = dir([datadir, 'marker*.txt']);
files = {files.name};

numframe = length(files);

np = zeros(size(files));

for i = 1:numframe
    temp = strsplit(files{i},'e');
    temp = strsplit(temp{3},'.');
    np(i) = str2double(temp{1});
end
    
[sortednp, sortedind] = sort(np);

files_sorted = files(sortedind);

numframe = length(files_sorted);
gathered = zeros(numframe,6);

for i = 1:numframe
    data = cell2mat(parse([datadir,files_sorted{i}]));
    data = mean(data);
    gathered(i,:) = data;

end

markerpose = convRobotData(gathered);

figure;
mfig=scatter3(squeeze(markerpose(1,4,:)),squeeze(markerpose(2,4,:)),squeeze(markerpose(3,4,:)));
title('robotpose','fontsize',20);
saveas(mfig,[datadir,'marker_pose.fig']);
save([datadir, 'marker_pose.mat'], 'markerpose');


