close all;
% clear all;
load calib_data_trunc
load ~/Dropbox/Hopkins/2014Spring/CIS2/Output_summary/2/Shapes_polygon/Traj_0504_1_20140507T185256/results

numimage = 1;
for numimage = 1:5
    
    fig=figure(numimage);
    set(fig,'color',[1,1,1],'position',[0,720,640,380]);
    fid = fopen(['image' num2str(numimage),'.txt']);
    
    img = -1*ones([640,480]);
    
    while true
        tline = fgetl(fid);
        if ~ischar(tline); break;
        elseif strcmp(tline,'')
            continue;
        end
        temp = sscanf(tline,'(%d,%d,%d)');
        row = temp(1)+1;
        col = temp(2)+1;
        img(row,col) = temp(3);
    end
    fclose(fid);
    
    imagesc(img);
    colormap(gray)
    
    hold on;
    
    
    collated = cell2mat(sorted_dataset);
    points3d = collated(:,1:3);
    points2d = [collated(:,4:5),zeros(size(collated,1),1)];
    f = ComputeC2CRegistration(points3d,points2d);
    
    
    Rot = f(1:3,1:3);
    tr = f(1:3,4);
    
    for i =1:size(points3d,1)
        computed_points2d(i,:) = transpose(Rot*points3d(i,:)' + tr);
    end
    
    points = sorted_dataset{1,1}(:,4:5);
    range = (numimage-1)*21+(1:21);
%     scatter(computed_points2d(range,1), computed_points2d(range,2),'b');

    vrb_position =Rot* vrb.pose(1:3,4,numimage)+tr;
    marker_position = Rot*marker.pose(1:3,4,numimage)+tr;
    scatter(vrb_position(1),vrb_position(2),'g','filled');
%     scatter(marker_position(1),marker_position(2),'y','filled');
    legend({'Recovered VRB pose'},'fontsize',20,'location','southeast');
    scatter(points2d(range,1), points2d(range,2),'r');
    axis off;
    ylim([100,640]);
    figure(numimage);
    M(numimage) = getframe;
end

movie2avi(M,'~/Demo','FPS',2,'QUALITY',100);

