%Plane fitting
function [points_planefit, B_all,dotted] =plane_fit(points)

% points = convDataSet(sorted_dataset);

for  i = 1:size(points,3)
    
    pointss = points(:,:,i);
    
    [B,p,in] = ransacfitplane(pointss,.01);
    normal=B(1:3);
    
    % p = pointss(:,1);
    
    % projected_to_norm = dot(norm,p)/dot(norm,norm) * norm;
    
    % projected = p-projected_to_norm
    
    D = B(4)/norm(normal);
    projected_to_norm = projection(pointss, normal);
    projected = pointss - projected_to_norm + abs(repmat(D*normal/norm(normal),1,size(pointss,2)));
    %

    points_planefit(:,:,i) = projected;
    B_all(:,i)=B;
    
end

for i = 2:size(B_all,2);
    normdot(i-1,1)=abs(dot(B_all(1:3,i)/norm(B_all(1:3,i)),B_all(1:3,i-1)/norm(B_all(1:3,i-1))));
end


dotted=mean(normdot);
figure('color',[1,1,1]);
a=subplot(1,2,2);
for i = 1:size(points_planefit,3)
    scatter3(points_planefit(1,:,i),points_planefit(2,:,i),points_planefit(3,:,i))
    hold all
end
title(['After plane fit - normal error: ', num2str(mean(normdot),3)]);

b=subplot(1,2,1);
for i = 1:size(points_planefit,3)
    scatter3(points(1,:,i),points(2,:,i),points(3,:,i))
    hold all
end
set(b,'xlim',get(a,'xlim')); set(b,'ylim',get(a,'ylim')); set(b,'zlim',get(a,'zlim'));
title('Before plane fit');




