%Plot some results
function fig=plot2D(robot,marker, vrb,info,ind,ori)
fs=20;
nmotion=size(marker.err,2);
nsubp = 151;
traj = info.traj;
pick = info.pick;
fig=figure('position',[0,0,1440,720],'color',[1,1,1]);

subplot(nsubp+2);
%     plot(robot.d,'bo')
plot(1:nmotion,marker.err(1,:,ind),'go')
hold on;
plot(1:nmotion,vrb.err(1,:,ind),'ro')
title('d difference','fontsize',fs);
legend({['marker-robot: ', num2str(rms(marker.err(1,:,ind)),4) ], ['vrb-robot: ', num2str(rms(vrb.err(1,:,ind)),4)]},'fontsize',fs*2/3,'location','northoutside');
xlabel('motions','fontsize',fs); ylabel('mm', 'fontsize',fs);
grid on;
set(gca,'XTick',1:nmotion);


subplot(nsubp+3);
%     plot(robot.theta,'bo')
plot(1:nmotion,marker.err(2,:,ind),'go')
hold on;
plot(1:nmotion,vrb.err(2,:,ind),'ro')
title('theta difference','fontsize',fs);
legend({['marker-robot: ', num2str(rms(marker.err(2,:,ind)),2) ], ['vrb-robot: ', num2str(rms(vrb.err(2,:,ind)),2)]},'fontsize',fs*2/3,'location','northoutside');
xlabel('motions','fontsize',fs); ylabel('rad', 'fontsize',fs);
grid on;
set(gca,'XTick',1:nmotion);

subplot(nsubp+4);
plot(1:nmotion,marker.err(3,:,ind),'go')
hold on;
plot(1:nmotion,vrb.err(3,:,ind),'ro')
title('t difference','fontsize',fs);
legend({['marker-robot: ', num2str(rms(marker.err(3,:,ind)),2) ], ['vrb-robot: ', num2str(rms(vrb.err(3,:,ind)),2)]},'fontsize',fs*2/3,'location','northoutside');
xlabel('motions','fontsize',fs); ylabel('mm', 'fontsize',fs);
set(gca,'XTick',1:size(marker.err,2));
grid on;

% figure('position',[0,0,1280,720],'color',[1,1,1], 'visible','on');
h=subplot(nsubp+1);
% ori=1;
scr=display_traj(robot.pose);
hold all;
scm=display_traj(marker.pose);
scv=display_traj(vrb.pose);
for i = 1:size(vrb.points,3)
    scatter3(vrb.points(1,:,i), vrb.points(2,:,i), vrb.points(3,:,i),'o')
    hold all
end
title(['Tracked Poses: ', traj],'fontsize',fs, 'interpreter','none');
legend({'robot','marker', ['vrb: ', num2str(pick-1), ', res: ', num2str(mean(vrb.res),4)]},'fontsize',fs*2/3,'location','north');
xlabel('x','fontsize',fs); ylabel('y', 'fontsize',fs); zlabel('z','fontsize',fs);
axis tight;

% sc=scatter3(translation(1,:), translation(2,:), translation(3,:),'filled');
if ori
    hold all;
    display_ori(robot.pose,scr);
    display_ori(marker.pose,scm);
    display_ori(vrb.pose,scv);
%     quiver3(translation(1,:), translation(2,:), translation(3,:), rotated(1,:), rotated(2,:), rotated(3,:),0,'color',get(sc,'CData')/2,'linewidth',1)
end






subplot(nsubp);
%     display_correspondence(sorted_dataset{1});
scatter3(vrb.points(1,:,1), vrb.points(2,:,1), vrb.points(3,:,1),100,'b.', 'linewidth',2)
for j = 1:size(vrb.points,2)
    text(vrb.points(1,j,1)+1, vrb.points(2,j,1)+1, vrb.points(3,j,1)+1, num2str(j-1) , 'fontsize', 12);
end
%         scatter3(points(1,:,1), points(2,:,1), points(3,:,1),100,'b.', 'linewidth',1)
hold on;
scatter3(vrb.points(1,pick,1), vrb.points(2,pick,1), vrb.points(3,pick,1),100,'rd', 'linewidth',2)
title('VRB configurations','fontsize',fs, 'interpreter','none');
view(2)
axis tight equal;

% legend({'robot', 'marker', 'VRB'}, 'fontsize', fs);
%         set(h,'position',get(h,'position').*[1/2,1,1.5,1])
%         set(fig,'position',get(fig,'position').*[0,0,1.5,1])


X = 50;
Y = 20;
xMargin= 0;
yMargin= 0;
xSize= X-2*xMargin;
ySize= Y-2*yMargin;
set(fig, 'PaperUnits','centimeters')
set(fig, 'PaperSize',[X Y])
set(fig, 'PaperPosition',[xMargin yMargin xSize ySize])
set(fig, 'PaperOrientation','portrait')