%%%read data from .CSV file and calculate the signal envelope 
number_tests = 24;
max_signal = zeros(1,number_tests);
j = 0;
for i = 0:23
    j = j + 1;
    disp(i);
    num = int2str(i);
    if i < 10
        file = strcat('TEK0000',num);
    else
        file = strcat('TEK000',num);
    end
        
    file_with_type = strcat(file,'.CSV');
    %directory = strcat('graphs - new/',file);
    %directory = strcat(directory, '/');
    data = xlsread(file_with_type);
    fig1 = figure;
    plot(data(:,1),data(:,2));
    hold on;
    plot(data(:,1),data(:,3),'r');
    %saveas(fig1, strcat(directory,'data.jpg'));
    hold off;
    RF=data(:,3);
    figRF = figure;
    plot(RF);
    [x_prime,y_prime] = ginput(2);
    x_prime = ceil(x_prime);
    RF = RF(x_prime(1):x_prime(2));
    RF = RF-mean(RF);
    RF_env = abs(hilbert(RF));%%%signal envelope
    fig2 = figure;
    plot(RF_env);
    %saveas(fig2,strcat(directory,'rf_env.jpg'));
    [x,y] = ginput(2);%%%select starting and end point of the main signal 
    x = ceil(x);
    RF_env_crop= RF_env(x(1):x(2));
    fig3 = figure;
    plot(RF_env_crop);
    %saveas(fig3, strcat(directory, 'rf_env_crop.jpg'));
    close all;
    %%%%
    %%%find max intensity form RF_env_crop
    max_signal(j) = max(RF_env_crop);
end

wavelengths = [690:10:900, 700, 780];
energy = [13.17, 20.63, 22.65, 23.23, 23.36, 24.08, 24.05, 22.97, 22.47, 23.40, 22.16, 21.79, 21.24, 19.9, 20.02, 19.25, 18.84, 17.15, 18.16, 17.47, 17.51, 17.15, 19.63, 23.15];
IR780_base = zeros(1,number_tests);
for j = 1:number_tests
    IR780_base(j) = max_signal(j)/energy(j);
end
