#include "DemoAlgorithm.h"

#include <ImFusion/Base/DataList.h>
#include <ImFusion/Base/MemImage.h>
#include <ImFusion/Base/SharedImage.h>
#include <ImFusion/Base/SharedImageSet.h>


namespace ImFusion
{
	/*
	DemoAlgorithm::DemoAlgorithm(SharedImageSet* img):
		m_imgIn(img),
		m_imgOut(0)
	{
		configureDefaults();
	}
	*/

	DemoAlgorithm::DemoAlgorithm() : IoAlgorithm(IoMode::Read, LocationType::IGTLink)
	{ }


	bool DemoAlgorithm::createCompatible(const DataList &data, Algorithm **a)
	{
		if (data.size())
			return false;
		if (a)
		{
			*a = new DemoAlgorithm();
		}
		return true;
	}


	void DemoAlgorithm::compute()
	{
		/*m_imgOut = new SharedImageSet();
		for (int i = 0; i < m_imgIn->size(); i++)
		{
			SharedImage* imgNew = new SharedImage(*m_imgIn->mem(i)->clone());
			imgNew->setModality(m_imgIn->get(i)->modality());
			if (m_imgIn->get(i)->matrixPointer())
				imgNew->setMatrix(m_imgIn->get(i)->matrix());
			imgNew->mem()->downsample(m_factor,m_factor,m_factor);
			m_imgOut->add(imgNew);
			m_imgOut->get(i)->setDirtyMem();
		}*/
	}


	void DemoAlgorithm::output(DataList& dataOut)
	{
		if (m_imgOut)
			dataOut.add(m_imgOut);
		m_imgOut = 0;
	}


	void DemoAlgorithm::configure(const Properties* p)
	{
		if (p == 0)
			return;
		p->param("factor",m_factor);
		for (int i = 0; i < (int)m_listeners.size(); ++i)
			m_listeners[i]->algorithmParametersChanged();
	}


	void DemoAlgorithm::configuration(Properties* p) const
	{
		if (p == 0)
			return;
		p->setParam("factor",m_factor,2);
	}
}
