/* Copyright (c) 2012-2015 ImFusion GmbH, Munich, Germany. All rights reserved. */
#ifndef IMFUSION_DEMO_ALGORITHM_H
#define IMFUSION_DEMO_ALGORITHM_H

#include <ImFusion/Base/IoAlgorithm.h>
#include <ImFusion/Base/Algorithm.h>
#include <ImFusion/Base/AlgorithmListener.h>

namespace ImFusion
{
	class SharedImageSet;

	/** \brief	Demonstrates usage of algorithms
	*	\author Alexander Ladikos
	*/
	class DemoAlgorithm : public IoAlgorithm
	{
	public:
		/// Creates the algorithm instance with an image
		///DemoAlgorithm(SharedImageSet* img);
		DemoAlgorithm();

		/// Set downsampling factor
		void setFactor(int factor) { m_factor = factor; }

		/// \name	Methods implementing the algorithm interface
		//\{
		/// Factory method to check for applicability or to create the algorithm
		static bool createCompatible(const DataList &data, Algorithm **a = 0);

		/// Applies the processing
		void compute();

		const SharedImageSet* input() const { return m_imgIn; }

		/// If new data was created, make it available here
		void output(DataList& dataOut);
		//\}

		/// \name	Methods implementing the Configurable interface
		//\{
		void configure(const Properties* p);
		void configuration(Properties* p) const;
		//\}

	private:
		SharedImageSet*	m_imgIn;		///< Input image to process
		SharedImageSet*	m_imgOut;		///< Output image after processing
		int m_factor;					///< Downsampling factor
	};
}

#endif
