#include "DemoFactory.h"
#include "DemoAlgorithm.h"
#include "DemoController.h"


namespace ImFusion
{
	DemoAlgorithmFactory::DemoAlgorithmFactory()
	{
		registerAlgorithm<DemoAlgorithm>("ROS;ROS plugin");
	}


	AlgorithmController* DemoControllerFactory::create(Algorithm *a) const
	{
		if (a == 0)
			return 0;
		if (DemoAlgorithm *alg = dynamic_cast<DemoAlgorithm*>(a))
			return new DemoController(alg);
		return 0;
	}
}
