/* Copyright (c) 2012-2015 ImFusion GmbH, Munich, Germany. All rights reserved. */
#ifndef IMFUSION_DEMO_FACTORY_H
#define IMFUSION_DEMO_FACTORY_H

#include <ImFusion/Base/AlgorithmFactory.h>
#include <ImFusion/Base/AlgorithmControllerFactory.h>
#include <ImFusion/GUI/IOAlgorithmControllerFactory.h>

namespace ImFusion
{
	class Algorithm;

	/** \brief	Factory for demo algorithm
	 *	\author	Alexander Ladikos
	 */
	class DemoAlgorithmFactory : public AlgorithmFactory
	{
	public:
		DemoAlgorithmFactory();
	};

	/*! \brief Factory for demo algorithm controller
	 *	\author	Alexander Ladikos
	 */
	class DemoControllerFactory : public IoAlgorithmControllerFactory
	{
	public:
		virtual AlgorithmController* create(Algorithm *a) const;
	};
}

#endif
