#include "DemoPlugin.h"

#include <windows.h>


ImFusion::DemoPlugin* plugin = 0;


BOOL WINAPI DllMain(HINSTANCE module_handle, DWORD reason_for_call, LPVOID reserved)
{
	if (reason_for_call == DLL_PROCESS_ATTACH) // Self-explanatory
	{
		DisableThreadLibraryCalls(module_handle); // Disable DllMain calls for DLL_THREAD_*
		if (reserved == NULL) // Dynamic load
		{
			plugin = new ImFusion::DemoPlugin;
			// Return FALSE if you don't want your module to be dynamically loaded
		}
		else // Static load
		{
			// Return FALSE if you don't want your module to be statically loaded
			return FALSE;
		}
	}

	if (reason_for_call == DLL_PROCESS_DETACH) // Self-explanatory
	{
		if (reserved == NULL) // Either loading the DLL has failed or FreeLibrary was called
		{
			// Cleanup
			delete plugin;
		}
		else // Process is terminating
		{
			// Cleanup
			delete plugin;
		}
	}
	return TRUE;
}


extern "C" __declspec(dllexport) ImFusion::ImFusionPlugin* createPlugin()
{
	return plugin;
}
