/* Software License Agreement (BSD License)
 *
 * Copyright (c) 2011, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Willow Garage, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Auto-generated by genmsg_cpp from file C:\work\ws\src\IIWA\msg\IIWAMsg.msg
 *
 */


#ifndef IIWA_MESSAGE_IIWAMSG_H
#define IIWA_MESSAGE_IIWAMSG_H


#include <string>
#include <vector>
#include <map>

#include <ros/types.h>
#include <ros/serialization.h>
#include <ros/builtin_message_traits.h>
#include <ros/message_operations.h>


namespace IIWA
{
template <class ContainerAllocator>
struct IIWAMsg_
{
  typedef IIWAMsg_<ContainerAllocator> Type;

  IIWAMsg_()
    : isJointControl(false)
    , cartPosition()
    , cartForces()
    , cartPositionStiffness()
    , cartOrientation()
    , cartMoments()
    , cartOrientationStiffness()
    , jointAngles()
    , jointTorques()
    , jointStiffness()  {
    }
  IIWAMsg_(const ContainerAllocator& _alloc)
    : isJointControl(false)
    , cartPosition(_alloc)
    , cartForces(_alloc)
    , cartPositionStiffness(_alloc)
    , cartOrientation(_alloc)
    , cartMoments(_alloc)
    , cartOrientationStiffness(_alloc)
    , jointAngles(_alloc)
    , jointTorques(_alloc)
    , jointStiffness(_alloc)  {
    }



   typedef uint8_t _isJointControl_type;
  _isJointControl_type isJointControl;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _cartPosition_type;
  _cartPosition_type cartPosition;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _cartForces_type;
  _cartForces_type cartForces;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _cartPositionStiffness_type;
  _cartPositionStiffness_type cartPositionStiffness;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _cartOrientation_type;
  _cartOrientation_type cartOrientation;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _cartMoments_type;
  _cartMoments_type cartMoments;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _cartOrientationStiffness_type;
  _cartOrientationStiffness_type cartOrientationStiffness;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _jointAngles_type;
  _jointAngles_type jointAngles;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _jointTorques_type;
  _jointTorques_type jointTorques;

   typedef std::vector<double, typename ContainerAllocator::template rebind<double>::other >  _jointStiffness_type;
  _jointStiffness_type jointStiffness;




  typedef boost::shared_ptr< ::IIWA::IIWAMsg_<ContainerAllocator> > Ptr;
  typedef boost::shared_ptr< ::IIWA::IIWAMsg_<ContainerAllocator> const> ConstPtr;
  boost::shared_ptr<std::map<std::string, std::string> > __connection_header;

}; // struct IIWAMsg_

typedef ::IIWA::IIWAMsg_<std::allocator<void> > IIWAMsg;

typedef boost::shared_ptr< ::IIWA::IIWAMsg > IIWAMsgPtr;
typedef boost::shared_ptr< ::IIWA::IIWAMsg const> IIWAMsgConstPtr;

// constants requiring out of line definition



template<typename ContainerAllocator>
std::ostream& operator<<(std::ostream& s, const ::IIWA::IIWAMsg_<ContainerAllocator> & v)
{
ros::message_operations::Printer< ::IIWA::IIWAMsg_<ContainerAllocator> >::stream(s, "", v);
return s;
}

} // namespace IIWA

namespace ros
{
namespace message_traits
{



// BOOLTRAITS {'IsFixedSize': False, 'IsMessage': True, 'HasHeader': False}
// {'std_msgs': ['C:/work/ws/src/std_msgs/msg'], 'IIWA': ['C:/work/ws/src/IIWA/msg']}

// !!!!!!!!!!! ['__class__', '__delattr__', '__dict__', '__doc__', '__eq__', '__format__', '__getattribute__', '__hash__', '__init__', '__module__', '__ne__', '__new__', '__reduce__', '__reduce_ex__', '__repr__', '__setattr__', '__sizeof__', '__str__', '__subclasshook__', '__weakref__', '_parsed_fields', 'constants', 'fields', 'full_name', 'has_header', 'header_present', 'names', 'package', 'parsed_fields', 'short_name', 'text', 'types']




template <class ContainerAllocator>
struct IsFixedSize< ::IIWA::IIWAMsg_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct IsFixedSize< ::IIWA::IIWAMsg_<ContainerAllocator> const>
  : FalseType
  { };

template <class ContainerAllocator>
struct IsMessage< ::IIWA::IIWAMsg_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct IsMessage< ::IIWA::IIWAMsg_<ContainerAllocator> const>
  : TrueType
  { };

template <class ContainerAllocator>
struct HasHeader< ::IIWA::IIWAMsg_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct HasHeader< ::IIWA::IIWAMsg_<ContainerAllocator> const>
  : FalseType
  { };


template<class ContainerAllocator>
struct MD5Sum< ::IIWA::IIWAMsg_<ContainerAllocator> >
{
  static const char* value()
  {
    return "fed68319ad43748c25818e62d44bea6b";
  }

  static const char* value(const ::IIWA::IIWAMsg_<ContainerAllocator>&) { return value(); }
  static const uint64_t static_value1 = 0xfed68319ad43748cULL;
  static const uint64_t static_value2 = 0x25818e62d44bea6bULL;
};

template<class ContainerAllocator>
struct DataType< ::IIWA::IIWAMsg_<ContainerAllocator> >
{
  static const char* value()
  {
    return "IIWA/IIWAMsg";
  }

  static const char* value(const ::IIWA::IIWAMsg_<ContainerAllocator>&) { return value(); }
};

template<class ContainerAllocator>
struct Definition< ::IIWA::IIWAMsg_<ContainerAllocator> >
{
  static const char* value()
  {
    return "bool isJointControl\n\
float64[] cartPosition\n\
float64[] cartForces\n\
float64[] cartPositionStiffness\n\
float64[] cartOrientation\n\
float64[] cartMoments\n\
float64[] cartOrientationStiffness\n\
float64[] jointAngles\n\
float64[] jointTorques\n\
float64[] jointStiffness\n\
";
  }

  static const char* value(const ::IIWA::IIWAMsg_<ContainerAllocator>&) { return value(); }
};

} // namespace message_traits
} // namespace ros

namespace ros
{
namespace serialization
{

  template<class ContainerAllocator> struct Serializer< ::IIWA::IIWAMsg_<ContainerAllocator> >
  {
    template<typename Stream, typename T> inline static void allInOne(Stream& stream, T m)
    {
      stream.next(m.isJointControl);
      stream.next(m.cartPosition);
      stream.next(m.cartForces);
      stream.next(m.cartPositionStiffness);
      stream.next(m.cartOrientation);
      stream.next(m.cartMoments);
      stream.next(m.cartOrientationStiffness);
      stream.next(m.jointAngles);
      stream.next(m.jointTorques);
      stream.next(m.jointStiffness);
    }

    ROS_DECLARE_ALLINONE_SERIALIZER;
  }; // struct IIWAMsg_

} // namespace serialization
} // namespace ros

namespace ros
{
namespace message_operations
{

template<class ContainerAllocator>
struct Printer< ::IIWA::IIWAMsg_<ContainerAllocator> >
{
  template<typename Stream> static void stream(Stream& s, const std::string& indent, const ::IIWA::IIWAMsg_<ContainerAllocator>& v)
  {
    s << indent << "isJointControl: ";
    Printer<uint8_t>::stream(s, indent + "  ", v.isJointControl);
    s << indent << "cartPosition[]" << std::endl;
    for (size_t i = 0; i < v.cartPosition.size(); ++i)
    {
      s << indent << "  cartPosition[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.cartPosition[i]);
    }
    s << indent << "cartForces[]" << std::endl;
    for (size_t i = 0; i < v.cartForces.size(); ++i)
    {
      s << indent << "  cartForces[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.cartForces[i]);
    }
    s << indent << "cartPositionStiffness[]" << std::endl;
    for (size_t i = 0; i < v.cartPositionStiffness.size(); ++i)
    {
      s << indent << "  cartPositionStiffness[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.cartPositionStiffness[i]);
    }
    s << indent << "cartOrientation[]" << std::endl;
    for (size_t i = 0; i < v.cartOrientation.size(); ++i)
    {
      s << indent << "  cartOrientation[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.cartOrientation[i]);
    }
    s << indent << "cartMoments[]" << std::endl;
    for (size_t i = 0; i < v.cartMoments.size(); ++i)
    {
      s << indent << "  cartMoments[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.cartMoments[i]);
    }
    s << indent << "cartOrientationStiffness[]" << std::endl;
    for (size_t i = 0; i < v.cartOrientationStiffness.size(); ++i)
    {
      s << indent << "  cartOrientationStiffness[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.cartOrientationStiffness[i]);
    }
    s << indent << "jointAngles[]" << std::endl;
    for (size_t i = 0; i < v.jointAngles.size(); ++i)
    {
      s << indent << "  jointAngles[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.jointAngles[i]);
    }
    s << indent << "jointTorques[]" << std::endl;
    for (size_t i = 0; i < v.jointTorques.size(); ++i)
    {
      s << indent << "  jointTorques[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.jointTorques[i]);
    }
    s << indent << "jointStiffness[]" << std::endl;
    for (size_t i = 0; i < v.jointStiffness.size(); ++i)
    {
      s << indent << "  jointStiffness[" << i << "]: ";
      Printer<double>::stream(s, indent + "  ", v.jointStiffness[i]);
    }
  }
};

} // namespace message_operations
} // namespace ros

#endif // IIWA_MESSAGE_IIWAMSG_H
