/* Software License Agreement (BSD License)
 *
 * Copyright (c) 2011, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Willow Garage, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Auto-generated by genmsg_cpp from file C:\work\ws\src\ros_comm\messages\rosgraph_msgs\msg\Log.msg
 *
 */


#ifndef ROSGRAPH_MSGS_MESSAGE_LOG_H
#define ROSGRAPH_MSGS_MESSAGE_LOG_H


#include <string>
#include <vector>
#include <map>

#include <ros/types.h>
#include <ros/serialization.h>
#include <ros/builtin_message_traits.h>
#include <ros/message_operations.h>

#include <std_msgs/Header.h>

namespace rosgraph_msgs
{
template <class ContainerAllocator>
struct Log_
{
  typedef Log_<ContainerAllocator> Type;

  Log_()
    : header()
    , level(0)
    , name()
    , msg()
    , file()
    , function()
    , line(0)
    , topics()  {
    }
  Log_(const ContainerAllocator& _alloc)
    : header(_alloc)
    , level(0)
    , name(_alloc)
    , msg(_alloc)
    , file(_alloc)
    , function(_alloc)
    , line(0)
    , topics(_alloc)  {
    }



   typedef  ::std_msgs::Header_<ContainerAllocator>  _header_type;
  _header_type header;

   typedef int8_t _level_type;
  _level_type level;

   typedef std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other >  _name_type;
  _name_type name;

   typedef std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other >  _msg_type;
  _msg_type msg;

   typedef std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other >  _file_type;
  _file_type file;

   typedef std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other >  _function_type;
  _function_type function;

   typedef uint32_t _line_type;
  _line_type line;

   typedef std::vector<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > , typename ContainerAllocator::template rebind<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::other >  _topics_type;
  _topics_type topics;


    enum { DEBUG = 1 };
     enum { INFO = 2 };
     enum { WARN = 4 };
     enum { ERROR = 8 };
     enum { FATAL = 16 };
 

  typedef boost::shared_ptr< ::rosgraph_msgs::Log_<ContainerAllocator> > Ptr;
  typedef boost::shared_ptr< ::rosgraph_msgs::Log_<ContainerAllocator> const> ConstPtr;
  boost::shared_ptr<std::map<std::string, std::string> > __connection_header;

}; // struct Log_

typedef ::rosgraph_msgs::Log_<std::allocator<void> > Log;

typedef boost::shared_ptr< ::rosgraph_msgs::Log > LogPtr;
typedef boost::shared_ptr< ::rosgraph_msgs::Log const> LogConstPtr;

// constants requiring out of line definition

   

   

   

   

   



template<typename ContainerAllocator>
std::ostream& operator<<(std::ostream& s, const ::rosgraph_msgs::Log_<ContainerAllocator> & v)
{
ros::message_operations::Printer< ::rosgraph_msgs::Log_<ContainerAllocator> >::stream(s, "", v);
return s;
}

} // namespace rosgraph_msgs

namespace ros
{
namespace message_traits
{



// BOOLTRAITS {'IsFixedSize': False, 'IsMessage': True, 'HasHeader': True}
// {'rosgraph_msgs': ['C:/work/ws/src/ros_comm/messages/rosgraph_msgs/msg'], 'std_msgs': ['C:/work/ws/src/std_msgs/msg']}

// !!!!!!!!!!! ['__class__', '__delattr__', '__dict__', '__doc__', '__eq__', '__format__', '__getattribute__', '__hash__', '__init__', '__module__', '__ne__', '__new__', '__reduce__', '__reduce_ex__', '__repr__', '__setattr__', '__sizeof__', '__str__', '__subclasshook__', '__weakref__', '_parsed_fields', 'constants', 'fields', 'full_name', 'has_header', 'header_present', 'names', 'package', 'parsed_fields', 'short_name', 'text', 'types']




template <class ContainerAllocator>
struct IsFixedSize< ::rosgraph_msgs::Log_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct IsFixedSize< ::rosgraph_msgs::Log_<ContainerAllocator> const>
  : FalseType
  { };

template <class ContainerAllocator>
struct IsMessage< ::rosgraph_msgs::Log_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct IsMessage< ::rosgraph_msgs::Log_<ContainerAllocator> const>
  : TrueType
  { };

template <class ContainerAllocator>
struct HasHeader< ::rosgraph_msgs::Log_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct HasHeader< ::rosgraph_msgs::Log_<ContainerAllocator> const>
  : TrueType
  { };


template<class ContainerAllocator>
struct MD5Sum< ::rosgraph_msgs::Log_<ContainerAllocator> >
{
  static const char* value()
  {
    return "acffd30cd6b6de30f120938c17c593fb";
  }

  static const char* value(const ::rosgraph_msgs::Log_<ContainerAllocator>&) { return value(); }
  static const uint64_t static_value1 = 0xacffd30cd6b6de30ULL;
  static const uint64_t static_value2 = 0xf120938c17c593fbULL;
};

template<class ContainerAllocator>
struct DataType< ::rosgraph_msgs::Log_<ContainerAllocator> >
{
  static const char* value()
  {
    return "rosgraph_msgs/Log";
  }

  static const char* value(const ::rosgraph_msgs::Log_<ContainerAllocator>&) { return value(); }
};

template<class ContainerAllocator>
struct Definition< ::rosgraph_msgs::Log_<ContainerAllocator> >
{
  static const char* value()
  {
    return "##\n\
## Severity level constants\n\
##\n\
byte DEBUG=1 #debug level\n\
byte INFO=2  #general level\n\
byte WARN=4  #warning level\n\
byte ERROR=8 #error level\n\
byte FATAL=16 #fatal/critical level\n\
##\n\
## Fields\n\
##\n\
Header header\n\
byte level\n\
string name # name of the node\n\
string msg # message \n\
string file # file the message came from\n\
string function # function the message came from\n\
uint32 line # line the message came from\n\
string[] topics # topic names that the node publishes\n\
\n\
================================================================================\n\
MSG: std_msgs/Header\n\
# Standard metadata for higher-level stamped data types.\n\
# This is generally used to communicate timestamped data \n\
# in a particular coordinate frame.\n\
# \n\
# sequence ID: consecutively increasing ID \n\
uint32 seq\n\
#Two-integer timestamp that is expressed as:\n\
# * stamp.secs: seconds (stamp_secs) since epoch\n\
# * stamp.nsecs: nanoseconds since stamp_secs\n\
# time-handling sugar is provided by the client library\n\
time stamp\n\
#Frame this data is associated with\n\
# 0: no frame\n\
# 1: global frame\n\
string frame_id\n\
\n\
";
  }

  static const char* value(const ::rosgraph_msgs::Log_<ContainerAllocator>&) { return value(); }
};

} // namespace message_traits
} // namespace ros

namespace ros
{
namespace serialization
{

  template<class ContainerAllocator> struct Serializer< ::rosgraph_msgs::Log_<ContainerAllocator> >
  {
    template<typename Stream, typename T> inline static void allInOne(Stream& stream, T m)
    {
      stream.next(m.header);
      stream.next(m.level);
      stream.next(m.name);
      stream.next(m.msg);
      stream.next(m.file);
      stream.next(m.function);
      stream.next(m.line);
      stream.next(m.topics);
    }

    ROS_DECLARE_ALLINONE_SERIALIZER;
  }; // struct Log_

} // namespace serialization
} // namespace ros

namespace ros
{
namespace message_operations
{

template<class ContainerAllocator>
struct Printer< ::rosgraph_msgs::Log_<ContainerAllocator> >
{
  template<typename Stream> static void stream(Stream& s, const std::string& indent, const ::rosgraph_msgs::Log_<ContainerAllocator>& v)
  {
    s << indent << "header: ";
    s << std::endl;
    Printer< ::std_msgs::Header_<ContainerAllocator> >::stream(s, indent + "  ", v.header);
    s << indent << "level: ";
    Printer<int8_t>::stream(s, indent + "  ", v.level);
    s << indent << "name: ";
    Printer<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::stream(s, indent + "  ", v.name);
    s << indent << "msg: ";
    Printer<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::stream(s, indent + "  ", v.msg);
    s << indent << "file: ";
    Printer<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::stream(s, indent + "  ", v.file);
    s << indent << "function: ";
    Printer<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::stream(s, indent + "  ", v.function);
    s << indent << "line: ";
    Printer<uint32_t>::stream(s, indent + "  ", v.line);
    s << indent << "topics[]" << std::endl;
    for (size_t i = 0; i < v.topics.size(); ++i)
    {
      s << indent << "  topics[" << i << "]: ";
      Printer<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::stream(s, indent + "  ", v.topics[i]);
    }
  }
};

} // namespace message_operations
} // namespace ros

#endif // ROSGRAPH_MSGS_MESSAGE_LOG_H
