/* Software License Agreement (BSD License)
 *
 * Copyright (c) 2011, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Willow Garage, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Auto-generated by genmsg_cpp from file C:\work\ws\src\common_msgs\shape_msgs\msg\MeshTriangle.msg
 *
 */


#ifndef SHAPE_MSGS_MESSAGE_MESHTRIANGLE_H
#define SHAPE_MSGS_MESSAGE_MESHTRIANGLE_H


#include <string>
#include <vector>
#include <map>

#include <ros/types.h>
#include <ros/serialization.h>
#include <ros/builtin_message_traits.h>
#include <ros/message_operations.h>


namespace shape_msgs
{
template <class ContainerAllocator>
struct MeshTriangle_
{
  typedef MeshTriangle_<ContainerAllocator> Type;

  MeshTriangle_()
    : vertex_indices()  {
      vertex_indices.assign(0);
  }
  MeshTriangle_(const ContainerAllocator& _alloc)
    : vertex_indices()  {
      vertex_indices.assign(0);
  }



   typedef boost::array<uint32_t, 3>  _vertex_indices_type;
  _vertex_indices_type vertex_indices;




  typedef boost::shared_ptr< ::shape_msgs::MeshTriangle_<ContainerAllocator> > Ptr;
  typedef boost::shared_ptr< ::shape_msgs::MeshTriangle_<ContainerAllocator> const> ConstPtr;
  boost::shared_ptr<std::map<std::string, std::string> > __connection_header;

}; // struct MeshTriangle_

typedef ::shape_msgs::MeshTriangle_<std::allocator<void> > MeshTriangle;

typedef boost::shared_ptr< ::shape_msgs::MeshTriangle > MeshTrianglePtr;
typedef boost::shared_ptr< ::shape_msgs::MeshTriangle const> MeshTriangleConstPtr;

// constants requiring out of line definition



template<typename ContainerAllocator>
std::ostream& operator<<(std::ostream& s, const ::shape_msgs::MeshTriangle_<ContainerAllocator> & v)
{
ros::message_operations::Printer< ::shape_msgs::MeshTriangle_<ContainerAllocator> >::stream(s, "", v);
return s;
}

} // namespace shape_msgs

namespace ros
{
namespace message_traits
{



// BOOLTRAITS {'IsFixedSize': True, 'IsMessage': True, 'HasHeader': False}
// {'std_msgs': ['C:/work/ws/src/std_msgs/msg'], 'shape_msgs': ['C:/work/ws/src/common_msgs/shape_msgs/msg'], 'geometry_msgs': ['C:/work/ws/src/common_msgs/geometry_msgs/msg']}

// !!!!!!!!!!! ['__class__', '__delattr__', '__dict__', '__doc__', '__eq__', '__format__', '__getattribute__', '__hash__', '__init__', '__module__', '__ne__', '__new__', '__reduce__', '__reduce_ex__', '__repr__', '__setattr__', '__sizeof__', '__str__', '__subclasshook__', '__weakref__', '_parsed_fields', 'constants', 'fields', 'full_name', 'has_header', 'header_present', 'names', 'package', 'parsed_fields', 'short_name', 'text', 'types']




template <class ContainerAllocator>
struct IsFixedSize< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct IsFixedSize< ::shape_msgs::MeshTriangle_<ContainerAllocator> const>
  : TrueType
  { };

template <class ContainerAllocator>
struct IsMessage< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct IsMessage< ::shape_msgs::MeshTriangle_<ContainerAllocator> const>
  : TrueType
  { };

template <class ContainerAllocator>
struct HasHeader< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct HasHeader< ::shape_msgs::MeshTriangle_<ContainerAllocator> const>
  : FalseType
  { };


template<class ContainerAllocator>
struct MD5Sum< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
{
  static const char* value()
  {
    return "23688b2e6d2de3d32fe8af104a903253";
  }

  static const char* value(const ::shape_msgs::MeshTriangle_<ContainerAllocator>&) { return value(); }
  static const uint64_t static_value1 = 0x23688b2e6d2de3d3ULL;
  static const uint64_t static_value2 = 0x2fe8af104a903253ULL;
};

template<class ContainerAllocator>
struct DataType< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
{
  static const char* value()
  {
    return "shape_msgs/MeshTriangle";
  }

  static const char* value(const ::shape_msgs::MeshTriangle_<ContainerAllocator>&) { return value(); }
};

template<class ContainerAllocator>
struct Definition< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
{
  static const char* value()
  {
    return "# Definition of a triangle's vertices\n\
uint32[3] vertex_indices\n\
\n\
";
  }

  static const char* value(const ::shape_msgs::MeshTriangle_<ContainerAllocator>&) { return value(); }
};

} // namespace message_traits
} // namespace ros

namespace ros
{
namespace serialization
{

  template<class ContainerAllocator> struct Serializer< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
  {
    template<typename Stream, typename T> inline static void allInOne(Stream& stream, T m)
    {
      stream.next(m.vertex_indices);
    }

    ROS_DECLARE_ALLINONE_SERIALIZER;
  }; // struct MeshTriangle_

} // namespace serialization
} // namespace ros

namespace ros
{
namespace message_operations
{

template<class ContainerAllocator>
struct Printer< ::shape_msgs::MeshTriangle_<ContainerAllocator> >
{
  template<typename Stream> static void stream(Stream& s, const std::string& indent, const ::shape_msgs::MeshTriangle_<ContainerAllocator>& v)
  {
    s << indent << "vertex_indices[]" << std::endl;
    for (size_t i = 0; i < v.vertex_indices.size(); ++i)
    {
      s << indent << "  vertex_indices[" << i << "]: ";
      Printer<uint32_t>::stream(s, indent + "  ", v.vertex_indices[i]);
    }
  }
};

} // namespace message_operations
} // namespace ros

#endif // SHAPE_MSGS_MESSAGE_MESHTRIANGLE_H
