/* Software License Agreement (BSD License)
 *
 * Copyright (c) 2011, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Willow Garage, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Auto-generated by genmsg_cpp from file C:\work\ws\src\ros_comm\test\test_rosmaster\msg\Arrays.msg
 *
 */


#ifndef TEST_ROSMASTER_MESSAGE_ARRAYS_H
#define TEST_ROSMASTER_MESSAGE_ARRAYS_H


#include <string>
#include <vector>
#include <map>

#include <ros/types.h>
#include <ros/serialization.h>
#include <ros/builtin_message_traits.h>
#include <ros/message_operations.h>


namespace test_rosmaster
{
template <class ContainerAllocator>
struct Arrays_
{
  typedef Arrays_<ContainerAllocator> Type;

  Arrays_()
    : int8_arr()
    , uint8_arr()
    , int32_arr()
    , uint32_arr()
    , string_arr()
    , time_arr()  {
    }
  Arrays_(const ContainerAllocator& _alloc)
    : int8_arr(_alloc)
    , uint8_arr(_alloc)
    , int32_arr(_alloc)
    , uint32_arr(_alloc)
    , string_arr(_alloc)
    , time_arr(_alloc)  {
    }



   typedef std::vector<int8_t, typename ContainerAllocator::template rebind<int8_t>::other >  _int8_arr_type;
  _int8_arr_type int8_arr;

   typedef std::vector<uint8_t, typename ContainerAllocator::template rebind<uint8_t>::other >  _uint8_arr_type;
  _uint8_arr_type uint8_arr;

   typedef std::vector<int32_t, typename ContainerAllocator::template rebind<int32_t>::other >  _int32_arr_type;
  _int32_arr_type int32_arr;

   typedef std::vector<uint32_t, typename ContainerAllocator::template rebind<uint32_t>::other >  _uint32_arr_type;
  _uint32_arr_type uint32_arr;

   typedef std::vector<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > , typename ContainerAllocator::template rebind<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::other >  _string_arr_type;
  _string_arr_type string_arr;

   typedef std::vector<ros::Time, typename ContainerAllocator::template rebind<ros::Time>::other >  _time_arr_type;
  _time_arr_type time_arr;




  typedef boost::shared_ptr< ::test_rosmaster::Arrays_<ContainerAllocator> > Ptr;
  typedef boost::shared_ptr< ::test_rosmaster::Arrays_<ContainerAllocator> const> ConstPtr;
  boost::shared_ptr<std::map<std::string, std::string> > __connection_header;

}; // struct Arrays_

typedef ::test_rosmaster::Arrays_<std::allocator<void> > Arrays;

typedef boost::shared_ptr< ::test_rosmaster::Arrays > ArraysPtr;
typedef boost::shared_ptr< ::test_rosmaster::Arrays const> ArraysConstPtr;

// constants requiring out of line definition



template<typename ContainerAllocator>
std::ostream& operator<<(std::ostream& s, const ::test_rosmaster::Arrays_<ContainerAllocator> & v)
{
ros::message_operations::Printer< ::test_rosmaster::Arrays_<ContainerAllocator> >::stream(s, "", v);
return s;
}

} // namespace test_rosmaster

namespace ros
{
namespace message_traits
{



// BOOLTRAITS {'IsFixedSize': False, 'IsMessage': True, 'HasHeader': False}
// {'std_msgs': ['C:/work/ws/src/std_msgs/msg'], 'test_rosmaster': ['C:/work/ws/src/ros_comm/test/test_rosmaster/msg']}

// !!!!!!!!!!! ['__class__', '__delattr__', '__dict__', '__doc__', '__eq__', '__format__', '__getattribute__', '__hash__', '__init__', '__module__', '__ne__', '__new__', '__reduce__', '__reduce_ex__', '__repr__', '__setattr__', '__sizeof__', '__str__', '__subclasshook__', '__weakref__', '_parsed_fields', 'constants', 'fields', 'full_name', 'has_header', 'header_present', 'names', 'package', 'parsed_fields', 'short_name', 'text', 'types']




template <class ContainerAllocator>
struct IsFixedSize< ::test_rosmaster::Arrays_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct IsFixedSize< ::test_rosmaster::Arrays_<ContainerAllocator> const>
  : FalseType
  { };

template <class ContainerAllocator>
struct IsMessage< ::test_rosmaster::Arrays_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct IsMessage< ::test_rosmaster::Arrays_<ContainerAllocator> const>
  : TrueType
  { };

template <class ContainerAllocator>
struct HasHeader< ::test_rosmaster::Arrays_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct HasHeader< ::test_rosmaster::Arrays_<ContainerAllocator> const>
  : FalseType
  { };


template<class ContainerAllocator>
struct MD5Sum< ::test_rosmaster::Arrays_<ContainerAllocator> >
{
  static const char* value()
  {
    return "c5a1f18379b10bdd4df210944f6007a4";
  }

  static const char* value(const ::test_rosmaster::Arrays_<ContainerAllocator>&) { return value(); }
  static const uint64_t static_value1 = 0xc5a1f18379b10bddULL;
  static const uint64_t static_value2 = 0x4df210944f6007a4ULL;
};

template<class ContainerAllocator>
struct DataType< ::test_rosmaster::Arrays_<ContainerAllocator> >
{
  static const char* value()
  {
    return "test_rosmaster/Arrays";
  }

  static const char* value(const ::test_rosmaster::Arrays_<ContainerAllocator>&) { return value(); }
};

template<class ContainerAllocator>
struct Definition< ::test_rosmaster::Arrays_<ContainerAllocator> >
{
  static const char* value()
  {
    return "#for rostopic tests\n\
int8[] int8_arr\n\
uint8[] uint8_arr\n\
int32[] int32_arr\n\
uint32[] uint32_arr\n\
string[] string_arr\n\
time[] time_arr\n\
\n\
";
  }

  static const char* value(const ::test_rosmaster::Arrays_<ContainerAllocator>&) { return value(); }
};

} // namespace message_traits
} // namespace ros

namespace ros
{
namespace serialization
{

  template<class ContainerAllocator> struct Serializer< ::test_rosmaster::Arrays_<ContainerAllocator> >
  {
    template<typename Stream, typename T> inline static void allInOne(Stream& stream, T m)
    {
      stream.next(m.int8_arr);
      stream.next(m.uint8_arr);
      stream.next(m.int32_arr);
      stream.next(m.uint32_arr);
      stream.next(m.string_arr);
      stream.next(m.time_arr);
    }

    ROS_DECLARE_ALLINONE_SERIALIZER;
  }; // struct Arrays_

} // namespace serialization
} // namespace ros

namespace ros
{
namespace message_operations
{

template<class ContainerAllocator>
struct Printer< ::test_rosmaster::Arrays_<ContainerAllocator> >
{
  template<typename Stream> static void stream(Stream& s, const std::string& indent, const ::test_rosmaster::Arrays_<ContainerAllocator>& v)
  {
    s << indent << "int8_arr[]" << std::endl;
    for (size_t i = 0; i < v.int8_arr.size(); ++i)
    {
      s << indent << "  int8_arr[" << i << "]: ";
      Printer<int8_t>::stream(s, indent + "  ", v.int8_arr[i]);
    }
    s << indent << "uint8_arr[]" << std::endl;
    for (size_t i = 0; i < v.uint8_arr.size(); ++i)
    {
      s << indent << "  uint8_arr[" << i << "]: ";
      Printer<uint8_t>::stream(s, indent + "  ", v.uint8_arr[i]);
    }
    s << indent << "int32_arr[]" << std::endl;
    for (size_t i = 0; i < v.int32_arr.size(); ++i)
    {
      s << indent << "  int32_arr[" << i << "]: ";
      Printer<int32_t>::stream(s, indent + "  ", v.int32_arr[i]);
    }
    s << indent << "uint32_arr[]" << std::endl;
    for (size_t i = 0; i < v.uint32_arr.size(); ++i)
    {
      s << indent << "  uint32_arr[" << i << "]: ";
      Printer<uint32_t>::stream(s, indent + "  ", v.uint32_arr[i]);
    }
    s << indent << "string_arr[]" << std::endl;
    for (size_t i = 0; i < v.string_arr.size(); ++i)
    {
      s << indent << "  string_arr[" << i << "]: ";
      Printer<std::basic_string<char, std::char_traits<char>, typename ContainerAllocator::template rebind<char>::other > >::stream(s, indent + "  ", v.string_arr[i]);
    }
    s << indent << "time_arr[]" << std::endl;
    for (size_t i = 0; i < v.time_arr.size(); ++i)
    {
      s << indent << "  time_arr[" << i << "]: ";
      Printer<ros::Time>::stream(s, indent + "  ", v.time_arr[i]);
    }
  }
};

} // namespace message_operations
} // namespace ros

#endif // TEST_ROSMASTER_MESSAGE_ARRAYS_H
