/* Software License Agreement (BSD License)
 *
 * Copyright (c) 2011, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Willow Garage, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Auto-generated by genmsg_cpp from file C:\work\ws\src\ros_comm\test\test_rospy\msg\EmbedTest.msg
 *
 */


#ifndef TEST_ROSPY_MESSAGE_EMBEDTEST_H
#define TEST_ROSPY_MESSAGE_EMBEDTEST_H


#include <string>
#include <vector>
#include <map>

#include <ros/types.h>
#include <ros/serialization.h>
#include <ros/builtin_message_traits.h>
#include <ros/message_operations.h>

#include <std_msgs/String.h>
#include <std_msgs/Int32.h>
#include <std_msgs/Int32.h>
#include <test_rospy/Val.h>
#include <test_rospy/Val.h>
#include <test_rospy/ArrayVal.h>

namespace test_rospy
{
template <class ContainerAllocator>
struct EmbedTest_
{
  typedef EmbedTest_<ContainerAllocator> Type;

  EmbedTest_()
    : str1()
    , int1()
    , ints()
    , val()
    , vals()
    , arrayval()  {
    }
  EmbedTest_(const ContainerAllocator& _alloc)
    : str1(_alloc)
    , int1(_alloc)
    , ints(_alloc)
    , val(_alloc)
    , vals(_alloc)
    , arrayval(_alloc)  {
    }



   typedef  ::std_msgs::String_<ContainerAllocator>  _str1_type;
  _str1_type str1;

   typedef  ::std_msgs::Int32_<ContainerAllocator>  _int1_type;
  _int1_type int1;

   typedef std::vector< ::std_msgs::Int32_<ContainerAllocator> , typename ContainerAllocator::template rebind< ::std_msgs::Int32_<ContainerAllocator> >::other >  _ints_type;
  _ints_type ints;

   typedef  ::test_rospy::Val_<ContainerAllocator>  _val_type;
  _val_type val;

   typedef std::vector< ::test_rospy::Val_<ContainerAllocator> , typename ContainerAllocator::template rebind< ::test_rospy::Val_<ContainerAllocator> >::other >  _vals_type;
  _vals_type vals;

   typedef std::vector< ::test_rospy::ArrayVal_<ContainerAllocator> , typename ContainerAllocator::template rebind< ::test_rospy::ArrayVal_<ContainerAllocator> >::other >  _arrayval_type;
  _arrayval_type arrayval;




  typedef boost::shared_ptr< ::test_rospy::EmbedTest_<ContainerAllocator> > Ptr;
  typedef boost::shared_ptr< ::test_rospy::EmbedTest_<ContainerAllocator> const> ConstPtr;
  boost::shared_ptr<std::map<std::string, std::string> > __connection_header;

}; // struct EmbedTest_

typedef ::test_rospy::EmbedTest_<std::allocator<void> > EmbedTest;

typedef boost::shared_ptr< ::test_rospy::EmbedTest > EmbedTestPtr;
typedef boost::shared_ptr< ::test_rospy::EmbedTest const> EmbedTestConstPtr;

// constants requiring out of line definition



template<typename ContainerAllocator>
std::ostream& operator<<(std::ostream& s, const ::test_rospy::EmbedTest_<ContainerAllocator> & v)
{
ros::message_operations::Printer< ::test_rospy::EmbedTest_<ContainerAllocator> >::stream(s, "", v);
return s;
}

} // namespace test_rospy

namespace ros
{
namespace message_traits
{



// BOOLTRAITS {'IsFixedSize': False, 'IsMessage': True, 'HasHeader': False}
// {'test_rospy': ['C:/work/ws/src/ros_comm/test/test_rospy/msg'], 'std_msgs': ['C:/work/ws/src/std_msgs/msg'], 'test_rosmaster': ['C:/work/ws/src/ros_comm/test/test_rosmaster/msg']}

// !!!!!!!!!!! ['__class__', '__delattr__', '__dict__', '__doc__', '__eq__', '__format__', '__getattribute__', '__hash__', '__init__', '__module__', '__ne__', '__new__', '__reduce__', '__reduce_ex__', '__repr__', '__setattr__', '__sizeof__', '__str__', '__subclasshook__', '__weakref__', '_parsed_fields', 'constants', 'fields', 'full_name', 'has_header', 'header_present', 'names', 'package', 'parsed_fields', 'short_name', 'text', 'types']




template <class ContainerAllocator>
struct IsFixedSize< ::test_rospy::EmbedTest_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct IsFixedSize< ::test_rospy::EmbedTest_<ContainerAllocator> const>
  : FalseType
  { };

template <class ContainerAllocator>
struct IsMessage< ::test_rospy::EmbedTest_<ContainerAllocator> >
  : TrueType
  { };

template <class ContainerAllocator>
struct IsMessage< ::test_rospy::EmbedTest_<ContainerAllocator> const>
  : TrueType
  { };

template <class ContainerAllocator>
struct HasHeader< ::test_rospy::EmbedTest_<ContainerAllocator> >
  : FalseType
  { };

template <class ContainerAllocator>
struct HasHeader< ::test_rospy::EmbedTest_<ContainerAllocator> const>
  : FalseType
  { };


template<class ContainerAllocator>
struct MD5Sum< ::test_rospy::EmbedTest_<ContainerAllocator> >
{
  static const char* value()
  {
    return "f8b1fc6a0f70f541c9d6bd2886b9e249";
  }

  static const char* value(const ::test_rospy::EmbedTest_<ContainerAllocator>&) { return value(); }
  static const uint64_t static_value1 = 0xf8b1fc6a0f70f541ULL;
  static const uint64_t static_value2 = 0xc9d6bd2886b9e249ULL;
};

template<class ContainerAllocator>
struct DataType< ::test_rospy::EmbedTest_<ContainerAllocator> >
{
  static const char* value()
  {
    return "test_rospy/EmbedTest";
  }

  static const char* value(const ::test_rospy::EmbedTest_<ContainerAllocator>&) { return value(); }
};

template<class ContainerAllocator>
struct Definition< ::test_rospy::EmbedTest_<ContainerAllocator> >
{
  static const char* value()
  {
    return "std_msgs/String str1\n\
std_msgs/Int32 int1\n\
std_msgs/Int32[] ints\n\
Val val\n\
Val[] vals\n\
ArrayVal[] arrayval\n\
\n\
================================================================================\n\
MSG: std_msgs/String\n\
string data\n\
\n\
================================================================================\n\
MSG: std_msgs/Int32\n\
int32 data\n\
================================================================================\n\
MSG: test_rospy/Val\n\
string val\n\
================================================================================\n\
MSG: test_rospy/ArrayVal\n\
Val[] vals\n\
#Val[10] vals_fixed\n\
\n\
";
  }

  static const char* value(const ::test_rospy::EmbedTest_<ContainerAllocator>&) { return value(); }
};

} // namespace message_traits
} // namespace ros

namespace ros
{
namespace serialization
{

  template<class ContainerAllocator> struct Serializer< ::test_rospy::EmbedTest_<ContainerAllocator> >
  {
    template<typename Stream, typename T> inline static void allInOne(Stream& stream, T m)
    {
      stream.next(m.str1);
      stream.next(m.int1);
      stream.next(m.ints);
      stream.next(m.val);
      stream.next(m.vals);
      stream.next(m.arrayval);
    }

    ROS_DECLARE_ALLINONE_SERIALIZER;
  }; // struct EmbedTest_

} // namespace serialization
} // namespace ros

namespace ros
{
namespace message_operations
{

template<class ContainerAllocator>
struct Printer< ::test_rospy::EmbedTest_<ContainerAllocator> >
{
  template<typename Stream> static void stream(Stream& s, const std::string& indent, const ::test_rospy::EmbedTest_<ContainerAllocator>& v)
  {
    s << indent << "str1: ";
    s << std::endl;
    Printer< ::std_msgs::String_<ContainerAllocator> >::stream(s, indent + "  ", v.str1);
    s << indent << "int1: ";
    s << std::endl;
    Printer< ::std_msgs::Int32_<ContainerAllocator> >::stream(s, indent + "  ", v.int1);
    s << indent << "ints[]" << std::endl;
    for (size_t i = 0; i < v.ints.size(); ++i)
    {
      s << indent << "  ints[" << i << "]: ";
      s << std::endl;
      s << indent;
      Printer< ::std_msgs::Int32_<ContainerAllocator> >::stream(s, indent + "    ", v.ints[i]);
    }
    s << indent << "val: ";
    s << std::endl;
    Printer< ::test_rospy::Val_<ContainerAllocator> >::stream(s, indent + "  ", v.val);
    s << indent << "vals[]" << std::endl;
    for (size_t i = 0; i < v.vals.size(); ++i)
    {
      s << indent << "  vals[" << i << "]: ";
      s << std::endl;
      s << indent;
      Printer< ::test_rospy::Val_<ContainerAllocator> >::stream(s, indent + "    ", v.vals[i]);
    }
    s << indent << "arrayval[]" << std::endl;
    for (size_t i = 0; i < v.arrayval.size(); ++i)
    {
      s << indent << "  arrayval[" << i << "]: ";
      s << std::endl;
      s << indent;
      Printer< ::test_rospy::ArrayVal_<ContainerAllocator> >::stream(s, indent + "    ", v.arrayval[i]);
    }
  }
};

} // namespace message_operations
} // namespace ros

#endif // TEST_ROSPY_MESSAGE_EMBEDTEST_H
