"""autogenerated by genpy from visualization_msgs/InteractiveMarkerUpdate.msg. Do not edit."""
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import genpy
import geometry_msgs.msg
import visualization_msgs.msg
import std_msgs.msg

class InteractiveMarkerUpdate(genpy.Message):
  _md5sum = "83e22f99d3b31fde725e0a338200e036"
  _type = "visualization_msgs/InteractiveMarkerUpdate"
  _has_header = False #flag to mark the presence of a Header object
  _full_text = """# Identifying string. Must be unique in the topic namespace
# that this server works on.
string server_id

# Sequence number.
# The client will use this to detect if it has missed an update.
uint64 seq_num

# Type holds the purpose of this message.  It must be one of UPDATE or KEEP_ALIVE.
# UPDATE: Incremental update to previous state. 
#         The sequence number must be 1 higher than for
#         the previous update.
# KEEP_ALIVE: Indicates the that the server is still living.
#             The sequence number does not increase.
#             No payload data should be filled out (markers, poses, or erases).
uint8 KEEP_ALIVE = 0
uint8 UPDATE = 1

uint8 type

#Note: No guarantees on the order of processing.
#      Contents must be kept consistent by sender.

#Markers to be added or updated
InteractiveMarker[] markers

#Poses of markers that should be moved
InteractiveMarkerPose[] poses

#Names of markers to be erased
string[] erases

================================================================================
MSG: visualization_msgs/InteractiveMarker
# Time/frame info.
# If header.time is set to 0, the marker will be retransformed into
# its frame on each timestep. You will receive the pose feedback
# in the same frame.
# Otherwise, you might receive feedback in a different frame.
# For rviz, this will be the current 'fixed frame' set by the user.
Header header

# Initial pose. Also, defines the pivot point for rotations.
geometry_msgs/Pose pose

# Identifying string. Must be globally unique in
# the topic that this message is sent through.
string name

# Short description (< 40 characters).
string description

# Scale to be used for default controls (default=1).
float32 scale

# All menu and submenu entries associated with this marker.
MenuEntry[] menu_entries

# List of controls displayed for this marker.
InteractiveMarkerControl[] controls

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.secs: seconds (stamp_secs) since epoch
# * stamp.nsecs: nanoseconds since stamp_secs
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
# 0: no frame
# 1: global frame
string frame_id

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of postion and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: visualization_msgs/MenuEntry
# MenuEntry message.

# Each InteractiveMarker message has an array of MenuEntry messages.
# A collection of MenuEntries together describe a
# menu/submenu/subsubmenu/etc tree, though they are stored in a flat
# array.  The tree structure is represented by giving each menu entry
# an ID number and a "parent_id" field.  Top-level entries are the
# ones with parent_id = 0.  Menu entries are ordered within their
# level the same way they are ordered in the containing array.  Parent
# entries must appear before their children.

# Example:
# - id = 3
#   parent_id = 0
#   title = "fun"
# - id = 2
#   parent_id = 0
#   title = "robot"
# - id = 4
#   parent_id = 2
#   title = "pr2"
# - id = 5
#   parent_id = 2
#   title = "turtle"
#
# Gives a menu tree like this:
#  - fun
#  - robot
#    - pr2
#    - turtle

# ID is a number for each menu entry.  Must be unique within the
# control, and should never be 0.
uint32 id

# ID of the parent of this menu entry, if it is a submenu.  If this
# menu entry is a top-level entry, set parent_id to 0.
uint32 parent_id

# menu / entry title
string title

# Arguments to command indicated by command_type (below)
string command

# Command_type stores the type of response desired when this menu
# entry is clicked.
# FEEDBACK: send an InteractiveMarkerFeedback message with menu_entry_id set to this entry's id.
# ROSRUN: execute "rosrun" with arguments given in the command field (above).
# ROSLAUNCH: execute "roslaunch" with arguments given in the command field (above).
uint8 FEEDBACK=0
uint8 ROSRUN=1
uint8 ROSLAUNCH=2
uint8 command_type

================================================================================
MSG: visualization_msgs/InteractiveMarkerControl
# Represents a control that is to be displayed together with an interactive marker

# Identifying string for this control.
# You need to assign a unique value to this to receive feedback from the GUI
# on what actions the user performs on this control (e.g. a button click).
string name


# Defines the local coordinate frame (relative to the pose of the parent
# interactive marker) in which is being rotated and translated.
# Default: Identity
geometry_msgs/Quaternion orientation


# Orientation mode: controls how orientation changes.
# INHERIT: Follow orientation of interactive marker
# FIXED: Keep orientation fixed at initial state
# VIEW_FACING: Align y-z plane with screen (x: forward, y:left, z:up).
uint8 INHERIT = 0 
uint8 FIXED = 1
uint8 VIEW_FACING = 2

uint8 orientation_mode

# Interaction mode for this control
# 
# NONE: This control is only meant for visualization; no context menu.
# MENU: Like NONE, but right-click menu is active.
# BUTTON: Element can be left-clicked.
# MOVE_AXIS: Translate along local x-axis.
# MOVE_PLANE: Translate in local y-z plane.
# ROTATE_AXIS: Rotate around local x-axis.
# MOVE_ROTATE: Combines MOVE_PLANE and ROTATE_AXIS.
uint8 NONE = 0 
uint8 MENU = 1
uint8 BUTTON = 2
uint8 MOVE_AXIS = 3 
uint8 MOVE_PLANE = 4
uint8 ROTATE_AXIS = 5
uint8 MOVE_ROTATE = 6
# "3D" interaction modes work with the mouse+SHIFT+CTRL or with 3D cursors.
# MOVE_3D: Translate freely in 3D space.
# ROTATE_3D: Rotate freely in 3D space about the origin of parent frame.
# MOVE_ROTATE_3D: Full 6-DOF freedom of translation and rotation about the cursor origin.
uint8 MOVE_3D = 7
uint8 ROTATE_3D = 8
uint8 MOVE_ROTATE_3D = 9

uint8 interaction_mode


# If true, the contained markers will also be visible
# when the gui is not in interactive mode.
bool always_visible


# Markers to be displayed as custom visual representation.
# Leave this empty to use the default control handles.
#
# Note: 
# - The markers can be defined in an arbitrary coordinate frame,
#   but will be transformed into the local frame of the interactive marker.
# - If the header of a marker is empty, its pose will be interpreted as 
#   relative to the pose of the parent interactive marker.
Marker[] markers


# In VIEW_FACING mode, set this to true if you don't want the markers
# to be aligned with the camera view point. The markers will show up
# as in INHERIT mode.
bool independent_marker_orientation


# Short description (< 40 characters) of what this control does,
# e.g. "Move the robot". 
# Default: A generic description based on the interaction mode
string description

================================================================================
MSG: visualization_msgs/Marker
# See http://www.ros.org/wiki/rviz/DisplayTypes/Marker and http://www.ros.org/wiki/rviz/Tutorials/Markers%3A%20Basic%20Shapes for more information on using this message with rviz

uint8 ARROW=0
uint8 CUBE=1
uint8 SPHERE=2
uint8 CYLINDER=3
uint8 LINE_STRIP=4
uint8 LINE_LIST=5
uint8 CUBE_LIST=6
uint8 SPHERE_LIST=7
uint8 POINTS=8
uint8 TEXT_VIEW_FACING=9
uint8 MESH_RESOURCE=10
uint8 TRIANGLE_LIST=11

uint8 ADD=0
uint8 MODIFY=0
uint8 DELETE=2

Header header                        # header for time/frame information
string ns                            # Namespace to place this object in... used in conjunction with id to create a unique name for the object
int32 id 		                         # object ID useful in conjunction with the namespace for manipulating and deleting the object later
int32 type 		                       # Type of object
int32 action 	                       # 0 add/modify an object, 1 (deprecated), 2 deletes an object
geometry_msgs/Pose pose                 # Pose of the object
geometry_msgs/Vector3 scale             # Scale of the object 1,1,1 means default (usually 1 meter square)
std_msgs/ColorRGBA color             # Color [0.0-1.0]
duration lifetime                    # How long the object should last before being automatically deleted.  0 means forever
bool frame_locked                    # If this marker should be frame-locked, i.e. retransformed into its frame every timestep

#Only used if the type specified has some use for them (eg. POINTS, LINE_STRIP, ...)
geometry_msgs/Point[] points
#Only used if the type specified has some use for them (eg. POINTS, LINE_STRIP, ...)
#number of colors must either be 0 or equal to the number of points
#NOTE: alpha is not yet used
std_msgs/ColorRGBA[] colors

# NOTE: only used for text markers
string text

# NOTE: only used for MESH_RESOURCE markers
string mesh_resource
bool mesh_use_embedded_materials

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 

float64 x
float64 y
float64 z
================================================================================
MSG: std_msgs/ColorRGBA
float32 r
float32 g
float32 b
float32 a

================================================================================
MSG: visualization_msgs/InteractiveMarkerPose
# Time/frame info.
Header header

# Initial pose. Also, defines the pivot point for rotations.
geometry_msgs/Pose pose

# Identifying string. Must be globally unique in
# the topic that this message is sent through.
string name

"""
  # Pseudo-constants
  KEEP_ALIVE = 0
  UPDATE = 1

  __slots__ = ['server_id','seq_num','type','markers','poses','erases']
  _slot_types = ['string','uint64','uint8','visualization_msgs/InteractiveMarker[]','visualization_msgs/InteractiveMarkerPose[]','string[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       server_id,seq_num,type,markers,poses,erases

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(InteractiveMarkerUpdate, self).__init__(*args, **kwds)
      #message fields cannot be None, assign default values for those that are
      if self.server_id is None:
        self.server_id = ''
      if self.seq_num is None:
        self.seq_num = 0
      if self.type is None:
        self.type = 0
      if self.markers is None:
        self.markers = []
      if self.poses is None:
        self.poses = []
      if self.erases is None:
        self.erases = []
    else:
      self.server_id = ''
      self.seq_num = 0
      self.type = 0
      self.markers = []
      self.poses = []
      self.erases = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.server_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.pack('<I%ss'%length, length, _x))
      _x = self
      buff.write(_struct_QB.pack(_x.seq_num, _x.type))
      length = len(self.markers)
      buff.write(_struct_I.pack(length))
      for val1 in self.markers:
        _v1 = val1.header
        buff.write(_struct_I.pack(_v1.seq))
        _v2 = _v1.stamp
        _x = _v2
        buff.write(_struct_2I.pack(_x.secs, _x.nsecs))
        _x = _v1.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        _v3 = val1.pose
        _v4 = _v3.position
        _x = _v4
        buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
        _v5 = _v3.orientation
        _x = _v5
        buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        _x = val1.description
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        buff.write(_struct_f.pack(val1.scale))
        length = len(val1.menu_entries)
        buff.write(_struct_I.pack(length))
        for val2 in val1.menu_entries:
          _x = val2
          buff.write(_struct_2I.pack(_x.id, _x.parent_id))
          _x = val2.title
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
          _x = val2.command
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
          buff.write(_struct_B.pack(val2.command_type))
        length = len(val1.controls)
        buff.write(_struct_I.pack(length))
        for val2 in val1.controls:
          _x = val2.name
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
          _v6 = val2.orientation
          _x = _v6
          buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
          _x = val2
          buff.write(_struct_3B.pack(_x.orientation_mode, _x.interaction_mode, _x.always_visible))
          length = len(val2.markers)
          buff.write(_struct_I.pack(length))
          for val3 in val2.markers:
            _v7 = val3.header
            buff.write(_struct_I.pack(_v7.seq))
            _v8 = _v7.stamp
            _x = _v8
            buff.write(_struct_2I.pack(_x.secs, _x.nsecs))
            _x = _v7.frame_id
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            _x = val3.ns
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            _x = val3
            buff.write(_struct_3i.pack(_x.id, _x.type, _x.action))
            _v9 = val3.pose
            _v10 = _v9.position
            _x = _v10
            buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
            _v11 = _v9.orientation
            _x = _v11
            buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
            _v12 = val3.scale
            _x = _v12
            buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
            _v13 = val3.color
            _x = _v13
            buff.write(_struct_4f.pack(_x.r, _x.g, _x.b, _x.a))
            _v14 = val3.lifetime
            _x = _v14
            buff.write(_struct_2i.pack(_x.secs, _x.nsecs))
            buff.write(_struct_B.pack(val3.frame_locked))
            length = len(val3.points)
            buff.write(_struct_I.pack(length))
            for val4 in val3.points:
              _x = val4
              buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
            length = len(val3.colors)
            buff.write(_struct_I.pack(length))
            for val4 in val3.colors:
              _x = val4
              buff.write(_struct_4f.pack(_x.r, _x.g, _x.b, _x.a))
            _x = val3.text
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            _x = val3.mesh_resource
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            buff.write(_struct_B.pack(val3.mesh_use_embedded_materials))
          buff.write(_struct_B.pack(val2.independent_marker_orientation))
          _x = val2.description
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
      length = len(self.poses)
      buff.write(_struct_I.pack(length))
      for val1 in self.poses:
        _v15 = val1.header
        buff.write(_struct_I.pack(_v15.seq))
        _v16 = _v15.stamp
        _x = _v16
        buff.write(_struct_2I.pack(_x.secs, _x.nsecs))
        _x = _v15.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        _v17 = val1.pose
        _v18 = _v17.position
        _x = _v18
        buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
        _v19 = _v17.orientation
        _x = _v19
        buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
      length = len(self.erases)
      buff.write(_struct_I.pack(length))
      for val1 in self.erases:
        length = len(val1)
        if python3 or type(val1) == unicode:
          val1 = val1.encode('utf-8')
          length = len(val1)
        buff.write(struct.pack('<I%ss'%length, length, val1))
    except struct.error as se: self._check_types(se)
    except TypeError as te: self._check_types(te)

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    try:
      if self.markers is None:
        self.markers = None
      if self.poses is None:
        self.poses = None
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.server_id = str[start:end].decode('utf-8')
      else:
        self.server_id = str[start:end]
      _x = self
      start = end
      end += 9
      (_x.seq_num, _x.type,) = _struct_QB.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.markers = []
      for i in range(0, length):
        val1 = visualization_msgs.msg.InteractiveMarker()
        _v20 = val1.header
        start = end
        end += 4
        (_v20.seq,) = _struct_I.unpack(str[start:end])
        _v21 = _v20.stamp
        _x = _v21
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _struct_2I.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v20.frame_id = str[start:end].decode('utf-8')
        else:
          _v20.frame_id = str[start:end]
        _v22 = val1.pose
        _v23 = _v22.position
        _x = _v23
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
        _v24 = _v22.orientation
        _x = _v24
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.description = str[start:end].decode('utf-8')
        else:
          val1.description = str[start:end]
        start = end
        end += 4
        (val1.scale,) = _struct_f.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.menu_entries = []
        for i in range(0, length):
          val2 = visualization_msgs.msg.MenuEntry()
          _x = val2
          start = end
          end += 8
          (_x.id, _x.parent_id,) = _struct_2I.unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.title = str[start:end].decode('utf-8')
          else:
            val2.title = str[start:end]
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.command = str[start:end].decode('utf-8')
          else:
            val2.command = str[start:end]
          start = end
          end += 1
          (val2.command_type,) = _struct_B.unpack(str[start:end])
          val1.menu_entries.append(val2)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.controls = []
        for i in range(0, length):
          val2 = visualization_msgs.msg.InteractiveMarkerControl()
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.name = str[start:end].decode('utf-8')
          else:
            val2.name = str[start:end]
          _v25 = val2.orientation
          _x = _v25
          start = end
          end += 32
          (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
          _x = val2
          start = end
          end += 3
          (_x.orientation_mode, _x.interaction_mode, _x.always_visible,) = _struct_3B.unpack(str[start:end])
          val2.always_visible = bool(val2.always_visible)
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          val2.markers = []
          for i in range(0, length):
            val3 = visualization_msgs.msg.Marker()
            _v26 = val3.header
            start = end
            end += 4
            (_v26.seq,) = _struct_I.unpack(str[start:end])
            _v27 = _v26.stamp
            _x = _v27
            start = end
            end += 8
            (_x.secs, _x.nsecs,) = _struct_2I.unpack(str[start:end])
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              _v26.frame_id = str[start:end].decode('utf-8')
            else:
              _v26.frame_id = str[start:end]
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              val3.ns = str[start:end].decode('utf-8')
            else:
              val3.ns = str[start:end]
            _x = val3
            start = end
            end += 12
            (_x.id, _x.type, _x.action,) = _struct_3i.unpack(str[start:end])
            _v28 = val3.pose
            _v29 = _v28.position
            _x = _v29
            start = end
            end += 24
            (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
            _v30 = _v28.orientation
            _x = _v30
            start = end
            end += 32
            (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
            _v31 = val3.scale
            _x = _v31
            start = end
            end += 24
            (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
            _v32 = val3.color
            _x = _v32
            start = end
            end += 16
            (_x.r, _x.g, _x.b, _x.a,) = _struct_4f.unpack(str[start:end])
            _v33 = val3.lifetime
            _x = _v33
            start = end
            end += 8
            (_x.secs, _x.nsecs,) = _struct_2i.unpack(str[start:end])
            start = end
            end += 1
            (val3.frame_locked,) = _struct_B.unpack(str[start:end])
            val3.frame_locked = bool(val3.frame_locked)
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            val3.points = []
            for i in range(0, length):
              val4 = geometry_msgs.msg.Point()
              _x = val4
              start = end
              end += 24
              (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
              val3.points.append(val4)
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            val3.colors = []
            for i in range(0, length):
              val4 = std_msgs.msg.ColorRGBA()
              _x = val4
              start = end
              end += 16
              (_x.r, _x.g, _x.b, _x.a,) = _struct_4f.unpack(str[start:end])
              val3.colors.append(val4)
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              val3.text = str[start:end].decode('utf-8')
            else:
              val3.text = str[start:end]
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              val3.mesh_resource = str[start:end].decode('utf-8')
            else:
              val3.mesh_resource = str[start:end]
            start = end
            end += 1
            (val3.mesh_use_embedded_materials,) = _struct_B.unpack(str[start:end])
            val3.mesh_use_embedded_materials = bool(val3.mesh_use_embedded_materials)
            val2.markers.append(val3)
          start = end
          end += 1
          (val2.independent_marker_orientation,) = _struct_B.unpack(str[start:end])
          val2.independent_marker_orientation = bool(val2.independent_marker_orientation)
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.description = str[start:end].decode('utf-8')
          else:
            val2.description = str[start:end]
          val1.controls.append(val2)
        self.markers.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.poses = []
      for i in range(0, length):
        val1 = visualization_msgs.msg.InteractiveMarkerPose()
        _v34 = val1.header
        start = end
        end += 4
        (_v34.seq,) = _struct_I.unpack(str[start:end])
        _v35 = _v34.stamp
        _x = _v35
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _struct_2I.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v34.frame_id = str[start:end].decode('utf-8')
        else:
          _v34.frame_id = str[start:end]
        _v36 = val1.pose
        _v37 = _v36.position
        _x = _v37
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
        _v38 = _v36.orientation
        _x = _v38
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8')
        else:
          val1.name = str[start:end]
        self.poses.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.erases = []
      for i in range(0, length):
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1 = str[start:end].decode('utf-8')
        else:
          val1 = str[start:end]
        self.erases.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.server_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.pack('<I%ss'%length, length, _x))
      _x = self
      buff.write(_struct_QB.pack(_x.seq_num, _x.type))
      length = len(self.markers)
      buff.write(_struct_I.pack(length))
      for val1 in self.markers:
        _v39 = val1.header
        buff.write(_struct_I.pack(_v39.seq))
        _v40 = _v39.stamp
        _x = _v40
        buff.write(_struct_2I.pack(_x.secs, _x.nsecs))
        _x = _v39.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        _v41 = val1.pose
        _v42 = _v41.position
        _x = _v42
        buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
        _v43 = _v41.orientation
        _x = _v43
        buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        _x = val1.description
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        buff.write(_struct_f.pack(val1.scale))
        length = len(val1.menu_entries)
        buff.write(_struct_I.pack(length))
        for val2 in val1.menu_entries:
          _x = val2
          buff.write(_struct_2I.pack(_x.id, _x.parent_id))
          _x = val2.title
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
          _x = val2.command
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
          buff.write(_struct_B.pack(val2.command_type))
        length = len(val1.controls)
        buff.write(_struct_I.pack(length))
        for val2 in val1.controls:
          _x = val2.name
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
          _v44 = val2.orientation
          _x = _v44
          buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
          _x = val2
          buff.write(_struct_3B.pack(_x.orientation_mode, _x.interaction_mode, _x.always_visible))
          length = len(val2.markers)
          buff.write(_struct_I.pack(length))
          for val3 in val2.markers:
            _v45 = val3.header
            buff.write(_struct_I.pack(_v45.seq))
            _v46 = _v45.stamp
            _x = _v46
            buff.write(_struct_2I.pack(_x.secs, _x.nsecs))
            _x = _v45.frame_id
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            _x = val3.ns
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            _x = val3
            buff.write(_struct_3i.pack(_x.id, _x.type, _x.action))
            _v47 = val3.pose
            _v48 = _v47.position
            _x = _v48
            buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
            _v49 = _v47.orientation
            _x = _v49
            buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
            _v50 = val3.scale
            _x = _v50
            buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
            _v51 = val3.color
            _x = _v51
            buff.write(_struct_4f.pack(_x.r, _x.g, _x.b, _x.a))
            _v52 = val3.lifetime
            _x = _v52
            buff.write(_struct_2i.pack(_x.secs, _x.nsecs))
            buff.write(_struct_B.pack(val3.frame_locked))
            length = len(val3.points)
            buff.write(_struct_I.pack(length))
            for val4 in val3.points:
              _x = val4
              buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
            length = len(val3.colors)
            buff.write(_struct_I.pack(length))
            for val4 in val3.colors:
              _x = val4
              buff.write(_struct_4f.pack(_x.r, _x.g, _x.b, _x.a))
            _x = val3.text
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            _x = val3.mesh_resource
            length = len(_x)
            if python3 or type(_x) == unicode:
              _x = _x.encode('utf-8')
              length = len(_x)
            buff.write(struct.pack('<I%ss'%length, length, _x))
            buff.write(_struct_B.pack(val3.mesh_use_embedded_materials))
          buff.write(_struct_B.pack(val2.independent_marker_orientation))
          _x = val2.description
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.pack('<I%ss'%length, length, _x))
      length = len(self.poses)
      buff.write(_struct_I.pack(length))
      for val1 in self.poses:
        _v53 = val1.header
        buff.write(_struct_I.pack(_v53.seq))
        _v54 = _v53.stamp
        _x = _v54
        buff.write(_struct_2I.pack(_x.secs, _x.nsecs))
        _x = _v53.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
        _v55 = val1.pose
        _v56 = _v55.position
        _x = _v56
        buff.write(_struct_3d.pack(_x.x, _x.y, _x.z))
        _v57 = _v55.orientation
        _x = _v57
        buff.write(_struct_4d.pack(_x.x, _x.y, _x.z, _x.w))
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.pack('<I%ss'%length, length, _x))
      length = len(self.erases)
      buff.write(_struct_I.pack(length))
      for val1 in self.erases:
        length = len(val1)
        if python3 or type(val1) == unicode:
          val1 = val1.encode('utf-8')
          length = len(val1)
        buff.write(struct.pack('<I%ss'%length, length, val1))
    except struct.error as se: self._check_types(se)
    except TypeError as te: self._check_types(te)

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    try:
      if self.markers is None:
        self.markers = None
      if self.poses is None:
        self.poses = None
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.server_id = str[start:end].decode('utf-8')
      else:
        self.server_id = str[start:end]
      _x = self
      start = end
      end += 9
      (_x.seq_num, _x.type,) = _struct_QB.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.markers = []
      for i in range(0, length):
        val1 = visualization_msgs.msg.InteractiveMarker()
        _v58 = val1.header
        start = end
        end += 4
        (_v58.seq,) = _struct_I.unpack(str[start:end])
        _v59 = _v58.stamp
        _x = _v59
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _struct_2I.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v58.frame_id = str[start:end].decode('utf-8')
        else:
          _v58.frame_id = str[start:end]
        _v60 = val1.pose
        _v61 = _v60.position
        _x = _v61
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
        _v62 = _v60.orientation
        _x = _v62
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.description = str[start:end].decode('utf-8')
        else:
          val1.description = str[start:end]
        start = end
        end += 4
        (val1.scale,) = _struct_f.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.menu_entries = []
        for i in range(0, length):
          val2 = visualization_msgs.msg.MenuEntry()
          _x = val2
          start = end
          end += 8
          (_x.id, _x.parent_id,) = _struct_2I.unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.title = str[start:end].decode('utf-8')
          else:
            val2.title = str[start:end]
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.command = str[start:end].decode('utf-8')
          else:
            val2.command = str[start:end]
          start = end
          end += 1
          (val2.command_type,) = _struct_B.unpack(str[start:end])
          val1.menu_entries.append(val2)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.controls = []
        for i in range(0, length):
          val2 = visualization_msgs.msg.InteractiveMarkerControl()
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.name = str[start:end].decode('utf-8')
          else:
            val2.name = str[start:end]
          _v63 = val2.orientation
          _x = _v63
          start = end
          end += 32
          (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
          _x = val2
          start = end
          end += 3
          (_x.orientation_mode, _x.interaction_mode, _x.always_visible,) = _struct_3B.unpack(str[start:end])
          val2.always_visible = bool(val2.always_visible)
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          val2.markers = []
          for i in range(0, length):
            val3 = visualization_msgs.msg.Marker()
            _v64 = val3.header
            start = end
            end += 4
            (_v64.seq,) = _struct_I.unpack(str[start:end])
            _v65 = _v64.stamp
            _x = _v65
            start = end
            end += 8
            (_x.secs, _x.nsecs,) = _struct_2I.unpack(str[start:end])
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              _v64.frame_id = str[start:end].decode('utf-8')
            else:
              _v64.frame_id = str[start:end]
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              val3.ns = str[start:end].decode('utf-8')
            else:
              val3.ns = str[start:end]
            _x = val3
            start = end
            end += 12
            (_x.id, _x.type, _x.action,) = _struct_3i.unpack(str[start:end])
            _v66 = val3.pose
            _v67 = _v66.position
            _x = _v67
            start = end
            end += 24
            (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
            _v68 = _v66.orientation
            _x = _v68
            start = end
            end += 32
            (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
            _v69 = val3.scale
            _x = _v69
            start = end
            end += 24
            (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
            _v70 = val3.color
            _x = _v70
            start = end
            end += 16
            (_x.r, _x.g, _x.b, _x.a,) = _struct_4f.unpack(str[start:end])
            _v71 = val3.lifetime
            _x = _v71
            start = end
            end += 8
            (_x.secs, _x.nsecs,) = _struct_2i.unpack(str[start:end])
            start = end
            end += 1
            (val3.frame_locked,) = _struct_B.unpack(str[start:end])
            val3.frame_locked = bool(val3.frame_locked)
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            val3.points = []
            for i in range(0, length):
              val4 = geometry_msgs.msg.Point()
              _x = val4
              start = end
              end += 24
              (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
              val3.points.append(val4)
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            val3.colors = []
            for i in range(0, length):
              val4 = std_msgs.msg.ColorRGBA()
              _x = val4
              start = end
              end += 16
              (_x.r, _x.g, _x.b, _x.a,) = _struct_4f.unpack(str[start:end])
              val3.colors.append(val4)
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              val3.text = str[start:end].decode('utf-8')
            else:
              val3.text = str[start:end]
            start = end
            end += 4
            (length,) = _struct_I.unpack(str[start:end])
            start = end
            end += length
            if python3:
              val3.mesh_resource = str[start:end].decode('utf-8')
            else:
              val3.mesh_resource = str[start:end]
            start = end
            end += 1
            (val3.mesh_use_embedded_materials,) = _struct_B.unpack(str[start:end])
            val3.mesh_use_embedded_materials = bool(val3.mesh_use_embedded_materials)
            val2.markers.append(val3)
          start = end
          end += 1
          (val2.independent_marker_orientation,) = _struct_B.unpack(str[start:end])
          val2.independent_marker_orientation = bool(val2.independent_marker_orientation)
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.description = str[start:end].decode('utf-8')
          else:
            val2.description = str[start:end]
          val1.controls.append(val2)
        self.markers.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.poses = []
      for i in range(0, length):
        val1 = visualization_msgs.msg.InteractiveMarkerPose()
        _v72 = val1.header
        start = end
        end += 4
        (_v72.seq,) = _struct_I.unpack(str[start:end])
        _v73 = _v72.stamp
        _x = _v73
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _struct_2I.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v72.frame_id = str[start:end].decode('utf-8')
        else:
          _v72.frame_id = str[start:end]
        _v74 = val1.pose
        _v75 = _v74.position
        _x = _v75
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _struct_3d.unpack(str[start:end])
        _v76 = _v74.orientation
        _x = _v76
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _struct_4d.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8')
        else:
          val1.name = str[start:end]
        self.poses.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.erases = []
      for i in range(0, length):
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1 = str[start:end].decode('utf-8')
        else:
          val1 = str[start:end]
        self.erases.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill

_struct_I = genpy.struct_I
_struct_B = struct.Struct("<B")
_struct_f = struct.Struct("<f")
_struct_2i = struct.Struct("<2i")
_struct_3i = struct.Struct("<3i")
_struct_QB = struct.Struct("<QB")
_struct_4f = struct.Struct("<4f")
_struct_3B = struct.Struct("<3B")
_struct_4d = struct.Struct("<4d")
_struct_2I = struct.Struct("<2I")
_struct_3d = struct.Struct("<3d")
