#
# Copyright (C) Troy D. Straszheim
#
# Distributed under the Boost Software License, Version 1.0.
# See accompanying file LICENSE_1_0.txt or copy at
#   http://www.boost.org/LICENSE_1_0.txt
#

#
# This file is generated by cmake and installed to 
# BOOST_VERSIONED_CMAKE_FILES_DIR/Boost-1.47.0.
# 
# when a users does a find_package(Boost ...) BoostConfigVersion.cmake
# and BoostVersion.cmake will search for this file.
#

get_filename_component(CWD ${CMAKE_CURRENT_LIST_FILE} PATH)

#
#  Various variables
#
set(Boost_VERSION "1.47.0")
set(Boost_INCLUDE_DIR "${CWD}/../../../include/"
  CACHE FILEPATH "Boost include directory")
set(Boost_INCLUDE_DIRS "${Boost_INCLUDE_DIR}")
set(Boost_LIBRARY_DIRS "${CWD}/../../../lib/")
#
#  Include the imported targets
#
if(NOT Boost_IMPORT_TARGETS_ADDED)
  include("${CWD}/../../../lib//Boost.cmake")
endif()

#
#  Calculate target suffix from user variables
#
if (NOT DEFINED Boost_USE_MULTITHREADED)
  set(Boost_USE_MULTITHREADED TRUE)
endif()


if (Boost_USE_MULTITHREADED)
  set(mtflag "-mt")
  set(mtdesc "multi-threaded")
else()
  set(mtflag "")
  set(mtdesc "single-threaded")
endif()

if (Boost_USE_STATIC)
  set(staticflag "-static")
  set(staticdesc "statically-linked")
else()
  set(staticflag "-shared")
  set(staticdesc "dynamically-linked")
endif()

set(Boost_LIBRARIES "")
if (NOT Boost_FIND_COMPONENTS)
  set(Boost_FIND_COMPONENTS "wave;signals;program_options;iostreams;filesystem;unit_test_framework;system;python;graph;random;math_c99l;wserialization;regex;thread;date_time")
endif()

foreach(component ${Boost_FIND_COMPONENTS})
  #
  # Check that it is really a target
  # 
  set(target boost_${component}${mtflag}${staticflag})
  get_target_property(p_optimized ${target} TYPE)
  get_target_property(p_debug ${target}-debug TYPE)

  # If optimized and debug versions are installed, specify each
  if (p_optimized MATCHES "_LIBRARY$" AND p_debug MATCHES "_LIBRARY$")
    list(APPEND Boost_LIBRARIES "optimized;${target};debug;${target}-debug")
  else()
    # Otherwise use whatever is available
    if (p_optimized MATCHES "_LIBRARY$")
      list(APPEND Boost_LIBRARIES "${target}")
    else()
      if (p_debug MATCHES "_LIBRARY$")
        list(APPEND Boost_LIBRARIES "${target}-debug")
      else()
        list(APPEND Boost_MISSING ${component})
      endif()
    endif()
  endif()

endforeach()

# Crude error handling (TODO: proper handling of REQUIRED etc)
if (Boost_MISSING)
  message(FATAL_ERROR "Boost components not found: ${Boost_MISSING}")
endif()

