function [ point, R_end ] = gp_pickNext_max_height( gp1, gp2)
%Chooses the next point to pick
 
    persistent prevG prevSDG prevK prevSDK
    
    if isempty(prevG)
        prevG = 1;
        prevSDG = 1;
        prevK = 1;
        prevSDK = 1;
    end

    n = 50;
    dSize = 100;
    R = 36;
    x = unidrnd(R, [2, n]);
    %current is the last point added to the gp
    current = gp1.xs(:,end);
    
    x(1,:) = x(1,:) + current(1) - R/2; 
    x(2,:) = x(2,:) + current(2) - R/2;
    nx = zeros(2,n);
    
    count = 0;
    
    for i = 1:n
        if x(1,i) <= 0
            x(1,i) = x(1,i) + R;
        elseif x(1,i) > dSize
            x(1,i) = x(1,i) - R;
            
        end
        if x(2,i) <= 0 
            x(2,i) = x(2,i) + R;
        elseif x(2,i) > dSize
            x(2,i) = x(2,i) - R;
                   
        end
        count = count + 1;
        nx(:,count) = x(:,i);
       
    end
    nx = nx(:,1:count);
    [Gmeans, Gvariances] = gp_predict(gp1,nx);
    Gvariances = diag(Gvariances);
    
    [Kmeans, Kvariances] = gp_predict(gp2,nx);
    Kvariances = diag(Kvariances);
    
    
    weight = zeros(1,count);
    for i = 1:count
        gW = Gmeans(i)/prevG + 3*(Gvariances(i)^(1/2)/prevSDG);
        kW = Kmeans(i)/prevK + 10*(Kvariances(i)^(1/2)/prevSDK);
        weight(i) = 1*gW + 0*kW;
    end
    [~,j] = max(weight);
    prevG = Gmeans(j);
    prevSDG = Gvariances(j)^(1/2);
    prevK = Kmeans(j);
    prevSDK = Kvariances(j)^(1/2);
    point = nx(:,j);
      
    R_end = 50;
    

end

