% function [error] = test()

%% Parameters initialization
clear all; clc; close all;
load('SIM_Data.mat');

%load('gridSample.mat');
%Data = glb.Log;

[num_rows,num_cols,~] = size(Data);

%% Extracting the data

gp = [];
gpk = [];
%count = 1;
%gp.xs = zeros(2,num_rows*num_cols);
%gp.fs = zeros(1,num_rows*num_cols);
%for i = 1:num_rows
%    for j = 1:num_cols
%        gp.xs(1,count) = i;
%        gp.xs(2,count) = j;
%        gp.fs(1,count) = Data(i,j);
%        count = count + 1;
%    end
%end
%% Tune cases
%xTune = randData(nTraining+1:nTraining+nTuning, 1:2)';
%yTune = randData(nTraining+1:nTraining+nTuning, 6)';

%% Tuning
%gp = gp_hyper_tune(gp,xTune,yTune);


%% Training
gp.sn = 0.0001; %hyperparameter 1 (signal noise)
gp.sf = 5;     %hyperparameter 2 (function noise, not from measurement)
gp.l = 10;

gpk.sn = 0.1;
gpk.sf = 5;
gpk.l = 10;

[gp, gpk] = gp_online_trainALC_K_SIM(gp, gpk,Data);

%[gp, gpk] = gp_online_trainALC_K_GridData(gp, gpk,Data);              %Creates current model

%% Test cases
%xTest = randData(nTraining+nTuning+1:nTraining+nTuning+nTesting, 1:2)';
%yTest = randData(nTraining+nTuning+1:nTraining+nTuning+nTesting, 6)';
%% Prediction
%progress_count = length(gp.xs);

minX = min(gp.xs(1,:));
maxX = max(gp.xs(1,:));
minY = min(gp.xs(2,:));
maxY = max(gp.xs(2,:));
xTest = zeros(2,10000);
count = 0;
for i = linspace(minX, maxX, 100)
    for j = linspace(minY, maxY, 100)
        count = count+1;
        xTest(1,count) = i;
        xTest(2,count) = j;
    end
end

[m, v] = gp_predict(gp, xTest);

figure
scatter(gp.xs(1,:), gp.xs(2,:));
%% Validation/Viewing

subplot(1,3,1);
x = xTest(1,:);
y = xTest(2,:);
z = m;
[xq, yq] = meshgrid(min(x):1:max(x), min(y):1:max(y));
vq = griddata(x,y,z,xq,yq);
p = surf(xq,yq,vq, 'LineStyle', 'none');
title('geometry');
camlight left

%%
subplot(1,3,2);
[mk, vk] = gp_predict(gpk, xTest);
z = mk;
vq = griddata(x,y,z,xq,yq);
p = surf(xq,yq,vq, 'LineStyle', 'none');
title('stiffness');
camlight left
%%
subplot(1,3,3)
plot(gp.xs(1,1:150), gp.xs(2,1:150), 'r');
%[MSE, STDDEV] = ValidationConc([x ;y], z, Data)

%vs = sqrt(diag(s)); %variance at each point
%yLower = m - 1.96 * vs; %95% thresh
%yUpper = m + 1.96 * vs;

%%
%disp(['yLower = ' num2str(yLower(10))]);
%disp(['yTest = ' num2str(yTest(10))]);
%disp(['yUpper = ' num2str(yUpper(10))]);