function [ reconstruction ] = PlotPhysicalResults( gp, gpk, resolution )

    %% Prediction
%progress_count = length(gp.xs);

xTest = zeros(2,resolution*resolution);
count = 0;
for i = linspace(-40, 40, resolution)
    for j = linspace(-40,40, resolution)
        count = count+1;
        xTest(1,count) = i;
        xTest(2,count) = j;
    end
end

[m, v] = gp_predict(gp, xTest);
[mk, vk] = gp_predict(gpk, xTest);

figure
scatter(gp.xs(1,:), gp.xs(2,:));
%% Validation/Viewing

subplot(1,2,1);
x = xTest(1,:);
y = xTest(2,:);
z = m;
[xq, yq] = meshgrid(min(x):1:max(x), min(y):1:max(y));
vq = griddata(x,y,z,xq,yq);
kq = griddata(x,y,mk, xq,yq);
p = surf(xq,yq,vq, kq, 'LineStyle', 'none');
title('Geometry');
c = colorbar;
c.Label.String = 'Stiffness (N/mm)';
camlight left;

%%
subplot(1,2,2)
plot(gp.xs(1,:), gp.xs(2,:), 'r');
title('Path');
xlabel('x (mm)');
ylabel('y (mm)');

reconstruction = [];

reconstruction.meanG = m;
reconstruction.meanK = mk;

end

