close all;
clc;
clear;


%stiffness model for testing
x = linspace(0,100,100)';
y = linspace(0,100,100)';

mu = [17 19];
SIGMA = [40 .1; .1 40];
figure;
[X1,X2] = meshgrid(x,y);
X = [X1(:) X2(:)];
p = 10*mvnpdf(X,mu,SIGMA);

mu2 = [70 23];
SIGMA = [40 0.1; 0.1 60];
p2 = 25*mvnpdf(X,mu2,SIGMA);

mu3 = [60 43];
SIGMA = [40 0.1; 0.1 60];
p3 = 20*mvnpdf(X,mu3,SIGMA);

mu4 = [75 80];
SIGMA = [30 0.1; 0.1 40];
p4 = 9*mvnpdf(X,mu4,SIGMA);

p = 1000*(p+p2+p3+p4);

surf(X1,X2,reshape(p,100,100), 'LineStyle', 'none');
camlight left

mu2 = [70 23];
SIGMA = [20 0.1; 0.1 40];
k = 25*mvnpdf(X,mu2,SIGMA);

mu4 = [75 80];
SIGMA = [40 0.1; 0.1 20];
k2 = 9*mvnpdf(X,mu4,SIGMA);

mu4 = [30 70];
SIGMA = [40 0.1; 0.1 20];
k3 = 9*mvnpdf(X,mu4,SIGMA);

mu4 = [40 70];
SIGMA = [40 0.1; 0.1 20];
k4 = 9*mvnpdf(X,mu4,SIGMA);

mu4 = [30 60];
SIGMA = 2*[40 0.1; 0.1 20];
k5 = 9*mvnpdf(X,mu4,SIGMA);

mu4 = [45 60];
SIGMA = 2*[50 0.1; 0.1 30];
k6 = 9*mvnpdf(X,mu4,SIGMA);

k = 100*(10*k+ 15*k2 + 15*k3 + 20*k4 + 15*k5 + 25*k6);

figure
surf(X1, X2, reshape(k,100,100), 'LineStyle', 'none');
camlight left

Data = [];
Data.z = reshape(p,100,100);
Data.k = reshape(k,100,100)+1;

save 'SIM_Data.mat' 'Data' 


