function [ point, R_end ] = gp_pickNextALC_Single( gp, progress_count )
%Chooses the next point to pick
    
    persistent prev_H R_all
    
    if isempty(prev_H)
        prev_H = 1;
    else
        prev_H = gp.fs(end);
    end
    MaxDiff = 250;
    Boring = 1;
    
    diff = abs(Boring-prev_H)/MaxDiff + .2;
    
    R = 100*(1/diff);
    %50+50*((diff/30)^2/(1+ (diff/30)^2));
    
    %side length of square to randomly sample within
    R = round(R);
    prev_H
    R = R + mod(R,2)
    
    R_all(progress_count) = R;
    
    n = 75;
    dSize = 250;
    x = unidrnd(R, [2, n]);
    %current is the last point added to the gp
    current = gp.xs(:,end);
    
    x(1,:) = x(1,:) + current(1) - R/2; 
    x(2,:) = x(2,:) + current(2) - R/2;
    nx1 = zeros(2,n);
    nx2 = zeros(2,n);
    nx3 = zeros(2,n);
    nx4 = zeros(2,n);
    
    count1 = 0;
    count2 = 0;
    count3 = 0;
    count4 = 0;
    
    for i = 1:n
        if x(1,i) <= 0
            x(1,i) = x(1,i) + R;
        elseif x(1,i) > dSize
            x(1,i) = x(1,i) - R;
            
        end
        if x(2,i) <= 0 
            x(2,i) = x(2,i) + R;
        elseif x(2,i) > dSize
            x(2,i) = x(2,i) - R;
                   
        end
        if x(1,i) > current(1) && x(2,i) > current(2)
             count1 = count1 + 1;
             nx1(:,count1) = x(:,i);
        end
        if x(1,i) <= current(1) && x(2,i) > current(2)
             count2 = count2 + 1;
             nx2(:,count2) = x(:,i);
        end
        if x(1,i) > current(1) && x(2,i) <= current(2)
             count3 = count3 + 1;
             nx3(:,count3) = x(:,i);
        end
        if x(1,i) <= current(1) && x(2,i) <= current(2)
             count4 = count4 + 1;
             nx4(:,count4) = x(:,i);
        end
    end
    nx1 = nx1(:,1:count1);
    nx2 = nx2(:,1:count2);
    nx3 = nx3(:,1:count3);
    nx4 = nx4(:,1:count4);
    nx = [nx1 nx2 nx3 nx4];
    count = count1 + count2 + count3 + count4;
    nx
    
    %prep for alc
    alc.Cinv = inv(chol(gp.Ks));
    numX = size(gp.xs,2);
    numR = size(current,2);
    alc.RefkN = zeros(count*numX, numR);
    
    
    for i = 1:count
        alc.RefkN((i-1)*numX+1:i*numX,:) = sparse(gp_sqexp(gp, gp.xs, nx(:,i)))';
    end
    
    %could also try this by adding all of them at once rather than
    %doing each one.
    deltas = zeros(1,count);
    for i = 1:count
        %could also try maximum
        deltas(i) = max(gp_ALC_Single(gp, nx(:,i), nx, count, alc, numX));
    end
    avgg = zeros(1,4);
    avgg(1) = mean(deltas(1:count1))
    avgg(2) = mean(deltas(count1 + 1:(count1+count2)))
    avgg(3) = mean(deltas(count1+count2+1:count1+count2+count3))
    avgg(4) = mean(deltas(count1+count2+count3+1:count))
    [~,j] = max(avgg);
    %scatter3(nx(1,1:count),nx(2,1:count), deltas);
    %input('waiting');
    
    if(j==1)
       [~,i] = max(deltas(1:count1));
       point = nx1(:,i); 
    end
     if(j==2)
       [~,i] = max(deltas(count1+1:count1+count2));
       point = nx2(:,i); 
     end
     if(j==3)
       [~,i] = max(deltas(count1+count2+1:count1+count2+count3));
       point = nx3(:,i); 
     end
     if(j==4)
       [~,i] = max(deltas(count1+count2+count3+1:count));
       point = nx4(:,i); 
     end
    
    
    if (progress_count == 200) 
        %figure
        %plot(1:200,R_all); 
    end
    R_end = R_all;

end

