% Sqaured exponential convariance function
% Provides very smooth sample functions, that are infinitely differentiable
% Function variables close in input space are highly correlated, whereas function variables far apart relative to the lengthscale gp.l are uncorrelated.
function f = gp_sqexp(gp, xa, xb)
f = zeros(size(xa,2), size(xb,2));
for i=1:size(xa,2),
    d = repmat(xa(:,i),1,size(xb,2)) - xb;
    s = sum(d.*d, 1);
    
    % gp.s and gp.l(hyperparameters) govern properties of sample function
    % gp.s controls the typical amplitude
    % gp.l controls the lengthscale of the variation
    f(i,:) = (gp.sf.^2).*exp(-s./(2*(gp.l.^2)));
end
