%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function checks to see if the colormap has been set to gray before 
% or not.
% This is due to the strange Matlab behavior which opens a new window on 
% colormap(Handle, 'gray');
% if the colormap has already been set once before.
%
% Usage: colormap_(Handle, CMString)
% Input: Handle is the handle to the axes
%        CMString is the colormap to use 
%
% Copyright: Ultrasonix Medical Corporation Nov 2012
% Author: Ali Baghani, Research Scientist, ali.baghani@ultrasonix.com
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function colormap_(Handle, CMString)
GrayCM = [0         0         0;
    0.0159    0.0159    0.0159;
    0.0317    0.0317    0.0317;
    0.0476    0.0476    0.0476;
    0.0635    0.0635    0.0635;
    0.0794    0.0794    0.0794;
    0.0952    0.0952    0.0952;
    0.1111    0.1111    0.1111;
    0.1270    0.1270    0.1270;
    0.1429    0.1429    0.1429;
    0.1587    0.1587    0.1587;
    0.1746    0.1746    0.1746;
    0.1905    0.1905    0.1905;
    0.2063    0.2063    0.2063;
    0.2222    0.2222    0.2222;
    0.2381    0.2381    0.2381;
    0.2540    0.2540    0.2540;
    0.2698    0.2698    0.2698;
    0.2857    0.2857    0.2857;
    0.3016    0.3016    0.3016;
    0.3175    0.3175    0.3175;
    0.3333    0.3333    0.3333;
    0.3492    0.3492    0.3492;
    0.3651    0.3651    0.3651;
    0.3810    0.3810    0.3810;
    0.3968    0.3968    0.3968;
    0.4127    0.4127    0.4127;
    0.4286    0.4286    0.4286;
    0.4444    0.4444    0.4444;
    0.4603    0.4603    0.4603;
    0.4762    0.4762    0.4762;
    0.4921    0.4921    0.4921;
    0.5079    0.5079    0.5079;
    0.5238    0.5238    0.5238;
    0.5397    0.5397    0.5397;
    0.5556    0.5556    0.5556;
    0.5714    0.5714    0.5714;
    0.5873    0.5873    0.5873;
    0.6032    0.6032    0.6032;
    0.6190    0.6190    0.6190;
    0.6349    0.6349    0.6349;
    0.6508    0.6508    0.6508;
    0.6667    0.6667    0.6667;
    0.6825    0.6825    0.6825;
    0.6984    0.6984    0.6984;
    0.7143    0.7143    0.7143;
    0.7302    0.7302    0.7302;
    0.7460    0.7460    0.7460;
    0.7619    0.7619    0.7619;
    0.7778    0.7778    0.7778;
    0.7937    0.7937    0.7937;
    0.8095    0.8095    0.8095;
    0.8254    0.8254    0.8254;
    0.8413    0.8413    0.8413;
    0.8571    0.8571    0.8571;
    0.8730    0.8730    0.8730;
    0.8889    0.8889    0.8889;
    0.9048    0.9048    0.9048;
    0.9206    0.9206    0.9206;
    0.9365    0.9365    0.9365;
    0.9524    0.9524    0.9524;
    0.9683    0.9683    0.9683;
    0.9841    0.9841    0.9841;
    1.0000    1.0000    1.0000];

JetCM = [0         0    0.5625;
         0         0    0.6250;
         0         0    0.6875;
         0         0    0.7500;
         0         0    0.8125;
         0         0    0.8750;
         0         0    0.9375;
         0         0    1.0000;
         0    0.0625    1.0000;
         0    0.1250    1.0000;
         0    0.1875    1.0000;
         0    0.2500    1.0000;
         0    0.3125    1.0000;
         0    0.3750    1.0000;
         0    0.4375    1.0000;
         0    0.5000    1.0000;
         0    0.5625    1.0000;
         0    0.6250    1.0000;
         0    0.6875    1.0000;
         0    0.7500    1.0000;
         0    0.8125    1.0000;
         0    0.8750    1.0000;
         0    0.9375    1.0000;
         0    1.0000    1.0000;
    0.0625    1.0000    0.9375;
    0.1250    1.0000    0.8750;
    0.1875    1.0000    0.8125;
    0.2500    1.0000    0.7500;
    0.3125    1.0000    0.6875;
    0.3750    1.0000    0.6250;
    0.4375    1.0000    0.5625;
    0.5000    1.0000    0.5000;
    0.5625    1.0000    0.4375;
    0.6250    1.0000    0.3750;
    0.6875    1.0000    0.3125;
    0.7500    1.0000    0.2500;
    0.8125    1.0000    0.1875;
    0.8750    1.0000    0.1250;
    0.9375    1.0000    0.0625;
    1.0000    1.0000         0;
    1.0000    0.9375         0;
    1.0000    0.8750         0;
    1.0000    0.8125         0;
    1.0000    0.7500         0;
    1.0000    0.6875         0;
    1.0000    0.6250         0;
    1.0000    0.5625         0;
    1.0000    0.5000         0;
    1.0000    0.4375         0;
    1.0000    0.3750         0;
    1.0000    0.3125         0;
    1.0000    0.2500         0;
    1.0000    0.1875         0;
    1.0000    0.1250         0;
    1.0000    0.0625         0;
    1.0000         0         0;
    0.9375         0         0;
    0.8750         0         0;
    0.8125         0         0;
    0.7500         0         0;
    0.6875         0         0;
    0.6250         0         0;
    0.5625         0         0;
    0.5000         0         0];


CopperCM = [0         0         0;
    0.0198    0.0124    0.0079;
    0.0397    0.0248    0.0158;
    0.0595    0.0372    0.0237;
    0.0794    0.0496    0.0316;
    0.0992    0.0620    0.0395;
    0.1190    0.0744    0.0474;
    0.1389    0.0868    0.0553;
    0.1587    0.0992    0.0632;
    0.1786    0.1116    0.0711;
    0.1984    0.1240    0.0790;
    0.2183    0.1364    0.0869;
    0.2381    0.1488    0.0948;
    0.2579    0.1612    0.1027;
    0.2778    0.1736    0.1106;
    0.2976    0.1860    0.1185;
    0.3175    0.1984    0.1263;
    0.3373    0.2108    0.1342;
    0.3571    0.2232    0.1421;
    0.3770    0.2356    0.1500;
    0.3968    0.2480    0.1579;
    0.4167    0.2604    0.1658;
    0.4365    0.2728    0.1737;
    0.4563    0.2852    0.1816;
    0.4762    0.2976    0.1895;
    0.4960    0.3100    0.1974;
    0.5159    0.3224    0.2053;
    0.5357    0.3348    0.2132;
    0.5556    0.3472    0.2211;
    0.5754    0.3596    0.2290;
    0.5952    0.3720    0.2369;
    0.6151    0.3844    0.2448;
    0.6349    0.3968    0.2527;
    0.6548    0.4092    0.2606;
    0.6746    0.4216    0.2685;
    0.6944    0.4340    0.2764;
    0.7143    0.4464    0.2843;
    0.7341    0.4588    0.2922;
    0.7540    0.4712    0.3001;
    0.7738    0.4836    0.3080;
    0.7937    0.4960    0.3159;
    0.8135    0.5084    0.3238;
    0.8333    0.5208    0.3317;
    0.8532    0.5332    0.3396;
    0.8730    0.5456    0.3475;
    0.8929    0.5580    0.3554;
    0.9127    0.5704    0.3633;
    0.9325    0.5828    0.3712;
    0.9524    0.5952    0.3790;
    0.9722    0.6076    0.3869;
    0.9921    0.6200    0.3948;
    1.0000    0.6324    0.4027;
    1.0000    0.6448    0.4106;
    1.0000    0.6572    0.4185;
    1.0000    0.6696    0.4264;
    1.0000    0.6820    0.4343;
    1.0000    0.6944    0.4422;
    1.0000    0.7068    0.4501;
    1.0000    0.7192    0.4580;
    1.0000    0.7316    0.4659;
    1.0000    0.7440    0.4738;
    1.0000    0.7564    0.4817;
    1.0000    0.7688    0.4896;
    1.0000    0.7812    0.4975];
    
switch CMString
    case 'gray'
        TargetCM = GrayCM;
    case 'jet'
        TargetCM = JetCM;
    case 'copper'
        TargetCM = CopperCM;
end

CurrentCM = colormap(Handle);
if (sum(abs(CurrentCM(:) - TargetCM(:))<1e-3) ~= 192)
    colormap(Handle, TargetCM);
end
end