%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function plots the pre scan converted m data saved by the Sonix
% systems
%
% Copyright: Ultrasonix Medical Corporation Nov 2012
% Author: Ali Baghani, Research Scientist, ali.baghani@ultrasonix.com
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plot_EnvDetLogComp(Data, Properties, Handle)

n = size(Data,1)/2;

% Seperating the Envelope detected and Log compressed components
EnvelopeDetected = Data(1:n,     :);
LogCompressed    = Data(n+1:end, :);

EnvelopeDetected = (EnvelopeDetected - min(EnvelopeDetected(:)))/(max(EnvelopeDetected(:)) - min(EnvelopeDetected(:)));
LogCompressed    = (LogCompressed - min(LogCompressed(:)))/(max(LogCompressed(:)) - min(LogCompressed(:)));

I = [EnvelopeDetected LogCompressed];

% Dislaying the RF data sequence
imagesc(I, 'Parent', Handle);
colormap_(Handle, 'gray');
axis(Handle, 'equal');
axis(Handle, 'tight');
end