function out = beamform(preBeamformed, fulAprSz)
% The following script take the pre-beamform data and creates beamfromed
% image. Note: first dimension has to be lines and second dimension has 
% to be samples.
% input:
%   preBeamformed: the first dimension should be scan lines and the second
%   dimension should be the channel samples
% output:
%   out: beamformed rf data
%
% Author: Reza Zahiri Azar
% Copyright Ultrasonix Medical Corporation - April 2010

nl = size(preBeamformed,1);   % number of lines
ns = size(preBeamformed,2);   % number of samples

hlfAprSz = floor(fulAprSz/2);
fulAprSz = hlfAprSz*2 + 1;
win = hanning(fulAprSz)'; 
% win = ones(1,fulAprSz); 
chnls = zeros(1,fulAprSz);

% calc delays
channelSpacing = 0.3;    % milimeter
sampleSpacing = 0.01925; % milimeter
nSampleOffset = 500;
x = -hlfAprSz: hlfAprSz;

for i = 1:nl    % for each line
%     disp(['scanline #', num2str(i)]);
    
    for j=1:ns  % find the value for each sample
        
        % calc delays based on depth
        distance2probe = (j + nSampleOffset) * sampleSpacing;
        rad = sqrt( (hlfAprSz*channelSpacing)^2 +  distance2probe^2 );
        scale = (rad - distance2probe)/ (hlfAprSz)^2;
        delays = + x.^2 * scale/ sampleSpacing  ; %/ (5 + j/128); % Note: achieved experimentally and needs to be calculated mathematically

        cntr = i;   % center of apreture
        apr = cntr + x; % full aperture index
        
        chnls = zeros(1,fulAprSz);
        cnt = 0;    % count the number of channel that we use
        for k = 1:fulAprSz  % find the corresponding value from each channel
            
            chlIndx = apr(k);
            if chlIndx<1, continue, end;
            if chlIndx>nl, continue, end;
            cnt = cnt + 1;

            chlSmpl = round(j+delays(k));

            if chlSmpl<1, continue, end;
            if chlSmpl>ns, continue, end;
            
            chnls(k) = preBeamformed(chlIndx, chlSmpl);%* win(k);
            
        end;
        % apodization 
        
        % beamfroming
        out(i,j) = sum( chnls ) ;%/ cnt;
        
    end;
end
