function [header, RFframe] = readPWframe(path, filename, frameN, upSamp)
% Read the specified RF frame from .drf files in PW Doppler mode
% Usage:
% [header, RFframe] = readRFframe(path, filename, frameInd);
%       path, filename:   strings showing the path and filename to the data
%       frameN:         number of observations of the gate that we want
% Example:
%       Reading single frame
%       [header, RFframe] = readRFframe('c:\', 'rf.drf', 100);
%       will return the first 100 observations of the gate
%
% Copyright Ultrasonix Medical Corporation - May 2009
% Author: Reza Zahiri Azar,

% open file
fid = fopen([path filename],'r');
% pars the file name for info
hdr = fread(fid, 19, 'int32');
header = struct(  'type', {hdr(1)}, ...
                    'frames', {hdr(2)}, ...
                    'width', {hdr(3)}, ...
                    'height', {hdr(4)}, ...
                    'samplesize', {hdr(5)}, ...
                    'upperleftx', {hdr(6)}, ...
                    'upperlefty', {hdr(7)}, ...
                    'upperrightx', {hdr(8)}, ...
                    'upperrighty', {hdr(9)}, ...
                    'bottomrightx', {hdr(10)}, ...
                    'bottomrighty', {hdr(11)}, ...
                    'bottomleftx', {hdr(12)}, ...
                    'bottomlefty', {hdr(13)}, ...
                    'probe', {hdr(14)}, ...
                    'txfrequency', {hdr(15)}, ...
                    'samplefrequency', {hdr(16)}, ...
                    'framerate', {hdr(17)}, ...
                    'linedensity', {hdr(18)}, ...
                    'extra1',{hdr(19)});

lLength  = header.height;      % length of each line in samples
header.height = header.height * upSamp;
% read the frame
% for i = 1:frameN
    %disp( fread(fid, 1, 'int32') );   % read the data index
    RFframe  = resample(fread(fid, [lLength, frameN], 'int16' ),upSamp,1,4)'; % the actual data
% end;
fclose(fid);