function varargout = GraphicUnit_export(varargin)
% GRAPHICUNIT_EXPORT M-file for GraphicUnit_export.fig
%      GRAPHICUNIT_EXPORT, by itself, creates a new GRAPHICUNIT_EXPORT or
%      raises the existing
%      singleton*.
%
%      H = GRAPHICUNIT_EXPORT returns the handle to a new GRAPHICUNIT_EXPORT or the handle to
%      the existing singleton*.
%
%      GRAPHICUNIT_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GRAPHICUNIT_EXPORT.M with the given input arguments.
%
%      GRAPHICUNIT_EXPORT('Property','Value',...) creates a new GRAPHICUNIT_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before GraphicUnit_export_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GraphicUnit_export_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES
%
% Edit the above text to modify the response to help GraphicUnit_export
%
% Last Modified by GUIDE v2.5 14-Dec-2005 15:25:43
%
% STAUFFER - modified 7/9/07 and onwards. Added support for .rf files.
% Tony de Souza-Daw - modified 8/9/08. Added Image Contrast Options & Header
% Edited by Ali Baghani Nov 2012 to allow for passing on of the filename
% via the gui call
% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GraphicUnit_export_OpeningFcn, ...
                   'gui_OutputFcn',  @GraphicUnit_export_OutputFcn, ...
                   'gui_LayoutFcn',  @GraphicUnit_export_LayoutFcn, ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before GraphicUnit_export is made visible.
function GraphicUnit_export_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GraphicUnit_export (see VARARGIN)

% Choose default command line output for GraphicUnit_export
handles.output = hObject;

%%%%%%%% initialization for blocks %%%%%%%%
handles.filteringMod = 1;   % no filtering
handles.StartFreq = 1;
handles.EndFreq   = 10;
handles.EvnvelopeMod = 1;
handles.CompressionMod = 1;
handles.downsamplingFactor = 1;
handles.nLineCount = 254;
handles.nLineLength = 4096;
handles.nPrefFrame = 1;
% Uses the input arguments for the filename
if (nargin==7) 
    if isstr(varargin{2})
        handles.nFileName = varargin{2};
        set(handles.RFFile,'String',handles.nFileName);
        handles.nPrefFrame = varargin{3};
        set(handles.PrefFrame, 'String', num2str(handles.nPrefFrame));
        handles.version = varargin{4};
        % Update handles structure
        guidata(hObject, handles);
        % Read the file into the GUI
        handles = INITBUTTON_Callback(handles.INITBUTTON, [], handles);
        set(handles.LineCnt, 'String', num2str(handles.nLineCount));
        set(handles.LineLen, 'String', num2str(handles.nLineLength));
    end
else
    handles.nFileName = 'enter filename...'; 
    handles.version = '5.7.x';
end
handles.RfHeader = [];

% Update handles structure
guidata(hObject, handles);
drawnow

% UIWAIT makes GraphicUnit_export wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = GraphicUnit_export_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function DOWNSAMPLINGMENU_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DOWNSAMPLINGMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in DOWNSAMPLINGMENU.
function DOWNSAMPLINGMENU_Callback(hObject, eventdata, handles)
% hObject    handle to DOWNSAMPLINGMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns DOWNSAMPLINGMENU contents as cell array
%        contents{get(hObject,'Value')} returns selected item from DOWNSAMPLINGMENU

val = get(hObject,'Value');
if (val==1)
    handles.downsamplingFactor = 1;
else
    handles.downsamplingFactor = 2*(val-1);
end;
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function FIRMENU_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FIRMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in FIRMENU.
function FIRMENU_Callback(hObject, eventdata, handles)
% hObject    handle to FIRMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns FIRMENU contents as cell array
%        contents{get(hObject,'Value')} returns selected item from FIRMENU


val = get(hObject,'Value');
if (val == 1)   % it is no
    set(handles.StartFreqBox,'Visible','off'); % make sure it is visible
    set(handles.EndFreqBox,'Visible','off'); % make sure it is visible
    set(handles.From,'Visible','off'); % make sure it is visible
    set(handles.To,'Visible','off'); % make sure it is visible
else
    set(handles.StartFreqBox,'Visible','on'); % make sure it is visible
    set(handles.EndFreqBox,'Visible','on'); % make sure it is visible
    set(handles.From,'Visible','on'); % make sure it is visible
    set(handles.To,'Visible','on'); % make sure it is visible
end;
handles.filteringMod = val;
guidata(hObject,handles);

% --- Executes on button press in INITBUTTON.
function handles = INITBUTTON_Callback(hObject, eventdata, handles)
% hObject    handle to INITBUTTON (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
clc;

%STAUFFER
%This is callback for "Read Raw Data" button

 handles.nFileName = get(handles.RFFile,'String'); %This text box doesn't initialize properly. Forced Initialized.
%Checks file extension
[pathstr,namestr,extstr,verstr] = fileparts(handles.nFileName);

switch extstr
    case '.rf'
        %STAUFFER
        %Option to read from .rf files which have header info.
        [rf] = readRFfile(handles.nFileName, handles.nPrefFrame, handles.version);
            %Note - this returns RF as type double, to match what's otput
            % by readDMPfileRF in the orig code below.
        LineCount = rf.w; 
        handles.nLineCount = rf.w; %Assume should set this
        LineSize = rf.h/2; %left the "/2" from orig code
        handles.nLineLength = rf.h;
        Frames = 1; %just set # of frames to 1 for now
        RFrames = rf.data;
        handles.RfHeader = rf; %put all RF header into the handles struct.
    case '.dmp'
       %orig code - ".dmp" file
        LineCount = handles.nLineCount;
        LineSize = handles.nLineLength/2;
        Frames = handles.nPrefFrame;
        try,
            RFrames = readDMPfileRF(handles.nFileName,LineCount,LineSize*2,Frames); % read first two frames of RF
        catch,
        end;
    otherwise error('unrecognized file extension');
end

handles.numOfLine = LineCount;      % save the number of ray lines
guidata(hObject,handles);

%Line = floor(LineCount/2);          % RF A-line index
%Tony de Souza-Daw
Line = str2double(get(handles.GrphLine,'String')); % RF A-line index
handles.Line = Line;
% Frame = handles.nPrefFrame;
n = length(RFrames);

Frame1 = squeeze(RFrames(:,:));
RFLine1 = squeeze(RFrames(:,Line));

%%%%%%%%%%%%%% Updating the Data %%%%%%%%%%%%%
handles.Frame1   = Frame1;    % save the frame
guidata(hObject,handles);

%%%%%%%%%%%%% RF Image %%%%%%%%%%%%%%%%%%%%%%%
axes(handles.Image1)
set(handles.Image1,'Visible','on'); % make sure it is visible
imagesc(abs(Frame1));
title('Raw RF Image');
colormap(gray);
hold on;
line([handles.Line,handles.Line], [1, length(RFLine1)])
%%%%%%%%%%%%% RF Line %%%%%%%%%%%%%%%%%%%%%%%%
handles.RFLine1 = RFLine1;  % save ray line
guidata(hObject,handles);

axes(handles.time1)
set(handles.time1,'Visible','on');
plot(RFLine1,'b');
axis([0 length(RFLine1) min(RFLine1) max(RFLine1)]);
tmp = ['Line ',num2str(Line), ' - Raw RF data'];
title(tmp);

%%%%%%%%%%%%%%%%%% Spectrum %%%%%%%%%%%%%%%%%
filterOrder = 5;    % Butterworth filter order
FFTLength = 1024;   % Length of FFT calculation

%Tony de Souza-Daw
if ~isempty(handles.RfHeader); %Take sampling frequency from the header
Fs = handles.RfHeader.sf; 
else
Fs = 20e6;      % sampling frequency
end;
Ts = 1/Fs;      % period
c  = 1540;      % speed of sound m/s
L  = n;         % number of samples
D  = L*c/(Fs*2);        % Depth in meter
T  = D/(c/2);          % total time
t  = 0:Ts:T; t = t(1:L);

Y = fft(RFLine1,FFTLength); 
Spectrum1 = Y.* conj(Y) / FFTLength;

f = (Fs/1e6)*(0:FFTLength/2)/FFTLength;
axes(handles.freq1)
set(handles.freq1,'Visible','on'); % make sure it is visible
plot(f,Spectrum1(1:(FFTLength/2 + 1)),'b')
%AXIS([0 (Fs/2e6) 0 5e5]);
tmp = ['Frequency Content of Line ', num2str(Line)];
title(tmp);


% --- Executes on button press in GENERATEBOTTON.
function GENERATEBOTTON_Callback(hObject, eventdata, handles)
% hObject    handle to GENERATEBOTTON (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%STAUFFER - trying to change appearance of button while calculating...
set(hObject, 'Enable', 'off');

Frame1  = handles.Frame1;
RFLine1 = handles.RFLine1;
n = length(RFLine1);
disp(['Min/Max of original: ' num2str(min(min(Frame1))) ' ' num2str(max(max(Frame1)))]);

%%%%%%%%% FIR %%%%%%%%%%%%%
set(hObject, 'String', 'working...filter...');
drawnow

filterOrder = 5;    % Butterworth filter order
FFTLength = 1024;   % Length of FFT calculation

if ~isempty(handles.RfHeader);
Fs = handles.RfHeader.sf;
else
Fs = 40e6;      % sampling frequency
end;
Ts = 1/Fs;      % period
c  = 1540;      % speed of sound m/s
L  = n;         % number of samples
D  = L*c/(Fs*2);        % Depth in meter
T  = D/(c/2);           % total time
t  = 0:Ts:T; t = t(1:L);

if (handles.filteringMod == 1 )     % no filtering
    LPFImg  = Frame1;
    LPFLine = RFLine1;
else
	LowFcut  = handles.StartFreq*1e6; % Low  cutt-off frequency of the band-limited white noise
	HighFcut = handles.EndFreq*1e6; % High cutt-off frequency of the band-limited white noise
	Wn = [LowFcut HighFcut]/(Fs/2);
	[B,A] = butter(filterOrder,Wn);
    
    LPFImg = Frame1; %pre-allocate for speed
    for i=1:handles.numOfLine
        LPFImg(:,i) = filter(B,A,Frame1(:,i));
    end;
    
    LPFLine = filter(B,A,RFLine1);
end;
%%%%%%%%%%%%%%% Envelope detection %%%%%
set(hObject, 'String', 'Envelope Detection...');
drawnow
if (handles.EvnvelopeMod == 2)  % Hilbert
    disp(['Min/Max before Hilbert: ' num2str(min(min(LPFImg))) ' ' num2str(max(max(LPFImg)))]);
    EnvImg  = abs(hilbert(LPFImg));
    EnvLine = abs(hilbert(LPFLine));
    disp(['Min/Max after Hilbert: ' num2str(min(min(EnvImg))) ' ' num2str(max(max(EnvImg)))]);
elseif (handles.EvnvelopeMod == 3)
    EnvImg = abs(LPFImg);
    EnvLine = abs(LPFLine);
else
    EnvImg = LPFImg;
    EnvLine = LPFLine;
end;

%%%%%%%%% compression %%%%%%%%%%%5
set(hObject, 'String', 'Compression...');
drawnow
if (handles.CompressionMod == 1)    % no compression
    CmpImg  = EnvImg;
    CmpLine = EnvLine;
elseif (handles.CompressionMod == 2) % logcompression
    %STAUFFER note - log() is natural log
    %NOTE - this isn't compressing into 8 bit, but rather remapping with a
    %new maximum that's log of the max value. The call to iamgesc below
    %will scale linearly into 8 bit for display.
    CmpImg  = sign(EnvImg).*log( 1 + abs(EnvImg));
    CmpLine = sign(EnvLine).*log( 1 + abs(EnvLine));
else
    %STAUFFER - note, as (1 / N) factor --> ~0.13, the curve gets very
    %close to a basic log curve.
    %Like above, this isn't compressing into 8 bit, but rather remapping
    %with some compression.
    CmpImg = sign(EnvImg).*exp(1/(handles.CompressionMod-1)*log( 1 + abs(EnvImg)));      % temporary squre root
    CmpLine = sign(EnvLine).*exp(1/(handles.CompressionMod-1)*log( 1 + abs(EnvLine)));
end;

%%%%%%%%%% downsampling %%%%%%%%%%
%STAUFFER - looking at Matlab doc on 'filter' function, this code performs
%a windowed average on the input using a window of size 'downS'.
%This does a windowed averaging of size downS along each column,
% and then sub-samples by only taking every downS row for the output.
%
set(hObject, 'String', 'Downsampling...');
drawnow
if (handles.downsamplingFactor == 1)
    RFLine2 = CmpLine;
    Frame2  = CmpImg;
else
	downS = handles.downsamplingFactor;
	b = ones(downS,1)/downS;
	X = filter(b,1,CmpLine);
	RFLine2 = X(1:handles.downsamplingFactor:end);

    Y = CmpImg; %pre-allocate. This speeds things up quite a bit.
    for i=1:handles.numOfLine
        Y(:,i) = filter(b,1,CmpImg(:,i));
            %running/windowed averaging
    end;
	
% 	Frame2  = Y(1:handles.downsamplingFactor:end,:);
    Frame2 = Y;
        %sub-sampling
        %The resultant image size from the imagesc call below 
        % looks the same on output because the size
        % of axes don't change, it just gets stretched to fit.
end;

%%%%%%%%%%%%% RF Image %%%%%%%%%%%%%%%%%%%%
set(hObject, 'String', 'Drawing...');
drawnow
axes(handles.Image2)
set(handles.Image2,'Visible','on'); % make sure it is visible
imagesc(abs(Frame2)); 
title('Processed Image');
colormap(gray);
hold on;
line([handles.Line, handles.Line], [1, length(RFLine1)],'color', 'c')

%%%%%%%%%%%%% RF Line %%%%%%%%%%%%%%%%%%
set(hObject, 'String', 'RF Line...');
drawnow
axes(handles.time2)
set(handles.time2,'Visible','on'); % make sure it is visible
plot(RFLine2,'c');
axis([0 length(RFLine2) min(RFLine2) max(RFLine2)]);
tmp = [num2str(handles.Line), ' Line - Processed RF data']
title(tmp);

%%%%%%%%%%%%%%%%%% Spectrum %%%%%%%%%%%%%%

Y = fft(double(RFLine2),FFTLength); %STAUFFER added cast to double cuz was complaining can't do fft on int16 type
Spectrum2 = Y.* conj(Y) / FFTLength;

f = (Fs/1e6)*(0:FFTLength/2)/FFTLength;
axes(handles.freq2)
set(handles.freq2,'Visible','on'); % make sure it is visible
plot(f,Spectrum2(1:(FFTLength/2 + 1)),'c')
%AXIS([0 (Fs/2e6) 0 5e5]);
tmp = ['Frequency Content of Line ', num2str(handles.Line)];
title(tmp);


%STAUFFER - trying to change appearance of button while calculating...
set(hObject, 'Enable', 'on');
set(hObject, 'String', 'Generate');
drawnow

% --- Executes during object creation, after setting all properties.
function ENVELOPEMENU_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ENVELOPEMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in ENVELOPEMENU.
function ENVELOPEMENU_Callback(hObject, eventdata, handles)
% hObject    handle to ENVELOPEMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ENVELOPEMENU contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ENVELOPEMENU
handles.EvnvelopeMod = get(hObject,'Value');
% switch val
% 	case 1
% 	% The user selected the first item
%         handles.EvnvelopeMod = 1;   % hilbert
% 	case 2
% 	% The user selected the first item
%         handles.EvnvelopeMod = 2;   % absolute
% end;
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function COMPRESSIONMENU_CreateFcn(hObject, eventdata, handles)
% hObject    handle to COMPRESSIONMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on selection change in COMPRESSIONMENU.
function COMPRESSIONMENU_Callback(hObject, eventdata, handles)
% hObject    handle to COMPRESSIONMENU (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns COMPRESSIONMENU contents as cell array
%        contents{get(hObject,'Value')} returns selected item from COMPRESSIONMENU

handles.CompressionMod = get(hObject,'Value');
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function StartFreqBox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to StartFreqBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function StartFreqBox_Callback(hObject, eventdata, handles)
% hObject    handle to StartFreqBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of StartFreqBox as text
%        str2double(get(hObject,'String')) returns contents of StartFreqBox as a double

handles.StartFreq = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function EndFreqBox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EndFreqBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function EndFreqBox_Callback(hObject, eventdata, handles)
% hObject    handle to EndFreqBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of EndFreqBox as text
%        str2double(get(hObject,'String')) returns contents of EndFreqBox as a double

handles.EndFreq = str2double(get(hObject,'String'));
guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function RFFile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RFFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function RFFile_Callback(hObject, eventdata, handles)
% hObject    handle to RFFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of RFFile as text
%        str2double(get(hObject,'String')) returns contents of RFFile as a double
handles.nFileName = get(hObject,'String');
guidata(hObject,handles);



% --------------------------------------------------------------------
function HEADER_Callback(hObject, eventdata, handles)
% hObject    handle to HEADER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~isempty(handles.RfHeader);
showHeader(handles.RfHeader);
else
msg_export('A','Need to Read a RF Image')
end;
% --------------------------------------------------------------------
function EXIT_Callback(hObject, eventdata, handles)
% hObject    handle to HEADER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close;

% --------------------------------------------------------------------
function RFCntrst_Callback(hObject, eventdata, handles)
% hObject    handle to HEADER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if strcmp(get(handles.Image1,'visible'),'on')
    imcontrast(handles.Image1);
else
    msg_export('A','Need to Read a RF Image');
end;

% --------------------------------------------------------------------
function RecCntrst_Callback(hObject, eventdata, handles)
% hObject    handle to HEADER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if strcmp(get(handles.Image2,'visible'),'on')
    imcontrast(handles.Image2);
else
    msg_export('A','Need to Generate an Image');
end;



function Spectro_Callback(hObject, eventdata, handles)
% hObject    handle to HEADER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if strcmp(get(handles.Image1,'visible'),'on')
    [y,f,t,p] = spectrogram(handles.RFLine1, 100, 50 ,length(handles.RFLine1), handles.RfHeader.sf);  %100 Elements in Window. With 50 Elements overlap.
        
      figure, surf(t,f,10*log10(abs(p)),'EdgeColor','none');   
      axis xy; axis tight; colormap(jet); view(0,90);
      xlabel('Time');
      ylabel('Frequency (Hz)');
      title(['Spectrogram of Frame: ' num2str(handles.nPrefFrame) ' and Line Number: ' num2str(handles.Line)]);
      colorbar;
      
else
    msg_export('A','Need to Load an Image');
end;


% --------------------------------------------------------------------
function File_Callback(hObject, eventdata, handles)
% hObject    handle to File (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes during object creation, after setting all properties.
function LineCnt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LineCnt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function LineCnt_Callback(hObject, eventdata, handles)
% hObject    handle to LineCnt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LineCnt as text
%        str2double(get(hObject,'String')) returns contents of LineCnt as a double

handles.nLineCount = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function LineLen_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LineLen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function LineLen_Callback(hObject, eventdata, handles)
% hObject    handle to LineLen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LineLen as text
%        str2double(get(hObject,'String')) returns contents of LineLen as a double

handles.nLineLength = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function PrefFrame_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PrefFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function PrefFrame_Callback(hObject, eventdata, handles)
% hObject    handle to PrefFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PrefFrame as text
%        str2double(get(hObject,'String')) returns contents of PrefFrame as a double

handles.nPrefFrame = str2double(get(hObject,'String'));
guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function GrphLine_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GrphLine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function GrphLine_Callback(hObject, eventdata, handles)
% hObject    handle to GrphLine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PrefFrame as text
%        str2double(get(hObject,'String')) returns contents of PrefFrame as a double

handles.Line = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Creates and returns a handle to the GUI figure. 
function h1 = GraphicUnit_export_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

h1 = figure(...
'Units','characters',...
'Color',[0.92156862745098 0.92156862745098 0.894117647058823],...
'Colormap',[0 0 0.5625;0 0 0.625;0 0 0.6875;0 0 0.75;0 0 0.8125;0 0 0.875;0 0 0.9375;0 0 1;0 0.0625 1;0 0.125 1;0 0.1875 1;0 0.25 1;0 0.3125 1;0 0.375 1;0 0.4375 1;0 0.5 1;0 0.5625 1;0 0.625 1;0 0.6875 1;0 0.75 1;0 0.8125 1;0 0.875 1;0 0.9375 1;0 1 1;0.0625 1 1;0.125 1 0.9375;0.1875 1 0.875;0.25 1 0.8125;0.3125 1 0.75;0.375 1 0.6875;0.4375 1 0.625;0.5 1 0.5625;0.5625 1 0.5;0.625 1 0.4375;0.6875 1 0.375;0.75 1 0.3125;0.8125 1 0.25;0.875 1 0.1875;0.9375 1 0.125;1 1 0.0625;1 1 0;1 0.9375 0;1 0.875 0;1 0.8125 0;1 0.75 0;1 0.6875 0;1 0.625 0;1 0.5625 0;1 0.5 0;1 0.4375 0;1 0.375 0;1 0.3125 0;1 0.25 0;1 0.1875 0;1 0.125 0;1 0.0625 0;1 0 0;0.9375 0 0;0.875 0 0;0.8125 0 0;0.75 0 0;0.6875 0 0;0.625 0 0;0.5625 0 0],...
'IntegerHandle','off',...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'MenuBar','none',...
'Name','GraphicUnit',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'Position',[1 1 175.8 49.0769230769231],...
'Renderer',get(0,'defaultfigureRenderer'),...
'RendererMode','manual',...
'HandleVisibility','callback',...
'Tag','figure1',...
'UserData',[]);

setappdata(h1, 'GUIDEOptions',struct(...
'active_h', [], ...
'taginfo', struct(...
'figure', 2, ...
'axes', 7, ...
'togglebutton', 2, ...
'pushbutton', 4, ...
'checkbox', 8, ...
'slider', 2, ...
'frame', 2, ...
'popupmenu', 6, ...
'listbox', 2, ...
'edit', 7, ...
'text', 13), ...
'override', 1, ...
'release', 13, ...
'resize', 'simple', ...
'accessibility', 'callback', ...
'mfile', 1, ...
'callbacks', 1, ...
'singleton', 1, ...
'syscolorfig', 1, ...
'blocking', 0, ...
'lastSavedFile', 'C:\Documents and Settings\reza\Desktop\RF data on Ultrasonix (D82d834b2c284df)\RF data on Ultrasonix (D82d834b2c284df)\GraphicUnit.m'));


h2 = axes(...
'Parent',h1,...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[0.0898748577929465 0.46551724137931 0.308304891922639 0.393416927899687],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','Image1',...
'Visible','off');


h3 = get(h2,'title');

set(h3,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.5 1.02589641434263 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h4 = get(h2,'xlabel');

set(h4,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.496309963099631 -0.0936254980079683 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off',...
'Visible','off');

h5 = get(h2,'ylabel');

set(h5,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.105166051660517 0.49601593625498 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h6 = get(h2,'zlabel');

set(h6,...
'Parent',h2,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-0.293357933579336 1.35258964143426 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h7 = axes(...
'Parent',h1,...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[0.592718998862344 0.467084639498433 0.31740614334471 0.393416927899687],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','Image2',...
'Visible','off');


h8 = get(h7,'title');

set(h8,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.5 1.02589641434263 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h9 = get(h7,'xlabel');

set(h9,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.496415770609319 -0.0936254980079683 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off',...
'Visible','off');

h10 = get(h7,'ylabel');

set(h10,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.102150537634409 0.49601593625498 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h11 = get(h7,'zlabel');

set(h11,...
'Parent',h7,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-1.86917562724014 1.34860557768924 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h12 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''DOWNSAMPLINGMENU_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.440273037542662 0.556426332288401 0.102389078498294 0.0344827586206897],...
'String',{  '1'; '2'; '4'; '6'; '8'; '10'; '12'; '14'; '16'; '18'; '20' },...
'Style','popupmenu',...
'Value',1,...
'CreateFcn','GraphicUnit_export(''DOWNSAMPLINGMENU_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','DOWNSAMPLINGMENU');


h13 = axes(...
'Parent',h1,...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[0.055745164960182 0.247648902821317 0.418657565415245 0.122257053291536],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','time1',...
'Visible','off');


h14 = get(h13,'title');

set(h14,...
'Parent',h13,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.498641304347826 1.08333333333333 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h15 = get(h13,'xlabel');

set(h15,...
'Parent',h13,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.498641304347826 -0.301282051282052 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off',...
'Visible','off');

h16 = get(h13,'ylabel');

set(h16,...
'Parent',h13,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.0774456521739131 0.480769230769231 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h17 = get(h13,'zlabel');

set(h17,...
'Parent',h13,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-0.134510869565217 6.13461538461538 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h18 = axes(...
'Parent',h1,...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[0.533560864618885 0.246081504702194 0.433447098976109 0.123824451410658],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','time2',...
'Visible','off');


h19 = get(h18,'title');

set(h19,...
'Parent',h18,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.5 1.08227848101266 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h20 = get(h18,'xlabel');

set(h20,...
'Parent',h18,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.49737532808399 -0.29746835443038 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off',...
'Visible','off');

h21 = get(h18,'ylabel');

set(h21,...
'Parent',h18,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.0748031496062991 0.487341772151899 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h22 = get(h18,'zlabel');

set(h22,...
'Parent',h18,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-1.23228346456693 6.06962025316456 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h23 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''FIRMENU_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.441410693970421 0.785266457680251 0.100113765642776 0.0344827586206897],...
'String',{  'No'; 'Yes' },...
'Style','popupmenu',...
'Value',1,...
'CreateFcn','GraphicUnit_export(''FIRMENU_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','FIRMENU');


h24 = axes(...
'Parent',h1,...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[0.055745164960182 0.0564263322884013 0.419795221843003 0.122257053291536],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','freq1',...
'Visible','off');


h25 = get(h24,'title');

set(h25,...
'Parent',h24,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.5 1.08333333333333 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h26 = get(h24,'xlabel');

set(h26,...
'Parent',h24,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.497289972899729 -0.30128205128205 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off',...
'Visible','off');

h27 = get(h24,'ylabel');

set(h27,...
'Parent',h24,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.0772357723577236 0.480769230769231 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h28 = get(h24,'zlabel');

set(h28,...
'Parent',h24,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-0.134146341463415 7.69871794871795 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h29 = axes(...
'Parent',h1,...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Position',[0.531285551763367 0.0564263322884013 0.435722411831627 0.123824451410658],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','freq2',...
'Visible','off');


h30 = get(h29,'title');

set(h30,...
'Parent',h29,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.5 1.08227848101266 1.00005459937205],...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h31 = get(h29,'xlabel');

set(h31,...
'Parent',h29,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[0.497389033942559 -0.29746835443038 1.00005459937205],...
'VerticalAlignment','cap',...
'HandleVisibility','off',...
'Visible','off');

h32 = get(h29,'ylabel');

set(h32,...
'Parent',h29,...
'Color',[0 0 0],...
'HorizontalAlignment','center',...
'Position',[-0.0744125326370757 0.487341772151899 1.00005459937205],...
'Rotation',90,...
'VerticalAlignment','bottom',...
'HandleVisibility','off',...
'Visible','off');

h33 = get(h29,'zlabel');

set(h33,...
'Parent',h29,...
'Color',[0 0 0],...
'HorizontalAlignment','right',...
'Position',[-1.22062663185379 7.60126582278481 1.00005459937205],...
'HandleVisibility','off',...
'Visible','off');

h34 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.772549019607843 0.886274509803922 0.886274509803922],...
'Callback','GraphicUnit_export(''INITBUTTON_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.425483503981797 0.871473354231975 0.143344709897611 0.0376175548589342],...
'String','Read Raw Data',...
'Tag','INITBUTTON');


h35 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.772549019607843 0.886274509803922 0.886274509803922],...
'Callback','GraphicUnit_export(''GENERATEBOTTON_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.425483503981797 0.412225705329154 0.143344709897611 0.0376175548589342],...
'String','Generate',...
'Tag','GENERATEBOTTON');

h36 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''ENVELOPEMENU_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.441410693970421 0.63166144200627 0.102389078498294 0.0376175548589342],...
'String',{  'No'; 'Hilbert'; 'Absolute' },...
'Style','popupmenu',...
'Value',1,...
'CreateFcn','GraphicUnit_export(''ENVELOPEMENU_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','ENVELOPEMENU');


h37 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''COMPRESSIONMENU_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.440273037542662 0.474921630094044 0.103526734926052 0.0344827586206897],...
'String',{  'No'; 'Log'; '2nd root'; '3rd root'; '4th root'; '5th root'; '6th root'; '7th root'; '8th root'; '9th root' },...
'Style','popupmenu',...
'Value',1,...
'CreateFcn','GraphicUnit_export(''COMPRESSIONMENU_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','COMPRESSIONMENU');


h38 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''StartFreqBox_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.441410693970421 0.70846394984326 0.037542662116041 0.0329153605015674],...
'String','1',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''StartFreqBox_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','StartFreqBox',...
'Visible','off');


h39 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''EndFreqBox_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.500568828213879 0.70846394984326 0.043230944254835 0.0329153605015674],...
'String','10',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''EndFreqBox_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','EndFreqBox',...
'Visible','off');


h40 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.439135381114903 0.829153605015674 0.101251422070535 0.0235109717868339],...
'String','Filtering',...
'Style','text',...
'Tag','text2');


h41 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.43230944254835 0.752351097178683 0.0637087599544938 0.0235109717868339],...
'String','From (MHz)',...
'Style','text',...
'Tag','From',...
'Visible','off');


h42 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.494880546075085 0.752351097178683 0.0637087599544938 0.0235109717868339],...
'String','To  (MHz)',...
'Style','text',...
'Tag','To',...
'Visible','off');


h43 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.449374288964733 0.677115987460815 0.0819112627986348 0.0235109717868339],...
'String','Envelope',...
'Style','text',...
'Tag','text5');


h44 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.445961319681456 0.598746081504702 0.0898748577929465 0.0235109717868339],...
'String','Down Sampling',...
'Style','text',...
'Tag','text6');


h45 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.441410693970421 0.518808777429467 0.0967007963594994 0.0235109717868339],...
'String','Compression',...
'Style','text',...
'Tag','text7');


h46 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''RFFile_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.0847895335608646 0.943573667711599 0.369738339021615 0.0360501567398119],...
'String','enter a file name',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''RFFile_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','RFFile');


h47 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.933333333333333 0.933333333333333 0.933333333333333],...
'CData',[],...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.0219112627986348 0.949843260188088 0.0614334470989761 0.0250783699059561],...
'String','File Name:',...
'Style','text',...
'Tag','text8',...
'UserData',[]);


h48 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.933333333333333 0.933333333333333 0.933333333333333],...
'CData',[],...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.604391353811149 0.948275862068966 0.0716723549488055 0.0266457680250784],...
'String','Line Length:',...
'Style','text',...
'Tag','text9',...
'UserData',[]);


h49 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.933333333333333 0.933333333333333 0.933333333333333],...
'CData',[],...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.462423208191126 0.948275862068966 0.0671217292377702 0.0266457680250784],...
'String','Line Count:',...
'Style','text',...
'Tag','text10',...
'UserData',[]);


h50 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''LineCnt_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.532957906712173 0.946708463949843 0.0534698521046644 0.0329153605015674],...
'String','254',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''LineCnt_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','LineCnt');


h51 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''LineLen_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.677201365187713 0.946708463949843 0.0534698521046644 0.0329153605015674],...
'String','4096',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''LineLen_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','LineLen');


h52 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.933333333333333 0.933333333333333 0.933333333333333],...
'CData',[],...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.745460750853242 0.946708463949843 0.0887372013651877 0.0282131661442006],...
'String','Prefered Frame:',...
'Style','text',...
'Tag','text11',...
'UserData',[]);


h53 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''PrefFrame_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.835335608646189 0.948275862068966 0.0364050056882821 0.0313479623824451],...
'String','1',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''PrefFrame_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','PrefFrame');


h54 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'CData',[],...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ForegroundColor',[0 0.501960784313725 0.752941176470588],...
'ListboxTop',0,...
'Position',[0.372013651877133 -0.00156739811912226 0.244596131968146 0.0235109717868339],...
'String','Ultrasonix Medical Corporation  (c) 2005-2010',...
'Style','text',...
'Tag','text12',...
'UserData',[]);

%Tony de Souza-Daw
h55 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.933333333333333 0.933333333333333 0.933333333333333],...
'CData',[],...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.87460750853242 0.946708463949843 0.0587372013651877 0.0282131661442006],...
'String','Line:',...
'Style','text',...
'Tag','ImLine',...
'UserData',[]);

h56 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[1 1 1],...
'Callback','GraphicUnit_export(''GrphLine_Callback'',gcbo,[],guidata(gcbo))',...
'FontSize',get(0,'defaultuicontrolFontSize'),...
'ListboxTop',0,...
'Position',[0.935335608646189 0.948275862068966 0.0364050056882821 0.0313479623824451],...
'String','127',...
'Style','edit',...
'CreateFcn','GraphicUnit_export(''GrphLine_CreateFcn'',gcbo,[],guidata(gcbo))',...
'Tag','GrphLine');


h57 = uimenu(...
'Parent',h1,...
'Callback','GraphicUnit_export(''File_Callback'',gcbo,[],guidata(gcbo))',...
'Label','File',...
'Tag','File'); %,...
%'CreateFcn','GraphicUnit_export(''FILE_CreateFcn'',gcbo,[],guidata(gcbo))');

h58 = uimenu(...
'Parent',h57,...
'Accelerator','H',...
'Callback','GraphicUnit_export(''HEADER_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Header',...
'Tag','HEADER');

h59 = uimenu(...
'Parent',h57,...
'Callback','GraphicUnit_export(''RFCntrst_Callback'',gcbo,[],guidata(gcbo))',...
'Label','RF Image Contrast',...
'Tag','RFCntrst');

h60 = uimenu(...
'Parent',h57,...
'Callback','GraphicUnit_export(''RecCntrst_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Reconstructed Image Contrast',...
'Tag','RecCntrst');

h61 = uimenu(...
'Parent',h57,...
'Callback','GraphicUnit_export(''Spectro_Callback'',gcbo,[],guidata(gcbo))',...
'Label','RF Line Spectrogram',...
'Tag','RecCntrst');


h62 = uimenu(...
'Parent',h57,...
'Accelerator','Q',...
'Callback','GraphicUnit_export(''EXIT_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Exit',...
'Tag','EXIT');

hsingleton = h1;


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)


%   GUI_MAINFCN provides these command line APIs for dealing with GUIs
%
%      GRAPHICUNIT_EXPORT, by itself, creates a new GRAPHICUNIT_EXPORT or raises the existing
%      singleton*.
%
%      H = GRAPHICUNIT_EXPORT returns the handle to a new GRAPHICUNIT_EXPORT or the handle to
%      the existing singleton*.
%
%      GRAPHICUNIT_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GRAPHICUNIT_EXPORT.M with the given input arguments.
%
%      GRAPHICUNIT_EXPORT('Property','Value',...) creates a new GRAPHICUNIT_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before untitled_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to untitled_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".

%   Copyright 1984-2002 The MathWorks, Inc.
%   $Revision: 1.5 $ $Date: 2003/07/17 18:28:28 $

gui_StateFields =  {'gui_Name'
                    'gui_Singleton'
                    'gui_OpeningFcn'
                    'gui_OutputFcn'
                    'gui_LayoutFcn'
                    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);        
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [getfield(gui_State, gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % GRAPHICUNIT_EXPORT
    % create the GUI
    gui_Create = 1;
elseif numargin > 3 & ischar(varargin{1}) & ishandle(varargin{2})
    % GRAPHICUNIT_EXPORT('CALLBACK',hObject,eventData,handles,...)
    gui_Create = 0;
else
    % GRAPHICUNIT_EXPORT(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = 1;
end

if gui_Create == 0
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else
        feval(varargin{:});
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.
    
    % Do feval on layout code in m-file if it exists
    if ~isempty(gui_State.gui_LayoutFcn)
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        end
    end
    
    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    
    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig 
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA
        guidata(gui_hFigure, guihandles(gui_hFigure));
    end
    
    % If user specified 'Visible','off' in p/v pairs, don't make the figure
    % visible.
    gui_MakeVisible = 1;
    for ind=1:2:length(varargin)
        if length(varargin) == ind
            break;
        end
        len1 = min(length('visible'),length(varargin{ind}));
        len2 = min(length('off'),length(varargin{ind+1}));
        if ischar(varargin{ind}) & ischar(varargin{ind+1}) & ...
                strncmpi(varargin{ind},'visible',len1) & len2 > 1
            if strncmpi(varargin{ind+1},'off',len2)
                gui_MakeVisible = 0;
            elseif strncmpi(varargin{ind+1},'on',len2)
                gui_MakeVisible = 1;
            end
        end
    end
    
    % Check for figure param value pairs
    for index=1:2:length(varargin)
        if length(varargin) == index
            break;
        end
        try, set(gui_hFigure, varargin{index}, varargin{index+1}), catch, break, end
    end

    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end
    
    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});
    
    if ishandle(gui_hFigure)
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
        
        % Make figure visible
        if gui_MakeVisible
            set(gui_hFigure, 'Visible', 'on')
            if gui_Options.singleton 
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        rmappdata(gui_hFigure,'InGUIInitialization');
    end
    
    % If handle visibility is set to 'callback', turn it on until finished with
    % OutputFcn
    if ishandle(gui_hFigure)
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end
    
    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end
    
    if ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end    

function gui_hFigure = local_openfig(name, singleton)
try
    gui_hFigure = openfig(name, singleton, 'auto');
catch
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
end

