function varargout = msg_export(varargin)
% MSG_EXPORT M-file for msg_export.fig
%      MSG_EXPORT by itself, creates a new MSG_EXPORT or raises the
%      existing singleton*.
%
%      H = MSG_EXPORT returns the handle to a new MSG_EXPORT or the handle to
%      the existing singleton*.
%
%      MSG_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MSG_EXPORT.M with the given input arguments.
%
%      MSG_EXPORT('Property','Value',...) creates a new MSG_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before msg_export_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to msg_export_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help msg_export
% Author: Tony de Souza-Daw
% Purposes: A helper file, to display messages to the screen.
% Last Modified by GUIDE v2.5 07-Sep-2008 14:30:45

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @msg_export_OpeningFcn, ...
                   'gui_OutputFcn',  @msg_export_OutputFcn, ...
                   'gui_LayoutFcn',  @msg_export_LayoutFcn, ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before msg_export is made visible.
function msg_export_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to msg_export (see VARARGIN)

% Choose default command line output for msg_export
handles.output = 'Yes';

% Update handles structure
guidata(hObject, handles);


if ~isempty(varargin)
txt = varargin{2};
set(handles.text1,'String', txt);
else
    close; %no text was sent.
end;

% Insert custom Title and Text if specified by the user
% Hint: when choosing keywords, be sure they are not easily confused 
% with existing figure properties.  See the output of set(figure) for
% a list of figure properties.
if(nargin > 3)
    for index = 1:2:(nargin-3),
        if nargin-3==index, break, end
        switch lower(varargin{index})
         case 'title'
          set(hObject, 'Name', varargin{index+1});
         case 'string'
          set(handles.text1, 'String', varargin{index+1});
        end
    end
end

% Determine the position of the dialog - centered on the callback figure
% if available, else, centered on the screen
FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
    ScreenUnits=get(0,'Units');
    set(0,'Units','pixels');
    ScreenSize=get(0,'ScreenSize');
    set(0,'Units',ScreenUnits);

    FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
    FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
    GCBFOldUnits = get(gcbf,'Units');
    set(gcbf,'Units','pixels');
    GCBFPos = get(gcbf,'Position');
    set(gcbf,'Units',GCBFOldUnits);
    FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
                   (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Show a question icon from dialogicons.mat - variables questIconData
% and questIconMap
load dialogicons.mat

IconData=questIconData;
questIconMap(256,:) = get(handles.figure1, 'Color');
IconCMap=questIconMap;

Img=image(IconData, 'Parent', handles.axes1);
set(handles.figure1, 'Colormap', IconCMap);

set(handles.axes1, ...
    'Visible', 'off', ...
    'YDir'   , 'reverse'       , ...
    'XLim'   , get(Img,'XData'), ...
    'YLim'   , get(Img,'YData')  ...
    );

% Make the GUI modal
set(handles.figure1,'WindowStyle','modal')


% UIWAIT makes msg_export wait for user response (see UIRESUME)
uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = msg_export_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% The figure can be deleted now
delete(handles.figure1);

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.output = 'ok';

% Update handles structure
guidata(hObject, handles);

% Use UIRESUME instead of delete because the OutputFcn needs
% to get the updated handles structure.
uiresume(handles.figure1);


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if isequal(get(handles.figure1, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(handles.figure1);
else
    % The GUI is no longer waiting, just close it
    delete(handles.figure1);
end


% --- Executes on key press over figure1 with no controls selected.
function figure1_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Check for "enter" or "escape"
if isequal(get(hObject,'CurrentKey'),'escape')
    % User said no by hitting escape
    handles.output = 'No';
    
    % Update handles structure
    guidata(hObject, handles);
    
    uiresume(handles.figure1);
end    
    
if isequal(get(hObject,'CurrentKey'),'return')
    uiresume(handles.figure1);
end    


% --- Creates and returns a handle to the GUI figure. 
function h1 = msg_export_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

appdata = [];
appdata.GUIDEOptions = struct(...
    'active_h', [], ...
    'taginfo', struct(...
    'figure', 2, ...
    'pushbutton', 3, ...
    'axes', 2, ...
    'text', 2), ...
    'override', 1, ...
    'release', 13, ...
    'resize', 'none', ...
    'accessibility', 'callback', ...
    'mfile', 1, ...
    'callbacks', 1, ...
    'singleton', 1, ...
    'syscolorfig', 1, ...
    'blocking', 0, ...
    'lastSavedFile', 'C:\Documents and Settings\Tony\My Documents\PhD\Ultrasonix Sonix RP\Programming\msg_export.m');
appdata.lastValidTag = 'figure1';
appdata.GUIDELayoutEditor = [];

h1 = figure(...
'Units','characters',...
'PaperUnits',get(0,'defaultfigurePaperUnits'),...
'CloseRequestFcn','msg_export(''figure1_CloseRequestFcn'',gcbf,[],guidata(gcbf))',...
'Color',[0.925490196078431 0.913725490196078 0.847058823529412],...
'Colormap',[0 0 0;1 1 1;0.984313725490196 0.956862745098039 0.6;0.984313725490196 0.952941176470588 0.6;0 0 0.6;0.988235294117647 0.956862745098039 0.603921568627451;0.988235294117647 0.956862745098039 0.6;0.690196078431373 0.662745098039216 0.666666666666667;0.0549019607843137 0.0509803921568627 0.0549019607843137;0.0627450980392157 0.0588235294117647 0.0627450980392157;0.0705882352941176 0.0666666666666667 0.0705882352941176;0.0156862745098039 0.0117647058823529 0.0196078431372549;0.0352941176470588 0.0313725490196078 0.0392156862745098;0.623529411764706 0.596078431372549 0.658823529411765;0.0196078431372549 0.0156862745098039 0.0274509803921569;0.501960784313725 0.482352941176471 0.647058823529412;0.447058823529412 0.427450980392157 0.643137254901961;0.388235294117647 0.372549019607843 0.63921568627451;0.270588235294118 0.258823529411765 0.627450980392157;0.294117647058824 0.282352941176471 0.627450980392157;0.309803921568627 0.298039215686275 0.631372549019608;0.352941176470588 0.341176470588235 0.635294117647059;0.125490196078431 0.12156862745098 0.611764705882353;0.149019607843137 0.145098039215686 0.615686274509804;0.192156862745098 0.184313725490196 0.619607843137255;0.223529411764706 0.215686274509804 0.619607843137255;0 0 0.00784313725490196;0 0 0.00392156862745098;0.0196078431372549 0.0196078431372549 0.603921568627451;0.0470588235294118 0.0431372549019608 0.603921568627451;0.0784313725490196 0.0745098039215686 0.607843137254902;0.0823529411764706 0.0784313725490196 0.607843137254902;0.105882352941176 0.101960784313725 0.611764705882353;0.00392156862745098 0.00392156862745098 0.0196078431372549;0.00784313725490196 0.00784313725490196 0.0196078431372549;0.0117647058823529 0.0117647058823529 0.0274509803921569;0.0235294117647059 0.0235294117647059 0.0352941176470588;0.0274509803921569 0.0274509803921569 0.0392156862745098;1 0.996078431372549 0.623529411764706;1 1 0.627450980392157;1 0.996078431372549 0.631372549019608;1 1 0.635294117647059;1 1 0.643137254901961;1 1 0.650980392156863;0.0705882352941176 0.0705882352941176 0.0509803921568627;0.305882352941176 0.305882352941176 0.227450980392157;0.16078431372549 0.16078431372549 0.12156862745098;0.0392156862745098 0.0392156862745098 0.0352941176470588;0.0705882352941176 0.0705882352941176 0.0666666666666667;0.0862745098039216 0.0862745098039216 0.0823529411764706;0.184313725490196 0.184313725490196 0.176470588235294;0.0941176470588235 0.0941176470588235 0.0901960784313725;0.101960784313725 0.101960784313725 0.0980392156862745;0.145098039215686 0.145098039215686 0.141176470588235;1 0.988235294117647 0.615686274509804;1 0.992156862745098 0.619607843137255;0.925490196078431 0.913725490196078 0.6;0.423529411764706 0.419607843137255 0.298039215686275;1 0.976470588235294 0.611764705882353;0.996078431372549 0.972549019607843 0.607843137254902;1 0.980392156862745 0.615686274509804;1 0.984313725490196 0.619607843137255;1 0.976470588235294 0.619607843137255;0.988235294117647 0.972549019607843 0.615686274509804;1 0.980392156862745 0.627450980392157;0.988235294117647 0.972549019607843 0.619607843137255;0.984313725490196 0.964705882352941 0.615686274509804;0.219607843137255 0.215686274509804 0.145098039215686;0.4 0.392156862745098 0.270588235294118;0.258823529411765 0.254901960784314 0.192156862745098;0.145098039215686 0.141176470588235 0.0862745098039216;0.992156862745098 0.96078431372549 0.603921568627451;0.988235294117647 0.96078431372549 0.6;0.96078431372549 0.929411764705882 0.584313725490196;0.996078431372549 0.968627450980392 0.607843137254902;0.988235294117647 0.96078431372549 0.603921568627451;0.96078431372549 0.933333333333333 0.588235294117647;0.945098039215686 0.913725490196078 0.576470588235294;0.996078431372549 0.964705882352941 0.611764705882353;0.984313725490196 0.952941176470588 0.603921568627451;0.964705882352941 0.941176470588235 0.592156862745098;0.964705882352941 0.937254901960784 0.592156862745098;0.956862745098039 0.925490196078431 0.588235294117647;0.949019607843137 0.92156862745098 0.584313725490196;0.984313725490196 0.96078431372549 0.607843137254902;0.952941176470588 0.925490196078431 0.588235294117647;0.972549019607843 0.949019607843137 0.607843137254902;0.956862745098039 0.929411764705882 0.6;0.937254901960784 0.909803921568627 0.588235294117647;0.929411764705882 0.901960784313726 0.584313725490196;0.92156862745098 0.898039215686275 0.584313725490196;0.909803921568627 0.882352941176471 0.576470588235294;0.850980392156863 0.827450980392157 0.541176470588235;0.611764705882353 0.596078431372549 0.4;0.407843137254902 0.396078431372549 0.270588235294118;0.458823529411765 0.447058823529412 0.309803921568627;0.368627450980392 0.36078431372549 0.258823529411765;0.329411764705882 0.32156862745098 0.235294117647059;0.231372549019608 0.227450980392157 0.176470588235294;0.988235294117647 0.952941176470588 0.6;0.988235294117647 0.952941176470588 0.603921568627451;0.984313725490196 0.949019607843137 0.6;0.92156862745098 0.890196078431373 0.580392156862745;0.819607843137255 0.792156862745098 0.52156862745098;0.83921568627451 0.811764705882353 0.537254901960784;0.8 0.772549019607843 0.509803921568627;0.764705882352941 0.737254901960784 0.494117647058824;0.713725490196078 0.690196078431373 0.462745098039216;0.741176470588235 0.713725490196078 0.482352941176471;0.580392156862745 0.56078431372549 0.380392156862745;0.215686274509804 0.207843137254902 0.141176470588235;0.698039215686274 0.674509803921569 0.458823529411765;0.619607843137255 0.6 0.407843137254902;0.682352941176471 0.658823529411765 0.450980392156863;0.450980392156863 0.435294117647059 0.301960784313725;0.262745098039216 0.254901960784314 0.176470588235294;0.584313725490196 0.564705882352941 0.396078431372549;0.486274509803922 0.470588235294118 0.329411764705882;0.6 0.580392156862745 0.407843137254902;0.470588235294118 0.454901960784314 0.32156862745098;0.505882352941176 0.490196078431373 0.349019607843137;0.388235294117647 0.376470588235294 0.274509803921569;0.403921568627451 0.392156862745098 0.290196078431373;0.266666666666667 0.258823529411765 0.192156862745098;0.180392156862745 0.176470588235294 0.137254901960784;0.72156862745098 0.694117647058824 0.470588235294118;0.6 0.576470588235294 0.392156862745098;0.101960784313725 0.0980392156862745 0.0705882352941176;0.309803921568627 0.298039215686275 0.215686274509804;0.313725490196078 0.301960784313725 0.219607843137255;0.250980392156863 0.243137254901961 0.180392156862745;0.141176470588235 0.137254901960784 0.105882352941176;0.156862745098039 0.152941176470588 0.12156862745098;0.0862745098039216 0.0823529411764706 0.0588235294117647;0.494117647058824 0.474509803921569 0.349019607843137;0.286274509803922 0.274509803921569 0.203921568627451;0.219607843137255 0.211764705882353 0.164705882352941;0.243137254901961 0.235294117647059 0.184313725490196;0.0627450980392157 0.0588235294117647 0.0392156862745098;0.192156862745098 0.184313725490196 0.145098039215686;0.443137254901961 0.43921568627451 0.419607843137255;0.0784313725490196 0.0745098039215686 0.0588235294117647;0.164705882352941 0.156862745098039 0.125490196078431;0.117647058823529 0.113725490196078 0.0980392156862745;0.152941176470588 0.145098039215686 0.117647058823529;0.850980392156863 0.815686274509804 0.682352941176471;0.835294117647059 0.8 0.67843137254902;0.0470588235294118 0.0431372549019608 0.0313725490196078;0.0862745098039216 0.0823529411764706 0.0705882352941176;0.803921568627451 0.772549019607843 0.67843137254902;0.23921568627451 0.235294117647059 0.223529411764706;0.513725490196078 0.505882352941176 0.482352941176471;0.568627450980392 0.56078431372549 0.537254901960784;0.56078431372549 0.552941176470588 0.529411764705882;0.556862745098039 0.549019607843137 0.525490196078431;0.552941176470588 0.545098039215686 0.52156862745098;0.270588235294118 0.266666666666667 0.254901960784314;0.607843137254902 0.6 0.576470588235294;0.576470588235294 0.568627450980392 0.545098039215686;0.290196078431373 0.286274509803922 0.274509803921569;0.498039215686275 0.490196078431373 0.470588235294118;0.482352941176471 0.474509803921569 0.454901960784314;0.47843137254902 0.470588235294118 0.450980392156863;0.533333333333333 0.525490196078431 0.505882352941176;0.529411764705882 0.52156862745098 0.501960784313725;0.513725490196078 0.505882352941176 0.486274509803922;0.505882352941176 0.498039215686275 0.47843137254902;0.501960784313725 0.494117647058824 0.474509803921569;0.552941176470588 0.545098039215686 0.525490196078431;0.772549019607843 0.741176470588235 0.674509803921569;0.662745098039216 0.650980392156863 0.623529411764706;0.647058823529412 0.635294117647059 0.607843137254902;0.701960784313725 0.690196078431373 0.662745098039216;0.686274509803922 0.674509803921569 0.647058823529412;0.670588235294118 0.658823529411765 0.631372549019608;0.0352941176470588 0.0313725490196078 0.0235294117647059;0.129411764705882 0.12156862745098 0.105882352941176;0.6 0.588235294117647 0.564705882352941;0.588235294117647 0.576470588235294 0.552941176470588;0.580392156862745 0.568627450980392 0.545098039215686;0.63921568627451 0.627450980392157 0.603921568627451;0.627450980392157 0.615686274509804 0.592156862745098;0.623529411764706 0.611764705882353 0.588235294117647;0.619607843137255 0.607843137254902 0.584313725490196;0.611764705882353 0.6 0.576470588235294;0.423529411764706 0.415686274509804 0.4;0.686274509803922 0.674509803921569 0.650980392156863;0.682352941176471 0.670588235294118 0.647058823529412;0.67843137254902 0.666666666666667 0.643137254901961;0.674509803921569 0.662745098039216 0.63921568627451;0.666666666666667 0.654901960784314 0.631372549019608;0.662745098039216 0.650980392156863 0.627450980392157;0.654901960784314 0.643137254901961 0.619607843137255;0.650980392156863 0.63921568627451 0.615686274509804;0.454901960784314 0.447058823529412 0.431372549019608;0.450980392156863 0.443137254901961 0.427450980392157;0.43921568627451 0.431372549019608 0.415686274509804;0.435294117647059 0.427450980392157 0.411764705882353;0.227450980392157 0.223529411764706 0.215686274509804;0.466666666666667 0.458823529411765 0.443137254901961;0.247058823529412 0.243137254901961 0.235294117647059;0.243137254901961 0.23921568627451 0.231372549019608;0.23921568627451 0.235294117647059 0.227450980392157;0.235294117647059 0.231372549019608 0.223529411764706;0.258823529411765 0.254901960784314 0.247058823529412;0.294117647058824 0.290196078431373 0.282352941176471;0.32156862745098 0.317647058823529 0.309803921568627;0.745098039215686 0.717647058823529 0.670588235294118;0.529411764705882 0.517647058823529 0.498039215686275;0.52156862745098 0.509803921568627 0.490196078431373;0.572549019607843 0.56078431372549 0.541176470588235;0.564705882352941 0.552941176470588 0.533333333333333;0.545098039215686 0.533333333333333 0.513725490196078;0.592156862745098 0.580392156862745 0.56078431372549;0.694117647058824 0.67843137254902 0.654901960784314;0.352941176470588 0.345098039215686 0.333333333333333;0.345098039215686 0.337254901960784 0.325490196078431;0.368627450980392 0.36078431372549 0.349019607843137;0.407843137254902 0.4 0.388235294117647;0.4 0.392156862745098 0.380392156862745;0.388235294117647 0.380392156862745 0.368627450980392;0.490196078431373 0.47843137254902 0.462745098039216;0.474509803921569 0.462745098039216 0.447058823529412;0.733333333333333 0.705882352941177 0.670588235294118;0.0588235294117647 0.0549019607843137 0.0509803921568627;0.101960784313725 0.0980392156862745 0.0941176470588235;0.133333333333333 0.129411764705882 0.125490196078431;0.701960784313725 0.682352941176471 0.662745098039216;0.27843137254902 0.270588235294118 0.262745098039216;0.145098039215686 0.141176470588235 0.137254901960784;0.333333333333333 0.325490196078431 0.317647058823529;0.317647058823529 0.309803921568627 0.301960784313725;0.309803921568627 0.301960784313725 0.294117647058824;0.164705882352941 0.16078431372549 0.156862745098039;0.203921568627451 0.2 0.196078431372549;0.0196078431372549 0.0156862745098039 0.0156862745098039;0.0470588235294118 0.0431372549019608 0.0431372549019608;0.0549019607843137 0.0509803921568627 0.0509803921568627;0.0705882352941176 0.0666666666666667 0.0666666666666667;0.0745098039215686 0.0705882352941176 0.0705882352941176;0.0784313725490196 0.0745098039215686 0.0745098039215686;0.12156862745098 0.117647058823529 0.117647058823529;0.113725490196078 0.109803921568627 0.109803921568627;0.172549019607843 0.168627450980392 0.168627450980392;0.109803921568627 0.109803921568627 0.109803921568627;0.105882352941176 0.105882352941176 0.105882352941176;0.0941176470588235 0.0941176470588235 0.0941176470588235;0.0823529411764706 0.0823529411764706 0.0823529411764706;0.0627450980392157 0.0627450980392157 0.0627450980392157;0.0588235294117647 0.0588235294117647 0.0588235294117647;0.0509803921568627 0.0509803921568627 0.0509803921568627;0.0392156862745098 0.0392156862745098 0.0392156862745098;0.0313725490196078 0.0313725490196078 0.0313725490196078;0.0274509803921569 0.0274509803921569 0.0274509803921569;0.00784313725490196 0.00784313725490196 0.00784313725490196;0.752941176470588 0.752941176470588 0.752941176470588],...
'IntegerHandle','off',...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'KeyPressFcn','msg_export(''figure1_KeyPressFcn'',gcbo,[],guidata(gcbo))',...
'MenuBar','none',...
'Name','msg',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'PaperSize',[20.98404194812 29.67743169791],...
'PaperType',get(0,'defaultfigurePaperType'),...
'Position',[131.2 40.8461538461538 56 7.92307692307692],...
'Resize','off',...
'HandleVisibility','callback',...
'Tag','figure1',...
'UserData',[],...
'Visible','on',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'pushbutton2';

h2 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Callback','msg_export(''pushbutton2_Callback'',gcbo,[],guidata(gcbo))',...
'CData',[],...
'ListboxTop',0,...
'Position',[0.403571428571429 0.12621359223301 0.235714285714286 0.223300970873786],...
'String','OK',...
'Tag','pushbutton2',...
'UserData',[],...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text1';

h3 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'HorizontalAlignment','left',...
'ListboxTop',0,...
'Position',[0.246428571428571 0.577669902912621 0.714285714285714 0.145631067961165],...
'String',' ',...
'Style','text',...
'Tag','text1',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'axes1';

h4 = axes(...
'Parent',h1,...
'Position',[0.0321428571428571 0.407766990291262 0.178571428571429 0.485436893203883],...
'Box','on',...
'CameraPosition',[26 26 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'Layer','top',...
'LooseInset',[0.13 0.117236842105263 0.095 0.0799342105263158],...
'XColor',get(0,'defaultaxesXColor'),...
'XLim',[1 51],...
'XLimMode','manual',...
'YColor',get(0,'defaultaxesYColor'),...
'YDir','reverse',...
'YLim',[1 51],...
'YLimMode','manual',...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axes1',...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

h5 = get(h4,'title');

set(h5,...
'Parent',h4,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[25.5 -5.5 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'IncludeRenderer','on',...
'Clipping','off');

h6 = get(h4,'xlabel');

set(h6,...
'Parent',h4,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[25.5 74.5 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'IncludeRenderer','on',...
'Clipping','off');

h7 = get(h4,'ylabel');

set(h7,...
'Parent',h4,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-23.5 27.5 1.00005459937205],...
'Rotation',90,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'IncludeRenderer','on',...
'Clipping','off');

h8 = get(h4,'zlabel');

set(h8,...
'Parent',h4,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',2,...
'Position',[-8.5 -8.5 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'IncludeRenderer','on',...
'Clipping','off');

h9 = image(...
'Parent',h4,...
'CData',[255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 180 221 219 205 150 201 201 150 220 185 177 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 192 219 233 245 248 47 254 0 0 0 0 252 236 51 226 228 168 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 222 229 236 27 0 11 147 133 124 123 69 69 98 127 138 253 26 0 253 49 232 190 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 222 226 254 0 252 46 97 120 125 73 76 81 80 81 81 73 103 118 122 136 44 27 0 47 206 173 255 255 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 181 234 0 0 148 128 118 83 38 58 74 71 71 71 71 71 71 71 74 58 54 100 108 57 46 0 0 240 194 255 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 221 249 0 37 128 125 62 38 75 3 5 2 2 3 3 2 2 3 3 3 2 3 2 58 41 92 117 176 0 0 159 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 218 0 0 144 93 87 38 6 3 2 3 5 2 5 3 2 3 2 2 2 6 2 3 3 3 3 58 41 106 135 33 0 243 172 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 220 254 0 137 105 42 59 101 5 3 2 2 3 3 3 2 2 3 3 3 2 2 3 2 3 3 2 3 2 39 88 120 36 0 233 186 255 255 255 255 255 255 255 255;255 255 255 255 255 255 185 254 0 121 92 39 6 2 3 2 2 3 3 3 2 2 3 3 2 2 2 3 2 2 3 5 2 2 3 2 2 55 65 126 9 0 243 255 255 255 255 255 255 255 255;255 255 255 255 255 163 253 0 97 102 39 72 2 3 2 3 2 3 3 3 3 2 3 2 2 3 2 3 3 3 3 2 3 3 5 2 2 3 60 42 126 37 0 159 255 255 255 255 255 255 255;255 255 255 255 186 245 0 136 104 39 6 3 3 2 2 3 3 2 2 3 3 3 2 3 3 5 2 6 3 3 3 5 3 3 2 3 3 3 3 60 62 117 26 27 162 255 255 255 255 255 255;255 255 255 255 216 0 239 107 41 75 3 3 3 6 79 3 5 3 3 6 3 3 3 3 3 3 6 2 2 2 5 3 2 3 3 6 6 3 2 3 54 88 135 0 10 255 255 255 255 255 255;255 255 255 190 253 27 114 63 59 3 3 3 3 3 5 5 2 2 2 2 2 3 3 207 207 207 207 2 2 3 2 2 2 3 5 3 2 2 3 3 6 39 107 49 0 217 255 255 255 255 255;255 255 255 217 0 142 105 38 2 2 3 2 3 3 3 3 3 3 2 2 3 145 17 4 4 4 4 17 145 2 5 3 3 2 2 2 2 3 2 2 5 71 64 68 26 248 255 255 255 255 255;255 255 255 51 26 119 40 6 2 2 3 2 3 3 2 3 3 5 3 2 2 19 4 28 30 30 28 4 19 3 2 3 2 100 2 3 3 3 2 2 3 3 55 108 148 27 196 255 255 255 255;255 255 152 0 238 111 39 3 2 3 3 2 2 2 3 99 5 2 2 3 30 28 4 24 2 3 24 4 28 25 100 2 100 5 100 2 2 2 3 3 3 2 71 66 115 0 50 255 255 255 255;255 255 217 0 67 56 74 2 3 2 3 3 3 3 3 6 100 3 2 3 4 4 20 149 3 2 149 20 4 22 5 3 3 2 5 3 3 2 3 3 2 3 3 39 119 254 249 214 255 255 255;255 255 198 27 94 42 101 5 3 3 2 3 2 2 2 3 3 6 2 3 21 21 13 2 2 3 3 15 4 23 3 2 2 3 2 2 6 3 2 2 3 5 3 58 111 224 253 168 255 255 255;255 255 52 34 120 39 3 6 2 3 2 2 2 3 2 3 6 2 6 3 3 2 2 3 2 3 223 18 4 32 2 2 3 3 2 3 3 3 2 5 2 3 2 74 104 127 235 185 255 255 255;255 255 12 12 116 38 3 3 5 3 3 3 3 3 2 2 3 3 3 3 2 3 2 2 3 146 23 4 29 19 2 2 2 2 3 3 3 2 3 2 2 99 6 2 75 70 254 216 255 255 255;255 255 252 251 118 38 5 2 3 3 2 2 2 3 2 3 2 2 3 2 3 2 3 2 3 30 4 4 21 3 3 2 3 2 2 3 2 2 2 2 3 2 3 3 55 70 254 230 255 255 255;255 255 12 12 116 38 3 3 3 2 3 2 2 3 2 3 2 2 3 2 3 3 2 169 23 4 4 16 101 2 6 2 2 3 3 3 2 3 2 2 2 3 2 6 84 70 254 206 172 255 255;255 255 225 33 120 39 2 3 3 3 2 3 2 2 5 3 3 3 2 2 2 3 5 227 4 4 16 3 3 2 2 3 2 3 2 3 3 3 2 2 5 3 5 74 104 127 235 217 187 255 255;255 255 234 27 68 43 101 3 2 3 3 2 3 2 2 3 3 2 3 3 2 2 3 227 4 4 169 2 3 2 3 2 100 100 2 2 3 5 2 2 2 5 3 58 113 224 253 195 188 255 255;255 255 230 0 110 56 59 5 5 3 3 2 2 5 3 2 5 3 3 5 2 3 3 149 19 19 149 3 3 3 2 2 2 2 3 99 2 3 5 3 99 79 2 39 119 254 237 209 187 255 255;255 255 208 0 9 113 39 3 2 2 2 2 3 2 3 3 3 2 2 3 3 5 3 5 207 207 5 2 3 2 2 3 3 2 2 2 3 2 3 2 3 3 71 86 130 0 53 153 172 255 255;255 255 186 240 26 95 40 6 3 3 2 2 2 5 2 3 5 6 3 2 3 3 2 207 31 31 207 3 3 2 3 2 3 5 3 3 6 3 3 2 2 3 38 125 141 0 232 158 255 255 255;255 255 255 205 0 132 105 38 3 2 2 2 2 3 3 2 3 5 3 2 3 2 2 7 4 4 7 2 3 3 3 2 3 3 2 2 3 3 2 2 3 71 62 121 27 236 199 177 255 255 255;255 255 255 152 253 27 117 40 74 3 3 3 3 3 3 5 2 2 3 3 2 2 3 2 207 207 3 5 3 2 3 3 3 2 3 3 3 2 3 3 3 39 111 49 0 200 208 180 255 255 255;255 255 255 255 204 0 239 107 41 75 2 2 3 3 2 2 3 3 3 2 6 3 5 3 2 3 2 3 3 3 2 3 3 3 3 5 2 3 3 3 54 90 123 0 250 140 155 173 255 255 255;255 255 255 255 155 247 0 139 103 39 72 2 2 2 99 2 3 3 5 2 3 3 2 3 2 3 2 2 2 2 2 3 3 3 2 3 2 2 3 60 63 95 0 254 232 165 177 255 255 255 255;255 255 255 255 255 220 14 0 129 91 39 72 2 3 3 3 2 2 2 3 2 3 3 3 3 2 2 2 2 3 2 2 3 5 5 6 5 2 60 42 109 14 0 50 222 212 191 255 255 255 255;255 255 255 255 255 171 159 254 0 96 92 39 6 5 2 2 2 3 2 2 6 5 5 3 3 3 3 2 3 6 2 2 5 5 2 3 6 55 66 109 8 0 242 197 165 177 255 255 255 255 255;255 255 255 255 255 255 178 204 254 0 98 106 42 59 101 3 3 2 2 5 2 2 3 2 2 2 2 2 2 2 3 2 3 2 6 2 39 89 117 35 0 245 185 166 211 187 255 255 255 255 255;255 255 255 255 255 255 214 211 204 0 0 131 116 87 39 6 3 5 3 3 3 3 3 2 2 2 5 3 3 5 5 5 100 100 3 38 108 123 33 0 242 185 167 212 171 255 255 255 255 255 255;255 255 255 255 255 255 255 174 154 206 236 0 14 69 113 78 38 71 6 6 2 3 2 3 3 3 3 2 3 5 5 75 2 3 58 111 176 0 0 234 196 167 163 182 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 190 153 220 226 0 0 141 135 116 89 54 74 74 74 74 71 74 71 71 74 74 74 74 74 74 71 59 103 141 0 53 162 167 163 183 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 190 152 161 205 49 254 0 253 131 45 134 111 77 83 82 82 73 85 77 105 116 96 136 120 89 61 38 121 27 247 161 212 182 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 173 213 164 199 159 246 252 27 0 34 175 44 46 130 137 137 136 133 147 235 27 0 254 135 105 41 108 251 235 216 180 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 181 154 209 167 219 200 244 48 236 253 254 0 0 0 0 253 252 248 52 52 27 0 51 112 85 137 0 50 255 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 187 157 155 209 166 167 194 217 206 156 202 202 202 202 231 216 197 160 221 204 8 0 26 96 121 254 248 178 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 187 183 158 212 209 151 166 167 167 160 160 160 160 167 166 151 165 151 217 241 0 0 143 254 254 215 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 190 181 177 179 153 155 212 163 163 212 154 210 213 184 177 155 222 202 251 0 27 27 53 255 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 214 189 190 191 191 174 173 255 255 255 255 174 178 208 215 242 27 27 36 194 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 183 155 195 198 27 27 203 255 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 170 179 165 230 8 249 213 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 172 183 212 196 50 220 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 193 152 151 212 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 173 157 182 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 187 255 255 255 255 255 255 255 255;255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255],...
'XData',[1 51],...
'YData',[1 51]);


hsingleton = h1;


% --- Set application data first then calling the CreateFcn. 
function local_CreateFcn(hObject, eventdata, createfcn, appdata)

if ~isempty(appdata)
   names = fieldnames(appdata);
   for i=1:length(names)
       name = char(names(i));
       setappdata(hObject, name, getfield(appdata,name));
   end
end

if ~isempty(createfcn)
   eval(createfcn);
end


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)


%   GUI_MAINFCN provides these command line APIs for dealing with GUIs
%
%      MSG_EXPORT, by itself, creates a new MSG_EXPORT or raises the existing
%      singleton*.
%
%      H = MSG_EXPORT returns the handle to a new MSG_EXPORT or the handle to
%      the existing singleton*.
%
%      MSG_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MSG_EXPORT.M with the given input arguments.
%
%      MSG_EXPORT('Property','Value',...) creates a new MSG_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before untitled_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to untitled_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".

%   Copyright 1984-2006 The MathWorks, Inc.
%   $Revision: 1.1.6.2 $ $Date: 2006/06/27 23:04:21 $

gui_StateFields =  {'gui_Name'
    'gui_Singleton'
    'gui_OpeningFcn'
    'gui_OutputFcn'
    'gui_LayoutFcn'
    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('MATLAB:gui_mainfcn:FieldNotFound', 'Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [gui_State.(gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % MSG_EXPORT
    % create the GUI
    gui_Create = 1;
elseif local_isInvokeActiveXCallback(gui_State, varargin{:})
    % MSG_EXPORT(ACTIVEX,...)
    vin{1} = gui_State.gui_Name;
    vin{2} = [get(varargin{1}.Peer, 'Tag'), '_', varargin{end}];
    vin{3} = varargin{1};
    vin{4} = varargin{end-1};
    vin{5} = guidata(varargin{1}.Peer);
    feval(vin{:});
    return;
elseif local_isInvokeHGCallbak(gui_State, varargin{:})
    % MSG_EXPORT('CALLBACK',hObject,eventData,handles,...)
    gui_Create = 0;
else
    % MSG_EXPORT(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = 1;
end

if gui_Create == 0
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else
        feval(varargin{:});
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end

    % Check user passing 'visible' P/V pair first so that its value can be
    % used by oepnfig to prevent flickering
    gui_Visible = 'auto';
    gui_VisibleInput = '';
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end

        % Recognize 'visible' P/V pair
        len1 = min(length('visible'),length(varargin{index}));
        len2 = min(length('off'),length(varargin{index+1}));
        if ischar(varargin{index+1}) && strncmpi(varargin{index},'visible',len1) && len2 > 1
            if strncmpi(varargin{index+1},'off',len2)
                gui_Visible = 'invisible';
                gui_VisibleInput = 'off';
            elseif strncmpi(varargin{index+1},'on',len2)
                gui_Visible = 'visible';
                gui_VisibleInput = 'on';
            end
        end
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.

    % Do feval on layout code in m-file if it exists
    gui_Exported = ~isempty(gui_State.gui_LayoutFcn);
    if gui_Exported
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);
        % openfig (called by local_openfig below) does this for guis without
        % the LayoutFcn. Be sure to do it here so guis show up on screen.
        movegui(gui_hFigure,'onscreen')
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt, gui_Visible);
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt, gui_Visible);
        end
    end

    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    % Singleton setting in the GUI M-file takes priority if different
    gui_Options.singleton = gui_State.gui_Singleton;

    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA. If there is
        % user set GUI data already, keep that also.
        data = guidata(gui_hFigure);
        handles = guihandles(gui_hFigure);
        if ~isempty(handles)
            if isempty(data)
                data = handles;
            else
                names = fieldnames(handles);
                for k=1:length(names)
                    data.(char(names(k)))=handles.(char(names(k)));
                end
            end
        end
        guidata(gui_hFigure, data);
    end

    % Apply input P/V pairs other than 'visible'
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end

        len1 = min(length('visible'),length(varargin{index}));
        if ~strncmpi(varargin{index},'visible',len1)
            try set(gui_hFigure, varargin{index}, varargin{index+1}), catch break, end
        end
    end

    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end

    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});

    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);

        % Call openfig again to pick up the saved visibility or apply the
        % one passed in from the P/V pairs
        if ~gui_Exported
            gui_hFigure = local_openfig(gui_State.gui_Name, 'reuse',gui_Visible);
        elseif ~isempty(gui_VisibleInput)
            set(gui_hFigure,'Visible',gui_VisibleInput);
        end
        if strcmpi(get(gui_hFigure, 'Visible'), 'on')
            figure(gui_hFigure);
            
            if gui_Options.singleton
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        rmappdata(gui_hFigure,'InGUIInitialization');
    end

    % If handle visibility is set to 'callback', turn it on until finished with
    % OutputFcn
    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end

    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end

    if isscalar(gui_hFigure) && ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end

function gui_hFigure = local_openfig(name, singleton, visible)

% this application data is used to indicate the running mode of a GUIDE
% GUI to distinguish it from the design mode of the GUI in GUIDE.
setappdata(0,'OpenGuiWhenRunning',1);

% openfig with three arguments was new from R13. Try to call that first, if
% failed, try the old openfig.
try
    gui_hFigure = openfig(name, singleton, visible);
catch
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
end
rmappdata(0,'OpenGuiWhenRunning');

function result = local_isInvokeActiveXCallback(gui_State, varargin)

try
    result = ispc && iscom(varargin{1}) ...
             && isequal(varargin{1},gcbo);
catch
    result = false;
end

function result = local_isInvokeHGCallbak(gui_State, varargin)

try
    fhandle = functions(gui_State.gui_Callback);
    result = ~isempty(findstr(gui_State.gui_Name,fhandle.file)) ...
             && ischar(varargin{1}) ...
             && isequal(ishandle(varargin{2}), 1);
catch
    result = false;
end

