#pragma once

#include "ui_amplio.h"

class QProgressBar;

class asrParams
{
public:
    // ASR params
    int contrast;
    int edge;
    int lpcutoff;
    int smooth;
    int weight;
};

class amplioParams
{
public:
    // IQ demodulation params
    int startFreq;
    int stopFreq;
    int cutoffFreq;
    // Compression table params
    int reject;
    int dynamicRg;
    int decimation;
    // scan conversion params
};

class probeParams
{
public:
    int elements;
    int pitch;
    int radius;
    int txoffset;
    int maxsteer;
};

class scParams
{
public:
    int originx;
    int originy;
    int scale;
    int width;
    int height;
};

class AmplioDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    AmplioDemo(QWidget* parent = 0);
    virtual ~AmplioDemo();

private:
    bool rfToB(const char* in, const char* out);
    bool filterB(const char* in, const char* out);
    bool scanConvertB(const char* in, const char* out);
    void allocateBuffers(int szRF, int szB, int szB8);
    void resetBuffers(int szRF, int szB, int szB8);

private:
    int m_cineSize;
    int m_numLines;
    int m_numRFSamples;
    int m_numBSamples;
    int m_numFrames;
    bool m_isInitialized;

    // file adresses
    char m_inRFPath[256];
    char m_outBprPath[256];
    char m_outBprFiltPath[256];
    char m_outBpostPath[256];
    amplioParams m_amplio;
    asrParams m_asr;
    probeParams m_probe;
    scParams m_sc;

    QProgressBar* wProgress;
    short* m_rf;
    unsigned char* m_b;
    unsigned char* m_bflt;
    unsigned char* m_bsc;

private slots:
    void cineScroll(int);
    void onAmp(int);
    void onSelectFile();
    void runImage();
    void onApplyParams();
};
