#pragma once

#include "qgraphicsview.h"

class ViewBImg : public QGraphicsView
{
public:
    ViewBImg(QWidget* parent = 0);
    virtual ~ViewBImg();

    bool init(int channels, int samples, bool scanConverted = false);
    void setAmp(int amp);
    virtual bool setImgData(char* buffer);

protected:
    virtual void drawBackground(QPainter*, const QRectF&);
    virtual void resizeEvent(QResizeEvent*);

protected:
    void setupBuffer(int w, int h);
    void convertRF2Img(char* buffer, unsigned char* bufferImg);
    void getOptDims(int& w, int& h);

protected:

    int m_scanLines;
    int m_samples;
    int m_amp;
    char* m_buffer;
    unsigned char* m_bufferImg;
    QImage* m_image;
    int* m_map;
    bool m_scanConverted;
};
