#include "stdafx.h"
#include "ChannelsDlg.h"

// initialize the channel data
ChannelsDlg::ChannelsDlg(unsigned int* channels)
{
    int i;
    for (i = 0; i < 4; i++)
    {
        m_channels[i] = channels[i];
    }
}

// user checked on a "board" or "all channels"
void ChannelsDlg::onCheckBoard(bool checked)
{
    QWidget* w = focusWidget();
    int i, j, start, end, board = w ? w->property("board").toInt() : 0;

    start = board > 3 ? 0 : board;
    end = board > 3 ? 4 : board + 1;

    for (j = start; j < end; j++)
    {
        for (i = 0; i < 32; i++)
        {
            m_channel[(j * 32) + i]->setChecked(checked);
        }
    }
}

// save the check boxes to the channel bitmask
void ChannelsDlg::accept()
{
    int i, index;
    m_channels[0] = m_channels[1] = m_channels[2] = m_channels[3] = 0;

    for (i = 0; i < 128; i++)
    {
        index = i / 32;
        m_channels[index] = m_channel[i]->isChecked() ? m_channels[index] | 1 << (i % 32) : m_channels[index];
    }

    QDialog::accept();
}

void ChannelsDlg::getChannels(unsigned int* channels)
{
    int i;
    for (i = 0; i < 4; i++)
    {
        channels[i] = m_channels[i];
    }
}

// setup the dialog manually
int ChannelsDlg::exec()
{
    QVBoxLayout* vl = new QVBoxLayout;
    QDialogButtonBox* bb;
    QCheckBox* cb;
    QGroupBox* board;
    QGridLayout* gl;
    int i, index, row, ch;

    for (i = 0; i < 4; i++)
    {
        board = new QGroupBox;
        board->setTitle(QString(tr("Board %1")).arg(i + 1));
        gl = new QGridLayout;

        for (row = 0; row < 4; row++)
        {
            for (ch = 0; ch < 8; ch++)
            {
                index = (i * 32) + (row * 8) + ch;
                m_channel[index] = new QCheckBox;
                m_channel[index]->setText(QString("Ch: %1").arg(index));
                m_channel[index]->setChecked((m_channels[i] & (1 << ((row * 8) + ch))) != 0);
                gl->addWidget(m_channel[index], row, ch);
            }
        }

        board->setLayout(gl);

        cb = new QCheckBox;
        cb->setText(QString(tr("Entire Board %1")).arg(i + 1));
        cb->setProperty("board", i);
        cb->setChecked(true);
        connect(cb, SIGNAL(toggled(bool)), this, SLOT(onCheckBoard(bool)));
        vl->addWidget(cb);
        vl->addWidget(board);
    }

    cb = new QCheckBox;
    cb->setText(QString(tr("All Channels")));
    cb->setProperty("board", 10);
    cb->setChecked(true);
    connect(cb, SIGNAL(toggled(bool)), this, SLOT(onCheckBoard(bool)));
    vl->addWidget(cb);

    // make sure user can use OK & Cancel
    bb = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    connect(bb, SIGNAL(accepted()), this, SLOT(accept()));
    connect(bb, SIGNAL(rejected()), this, SLOT(reject()));
    vl->addWidget(bb);

    setLayout(vl);
    resize(400, 400);
    setWindowTitle(tr("Channel Selection"));

    return QDialog::exec();
}
