#pragma once

#include <daq_def.h>
#include "ui_daq.h"
#include "QThread.h"

class QProgressBar;
class QBasicTimer;
class QTimerEvent;
class QElapsedTimer;

// initialization thread
class DaqInit : public QThread
{
    Q_OBJECT

public:
    DaqInit(QObject* parent = 0);

protected:
    virtual void run();
};

// download thread
class DaqDownload : public QThread
{
    Q_OBJECT

public:
    DaqDownload(QObject* parent = 0);

protected:
    virtual void run();
};

class DaqDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    DaqDemo(QWidget* parent = 0);
    virtual ~DaqDemo();

    void startDownload();
    void startInit();

private:
    void setupControls();
    void loadData(int frame, bool init = false);
    static void daqCallback(void*, int, ECallbackSources);

private:
    QString m_firmwarePath;
    QString m_downloadFolder;
    QString m_examFile;
    QString m_datapath;

    QProgressBar* wProgress;
    QElapsedTimer* m_timer;

    int m_channels;
    unsigned int m_channelMap[4];

    DaqDownload* m_download;
    DaqInit* m_init;
    std::vector< std::string > m_devices;
    bool m_initStatus;

signals:
    void sgProgress(int, int);

private slots:
    void onInit();
    void onRun();
    void onStop();
    void onFirmwarePath();
    void onExamFile();
    void onDownloadFolder();
    void onChannelMap();
    void onTgcCurve();
    void onCine(int);
    void onAmp(int);
    void onChannelDisplay(int);
    void onDownload();
    void onProgress(int, int);
    void onDownloadFinished();
    void onInitFinished();
    void onLoadData();
    void onAdvanced();
};
