#pragma once

#include "QGraphicsView.h"

class DaqView : public QGraphicsView
{
public:
    DaqView(QWidget* parent = 0);
    virtual ~DaqView();

    bool init(int channels, int samples);
    void setAmp(int amp);
    void setChannelDisplay(int chd);
    void adjustScale();
    void loadChannel(int channel, short* data);

protected:
    virtual void drawForeground(QPainter* painter, const QRectF& r);
    virtual void resizeEvent(QResizeEvent*);

protected:

    int m_channels;
    int m_samples;
    int m_amp;
    int m_display;
    double m_scale;
    short* m_buffer;
};
