#include "stdafx.h"
#include "TgcView.h"

TgcView::TgcView(QWidget* parent) : QGraphicsView(parent)
{
    QGraphicsScene* sc = new QGraphicsScene(this);
    setScene(sc);
    setMouseTracking(true);

    m_highlight = -1;
}

TgcView::~TgcView()
{
}

void TgcView::resizeEvent(QResizeEvent* e)
{
    setSceneRect(0, 0, e->size().width(), e->size().height());

    QGraphicsView::resizeEvent(e);
}

void TgcView::mouseMoveEvent(QMouseEvent* e)
{
    QGraphicsView::mouseMoveEvent(e);

    int i, x = e->x(), y = e->y(), radius = 3, minx, maxx, miny, maxy;

    if (e->buttons() & Qt::LeftButton)
    {
        if (m_highlight >= 0 && m_highlight < TGC_POINTS)
        {
            minx = (m_highlight > 0) ? (int)(daqTgcGetX(m_highlight - 1) * width()) : 0;
            maxx = (m_highlight < 2) ? (int)(daqTgcGetX(m_highlight + 1) * width()) : width();
            maxy = (m_highlight > 0) ? (int)(height() - (daqTgcGetY(m_highlight - 1) * height())) : height();
            miny = (m_highlight < 2) ? (int)(height() - (daqTgcGetY(m_highlight + 1) * height())) : 0;
            x = (x < minx) ? minx : ((x > maxx) ? maxx : x);
            y = (y < miny) ? miny : ((y > maxy) ? maxy : y);
            daqTgcSetX(m_highlight, x / static_cast< float >(width()));
            daqTgcSetY(m_highlight, (height() - y) / static_cast< float >(height()));
        }
    }
    else
    {
        m_highlight = -1;
        for (i = 0; i < TGC_POINTS; ++i)
        {
            QPoint p((int)(daqTgcGetX(i) * width()), (int)(height() - daqTgcGetY(i) * height()));

            if (x >= p.x() - radius && x <= p.x() + radius)
            {
                if (y >= p.y() - radius && y <= p.y() + radius)
                {
                    m_highlight = i;
                }
            }
        }
    }

    scene()->invalidate();
}

void TgcView::drawForeground(QPainter* painter, const QRectF& r)
{
    QGraphicsView::drawForeground(painter, r);

    int i, radius = 3;
    QPoint pt[TGC_POINTS];

    painter->setPen(Qt::black);
    painter->setBrush(Qt::NoBrush);

    QPainterPath pp(QPoint(0, height()));

    for (i = 0; i < TGC_POINTS; ++i)
    {
        pt[i] = QPoint((int)(daqTgcGetX(i) * width()), (int)(height() - daqTgcGetY(i) * height()));
        pp.lineTo(pt[i]);
    }

    pp.lineTo(QPoint(width(), 0));
    painter->drawPath(pp);

    for (i = 0; i < TGC_POINTS; i++)
    {
        painter->setBrush(i == m_highlight ? Qt::SolidPattern : Qt::NoBrush);
        painter->drawEllipse(pt[i], radius, radius);
    }
}
