#pragma once

#include "ui_fluctus.h"

class FluctusDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    FluctusDemo(QWidget* parent = 0);
    virtual ~FluctusDemo();
    static int onData(void*, int, int);

protected:
    virtual void resizeEvent(QResizeEvent*);

private:
    void setupControls();
    void changeSamplingRate(bool);
    void changeLead(bool);
    void changeGain(bool);
    void changeFilter(bool);
    void updateParams();

private:
    std::vector< int > m_buffer;

signals:
    void showMessage(QString);

private slots:
    void init();
    void run();
    void stop();
    void inc();
    void dec();
    void onAmp(int);
    void onBaseline(int);
    void onScroll(int);
    void onShowMessage(QString);
    void onParamCheck(int, int);
};
