#include "stdafx.h"
#include "FluctusView.h"

#define bound(y, h) (y < 0 ? ((-y > h) ? -h : y) : ((y > h) ? h : y))

FluctusView::FluctusView(QWidget* parent) : QGraphicsView(parent)
{
    QGraphicsScene* sc = new QGraphicsScene(this);
    setScene(sc);

    m_amp = 0;
    m_baseline = 0;
    m_invert = false;
    m_hr = 0;
    m_scroll = 0;
    m_scrollEnabled = false;
    m_showPeaks = true;
}

FluctusView::~FluctusView()
{
}

void FluctusView::add(int sample)
{
    m_buffer.push_back(sample);
    m_peaks.push_back(0);
    scene()->invalidate();
}

void FluctusView::markPeak()
{
    if (m_peaks.size())
    {
        m_peaks.pop_back();
    }

    m_peaks.push_back(1);
}

void FluctusView::clear()
{
    m_buffer.clear();
    m_peaks.clear();
    scene()->invalidate();
}

void FluctusView::setBaseline(int bl)
{
    m_baseline = bl;
    scene()->invalidate();
}

void FluctusView::setInvert(bool invert)
{
    m_invert = invert;
    scene()->invalidate();
}

void FluctusView::setAmp(int amp)
{
    m_amp = amp;
    scene()->invalidate();
}

void FluctusView::setScroll(int scroll, bool enabled)
{
    m_scroll = scroll;
    m_scrollEnabled = enabled;
    scene()->invalidate();
}

void FluctusView::setPulseRate(int hr)
{
    m_hr = hr;
    scene()->invalidate();
}

void FluctusView::setShowPeaks(bool show)
{
    m_showPeaks = show;
    scene()->invalidate();
}

int FluctusView::getScrollSize()
{
    return ((signed)m_buffer.size() < width()) ? 0 : m_buffer.size() - width();
}

void FluctusView::resizeEvent(QResizeEvent* e)
{
    setSceneRect(0, 0, e->size().width(), e->size().height());

    QGraphicsView::resizeEvent(e);
}

void FluctusView::drawForeground(QPainter* painter, const QRectF& r)
{
    QGraphicsView::drawForeground(painter, r);

    int i, w = width(), h = height(), x = 0, start = (signed)m_buffer.size() < w ? 0 : m_buffer.size() - w,
        baseline = h - m_baseline, inv = m_invert ? -1 : 1;
    double amp = ((double)m_amp / 100.0);

    if (m_buffer.size())
    {
        if (m_scrollEnabled)
        {
            start -= (getScrollSize() - m_scroll);
        }

        painter->setFont(QFont("Arial", 12));

        // draw the waveform
        QPainterPath pp(QPoint(x, static_cast< int >(baseline - ((m_buffer[start] * amp) * inv))));
        for (i = start + 1; i < (signed)m_buffer.size(); i++)
        {
            pp.lineTo(++x, baseline - ((m_buffer[i] * amp) * inv));
        }
        painter->drawPath(pp);

        painter->drawText(1, h - 4, QString("%1 BPM").arg(m_hr));

        // draw peaks
        if (m_showPeaks)
        {
            QPainterPath ppp;
            painter->setPen(QPen(Qt::darkGreen, 1, Qt::DotLine));

            x = 0;
            for (i = start; i < (signed)m_peaks.size(); i++)
            {
                if (m_peaks[i] == 1)
                {
                    ppp.moveTo(x, 0);
                    ppp.lineTo(x, h);
                }
                x++;
            }
            painter->drawPath(ppp);
        }
    }
}
