#pragma once

#include "QGraphicsView.h"

class FluctusView : public QGraphicsView
{
public:
    FluctusView(QWidget* parent = 0);
    virtual ~FluctusView();

    void setAmp(int);
    void setBaseline(int);
    void setInvert(bool);
    void setScroll(int, bool);
    void setPulseRate(int);
    void setShowPeaks(bool);

    void add(int);
    void markPeak();
    void clear();

    int getScrollSize();

protected:
    virtual void drawForeground(QPainter* painter, const QRectF& r);
    virtual void resizeEvent(QResizeEvent*);

protected:

    int m_amp;
    int m_baseline;
    bool m_invert;
    int m_hr;
    int m_scroll;
    bool m_scrollEnabled;
    bool m_showPeaks;

    std::vector< int > m_buffer;
    std::vector< int > m_peaks;
};
