#pragma once

#ifdef EXPORT_FLUCTUS
    #define fluctusL __declspec(dllexport)
#elif defined IMPORT_FLUCTUS
    #define fluctusL __declspec(dllimport)
#else
    #define fluctusL
#endif

#include "fluctus_def.h"

#ifdef __cplusplus
extern "C" {
#endif

// startup  and shutdown
fluctusL int fluctusInit(ecgVersion version, int port = 1);
fluctusL void fluctusShutdown();
fluctusL ecgVersion fluctusGetVersion();
fluctusL int fluctusIsInitialized();

// acquisition functions
fluctusL int fluctusStart();
fluctusL int fluctusStop();
fluctusL int fluctusIsRunning();
fluctusL int fluctusMeasureContact(int on);

// parameter set functions
fluctusL int fluctusSetLead(ecgLead lead);
fluctusL int fluctusSetGain(ecgGainLevel gain);
fluctusL int fluctusSetSamplingRate(ecgSamplingRate rate);
fluctusL int fluctusSetFilter(ecgFilterType filter);

// parameter get functions
fluctusL ecgGainLevel fluctusGetGainInfo();
fluctusL ecgFilterType fluctusGetFilterInfo();
fluctusL ecgSamplingRate fluctusGetSamplingRateInfo();
fluctusL ecgLead fluctusGetLeadInfo();

// miscellaneous functions
fluctusL double fluctusGetSamplingRate();
fluctusL int fluctusGetMaxValue();
fluctusL int fluctusReadRawData(unsigned char* buffer, int sz);
fluctusL void fluctusSetCallback(ECG_CALLBACK fn, void* prm);

#ifdef __cplusplus
}
#endif
