#include "StdAfx.h"

void onConsole(imperoEventType type, void* data, int sz, int info, void* prm);
imperoType m_consoleType;

// program entry point
int main() // (int argc, char * argv[])
{
    int ch, ledAll = imperoLEDOff, ledFreeze = imperoLEDOff, led1 = imperoLEDOff, led2 = imperoLEDOff, ledQ = imperoLEDOff, ledU =
        imperoLEDOff;
    bool bl = false;
    unsigned char tgc[8];
    m_consoleType = imperoSonixTouch;

    imperoInit(m_consoleType);
    imperoSetFirmwarePath(FIRMWARE_PATH);

    // try and connect
    if (imperoConnect())
    {
        imperoSetBacklight(bl);
        imperoSetAllLEDs((imperoLED)ledAll);

        imperoSetCallback(onConsole, 0);

        printf("impero demo:\n");
        printf("gathering console data...\n\n");
        printf("Keypad Options:\n");

        printf("'B' on the keypad to toggle on/off the LCD backlight\n");
        printf("'L' on the keypad to change button LED colors\n\n");

        printf("'F' on the keypad to change Freeze LED\n");
        printf("'1' on the keypad to change 1 LED\n");
        printf("'2' on the keypad to change 2 LED\n");
        printf("'Q' on the keypad to change Q LED\n");
        printf("'U' on the keypad to change Update LED\n\n");
        
        printf("'X' on the keypad to exit\n\n");

        if (m_consoleType != imperoSonixTouch)
        {
            imperoGetTgc((char*)tgc);
            printf("tgc: {%d,%d,%d,%d,%d,%d,%d,%d}\n", tgc[0], tgc[1], tgc[2], tgc[3], tgc[4], tgc[5], tgc[6], tgc[7]);
        }
    }
    else
    {
        printf("could not connect to console\ncheck the connection, or try another serial port\n");
        imperoShutdown();
        return -1;
    }

    // get user input
    do
    {
        ch = _getch();
        ch = toupper(ch);

        switch (ch)
        {
        case 'B':
            imperoSetBacklight(!bl);
            bl = !bl;
            break;
        case 'L':
            if (++ledAll > imperoLEDAll)
            {
                ledAll = imperoLEDOff;
            }
            imperoSetAllLEDs((imperoLED)ledAll);
            break;
        case 'F':
            if (++ledFreeze > imperoLEDAll)
            {
                ledFreeze = imperoLEDOff;
            }
            (m_consoleType == imperoSonixArrakis) ? imperoSetLEDArrakis("Freeze", (imperoLED)ledFreeze) : imperoSetLEDTouch(8, (imperoLED)ledFreeze);
            break;
        case '1':
            if (++led1 > imperoLEDAll)
            {
                led1 = imperoLEDOff;
            }
            (m_consoleType == imperoSonixArrakis) ? imperoSetLEDArrakis("Print Capture 1", (imperoLED)led1) : imperoSetLEDTouch(10, (imperoLED)led1);
            break;
        case '2':
            if (++led2 > imperoLEDAll)
            {
                led2 = imperoLEDOff;
            }
            (m_consoleType == imperoSonixArrakis) ? imperoSetLEDArrakis("Print Capture 2", (imperoLED)led2) : imperoSetLEDTouch(4, (imperoLED)led2);
            break;
        case 'Q':
            if (++ledQ > imperoLEDAll)
            {
                ledQ = imperoLEDOff;
            }
            (m_consoleType == imperoSonixArrakis) ? imperoSetLEDArrakis("QSonix", (imperoLED)ledQ) : imperoSetLEDTouch(6, (imperoLED)ledQ);
            break;
        case 'U':
            if (++ledU > imperoLEDAll)
            {
                ledU = imperoLEDOff;
            }
            (m_consoleType == imperoSonixArrakis) ? imperoSetLEDArrakis("Update", (imperoLED)ledU) : imperoSetLEDTouch(0, (imperoLED)ledU);
            break;
        }
    } while (ch != 'X');

    if (ch == 'X')
    {
        imperoShutdown();
    }

    return 0;
}

// handles console events
void onConsole(imperoEventType type, void* data, int sz, int info, void* /*prm*/)
{
    unsigned char* tgc;
    unsigned int* btn;

    if (type == imperoEventTGC && sz == 8 && m_consoleType != imperoSonixTouch)
    {
        tgc = (unsigned char*)data;
        printf("tgc: {%d,%d,%d,%d,%d,%d,%d,%d}\n", tgc[0], tgc[1], tgc[2], tgc[3], tgc[4], tgc[5], tgc[6], tgc[7]);
    }
    else if (type == imperoEventDial && sz == 4)
    {
        btn = (unsigned int*)data;
        printf("dial #%d turned %d clicks\n", *btn, info);
    }
    else if (type == imperoEventPush && sz == 4)
    {
        btn = (unsigned int*)data;
        if (info)
        {
            printf("button #%d was pressed\n", *btn);
        }
        else
        {
            printf("button #%d was depressed\n", *btn);
        }
    }
    else if (type == imperoTouchEvent)
    {
        btn = (unsigned int*)data;
        if (info & 0x01)
        {
            printf("touch at x: %d, y: %d. pressed\n", btn[0], btn[1]);
        }
        else
        {
            printf("touch depressed\n");
        }
    }
}
