#pragma once

#include "impero_def.h"

#ifdef EXPORT_IMPERO
    #define imperoL __declspec(dllexport)
#elif defined IMPORT_IMPERO
    #define imperoL __declspec(dllimport)
#else
    #define imperoL
#endif

#ifdef __cplusplus
extern "C" {
#endif

imperoL void imperoInit(imperoType type);
imperoL int imperoConnect();
imperoL int imperoIsConnected();
imperoL void imperoShutdown();
imperoL void imperoSetFirmwarePath(const char* path);
imperoL void imperoSetCallback(IMPERO_CALLBACK fn, void* prm);
imperoL void imperoSetBacklight(int status);
imperoL void imperoSetAllLEDs(imperoLED state);
imperoL void imperoSetLEDTouch(int buttonID, imperoLED state);
imperoL void imperoSetLEDArrakis(std::string buttonID, imperoLED state);
imperoL void imperoGetTgc(char* tgcval);

#ifdef __cplusplus
}
#endif
