////////////////////////////////////////////////////////////////////////////////
///@file impero_def.h
////////////////////////////////////////////////////////////////////////////////
#pragma once

enum imperoType
{
    imperoSonixRP = 0,
    imperoSonixMDP = 1,
    imperoSonixArrakis = 2,
    imperoSonixTouch = 3
};

/// Impero events that are sent when interaction with the console occurs.
enum imperoEventType
{
    /// TGC event for when the TGC sliders are moved.
    imperoEventTGC = 0,
    /// Dial event for when a knob is twisted clockwise or counter-clockwise.
    imperoEventDial = 1,
    /// Push event for when a knob, rocker or push button is pressed or depressed.
    imperoEventPush,
    /// Touchcreen event when the touchscreen gets fingers on it
    imperoTouchEvent
};

/// LED colours that can be applied an LED.
enum imperoLED
{
    /// Sets LED off.
    imperoLEDOff = 0,
    /// Sets LED to blue.
    imperoLEDBlue = 1,
    /// Sets LED to yellow.
    imperoLEDYellow,
    /// Magical combination of both blue and yellow on ??
    imperoLEDAll
};

/// The callback used when an event occurs.
/// @param[in]      type The event type, see the enumeration for more details.
/// @param[in]      data A pointer to the data being sent back.
///                      On a TGC event, this is 8 bytes and each byte has a slider value from 0 to 255.
///                      On a dial event, this is a 4 byte integer containing the dial identifier.
///                      On a push event, this is a 4 byte integer containing the button identifier.
/// @param[in]      sz The size in bytes of the pointer data.
/// @param[in]      info Extra information sent back from the event.
///                      On a TGC event, this has no significance.
///                      On a dial event, this is the number of clicks the dial was turned.
///                      Positive values for clockwise, negative values for counter-clockwise.
///                      On a push event, this is the press or depress state.
///                      1 for pressed, 0 for depressed.
/// @param[in]      prm The callback parameter that can be optionally provided when calling setCallback()
typedef void (*IMPERO_CALLBACK)(imperoEventType type, void* data, int sz, int info, void* prm);
